/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.portletext;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletWrapper;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletJSONUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletParameterUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.RestrictPortletServletRequest;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.DirectTag;
import com.liferay.taglib.servlet.PipingServletResponse;
import com.liferay.taglib.util.PortalIncludeUtil;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class RuntimeTag
extends TagSupport
implements DirectTag {
    private static final String _ERROR_PAGE = "/html/taglib/portlet/runtime/error.jsp";
    private static final String _SETTINGS_SCOPE_DEFAULT = "portletInstance";
    private static final Log _log = LogFactoryUtil.getLog(RuntimeTag.class);
    private static final ThreadLocal<Stack<String>> _embeddedPortletIds = new CentralizedThreadLocal<Stack<String>>(RuntimeTag.class + "._embeddedPortletIds");
    private String _defaultPreferences;
    private String _instanceId;
    private boolean _persistSettings = true;
    private String _portletName;
    private PortletProvider.Action _portletProviderAction;
    private String _portletProviderClassName;
    private String _queryString;

    public static void doTag(String portletName, PageContext pageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        RuntimeTag.doTag(portletName, null, pageContext, httpServletRequest, httpServletResponse);
    }

    public static void doTag(String portletProviderClassName, PortletProvider.Action portletProviderAction, String instanceId, String queryString, String defaultPreferences, boolean persistSettings, PageContext pageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String portletId = PortletProviderUtil.getPortletId(portletProviderClassName, portletProviderAction);
        if (Validator.isNotNull(portletId)) {
            RuntimeTag.doTag(portletId, instanceId, queryString, _SETTINGS_SCOPE_DEFAULT, defaultPreferences, persistSettings, pageContext, httpServletRequest, httpServletResponse);
        } else {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Layout layout = themeDisplay.getLayout();
            if (!layout.isTypeControlPanel() && !LayoutPermissionUtil.contains(themeDisplay.getPermissionChecker(), layout, "UPDATE")) {
                return;
            }
            String errorMessage = LanguageUtil.format(httpServletRequest, "an-app-that-can-x-x-belongs-here", new Object[]{portletProviderAction.name(), portletProviderClassName}, false);
            httpServletRequest.setAttribute("liferay-portlet:runtime:errorMessage", (Object)errorMessage);
            PortalIncludeUtil.include(pageContext, _ERROR_PAGE);
        }
    }

    public static void doTag(String portletName, String queryString, PageContext pageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        RuntimeTag.doTag(portletName, queryString, null, pageContext, httpServletRequest, httpServletResponse);
    }

    public static void doTag(String portletName, String queryString, String defaultPreferences, PageContext pageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        RuntimeTag.doTag(portletName, "", queryString, _SETTINGS_SCOPE_DEFAULT, defaultPreferences, true, pageContext, httpServletRequest, httpServletResponse);
    }

    public static void doTag(String portletName, String instanceId, String queryString, String defaultPreferences, PageContext pageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        RuntimeTag.doTag(portletName, instanceId, queryString, _SETTINGS_SCOPE_DEFAULT, defaultPreferences, true, pageContext, httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doTag(String portletName, String instanceId, String queryString, String settingsScope, String defaultPreferences, boolean persistSettings, PageContext pageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        instanceId = PortalUtil.getJsSafePortletId(instanceId);
        if (pageContext != null) {
            httpServletResponse = httpServletResponse == pageContext.getResponse() ? PipingServletResponse.createPipingServletResponse(pageContext) : new PipingServletResponse((HttpServletResponse)httpServletResponse, (Writer)pageContext.getOut());
        }
        HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest(httpServletRequest);
        RestrictPortletServletRequest restrictPortletServletRequest = new RestrictPortletServletRequest(originalHttpServletRequest);
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(httpServletRequest.getParameterMap());
        String portletInstanceKey = portletName;
        if (Validator.isNotNull(instanceId)) {
            portletInstanceKey = PortletIdCodec.encode(PortletIdCodec.decodePortletName(portletName), PortletIdCodec.decodeUserId(portletName), instanceId);
        }
        if (!Objects.equals(portletInstanceKey, httpServletRequest.getParameter("p_p_id"))) {
            Set keySet = parameterMap.keySet();
            keySet.removeIf(key -> key.startsWith("p_p_"));
        }
        String portletNamespace = PortalUtil.getPortletNamespace(portletInstanceKey);
        Map originalParameterMap = originalHttpServletRequest.getParameterMap();
        for (Map.Entry entry : originalParameterMap.entrySet()) {
            String key2 = (String)entry.getKey();
            if (!key2.startsWith(portletNamespace)) continue;
            parameterMap.put(key2, (String[])entry.getValue());
        }
        queryString = PortletParameterUtil.addNamespace(portletInstanceKey, queryString);
        httpServletRequest = DynamicServletRequest.addQueryString((HttpServletRequest)restrictPortletServletRequest, parameterMap, queryString, false);
        try {
            long count;
            LayoutTypePortlet layoutTypePortlet;
            httpServletRequest.setAttribute("RENDER_PORTLET_RESOURCE", (Object)Boolean.TRUE);
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Portlet portlet = RuntimeTag.getPortlet(themeDisplay.getCompanyId(), portletInstanceKey);
            Stack<String> embeddedPortletIds = _embeddedPortletIds.get();
            if (embeddedPortletIds == null) {
                embeddedPortletIds = new Stack();
                _embeddedPortletIds.set(embeddedPortletIds);
            }
            if (embeddedPortletIds.search(portlet.getPortletId()) > -1) {
                String errorMessage = LanguageUtil.get(httpServletRequest, "the-application-cannot-include-itself");
                httpServletRequest.setAttribute("liferay-portlet:runtime:errorMessage", (Object)errorMessage);
                PortalIncludeUtil.include(pageContext, _ERROR_PAGE);
                return;
            }
            if (themeDisplay.isStateMaximized() && (layoutTypePortlet = themeDisplay.getLayoutTypePortlet()).hasStateMaxPortletId(portletInstanceKey)) {
                return;
            }
            Layout layout = themeDisplay.getLayout();
            httpServletRequest.setAttribute("SETTINGS_SCOPE", (Object)settingsScope);
            JSONObject jsonObject = null;
            boolean writeObject = false;
            if (persistSettings && !layout.isPortletEmbedded(portlet.getPortletId(), layout.getGroupId())) {
                PortletPreferencesFactoryUtil.getLayoutPortletSetup(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId(), 3, 0L, portletInstanceKey, defaultPreferences);
                writeObject = true;
            }
            if ((count = PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(3, themeDisplay.getPlid(), portletInstanceKey)) < 1L) {
                PortletPreferencesFactoryUtil.getLayoutPortletSetup(layout, portletInstanceKey, defaultPreferences);
                PortletPreferencesFactoryUtil.getPortletSetup(httpServletRequest, portletInstanceKey, defaultPreferences);
                PortletLayoutListener portletLayoutListener = portlet.getPortletLayoutListenerInstance();
                if (portletLayoutListener != null) {
                    portletLayoutListener.onAddToLayout(portletInstanceKey, themeDisplay.getPlid());
                }
                writeObject = true;
            }
            if (writeObject) {
                jsonObject = JSONFactoryUtil.createJSONObject();
                PortletJSONUtil.populatePortletJSONObject(httpServletRequest, "", portlet, jsonObject);
            }
            if (jsonObject != null) {
                PortletJSONUtil.writeHeaderPaths(httpServletResponse, jsonObject);
            }
            embeddedPortletIds.push(portletInstanceKey);
            PortletContainerUtil.render(httpServletRequest, httpServletResponse, portlet);
            embeddedPortletIds.pop();
            if (jsonObject != null) {
                PortletJSONUtil.writeFooterPaths(httpServletResponse, jsonObject);
            }
        }
        finally {
            restrictPortletServletRequest.mergeSharedAttributes();
        }
    }

    public int doEndTag() throws JspException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
            Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
            if (layout == null) {
                return 6;
            }
            HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
            if (Validator.isNotNull(this._portletProviderClassName) && this._portletProviderAction != null) {
                RuntimeTag.doTag(this._portletProviderClassName, this._portletProviderAction, this._instanceId, this._queryString, this._defaultPreferences, this._persistSettings, this.pageContext, httpServletRequest, httpServletResponse);
            } else {
                RuntimeTag.doTag(this._portletName, this._instanceId, this._queryString, _SETTINGS_SCOPE_DEFAULT, this._defaultPreferences, this._persistSettings, this.pageContext, httpServletRequest, httpServletResponse);
            }
            return 6;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new JspException((Throwable)e);
        }
    }

    public void setDefaultPreferences(String defaultPreferences) {
        this._defaultPreferences = defaultPreferences;
    }

    public void setInstanceId(String instanceId) {
        this._instanceId = instanceId;
    }

    public void setPersistSettings(boolean persistSettings) {
        this._persistSettings = persistSettings;
    }

    public void setPortletName(String portletName) {
        this._portletName = portletName;
    }

    public void setPortletProviderAction(PortletProvider.Action portletProviderAction) {
        this._portletProviderAction = portletProviderAction;
    }

    public void setPortletProviderClassName(String portletProviderClassName) {
        this._portletProviderClassName = portletProviderClassName;
    }

    public void setQueryString(String queryString) {
        this._queryString = queryString;
    }

    @Deprecated
    public void setSettingsScope(String settingsScope) {
    }

    protected static Portlet getPortlet(long companyId, String portletId) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById(companyId, portletId);
        if (!portlet.isInstanceable()) {
            portlet = new PortletWrapper(portlet){
                private boolean _staticPortlet;

                @Override
                public boolean getStatic() {
                    return this._staticPortlet;
                }

                @Override
                public boolean isStatic() {
                    return this._staticPortlet;
                }

                @Override
                public void setStatic(boolean staticPortlet) {
                    this._staticPortlet = staticPortlet;
                }
            };
        }
        portlet.setStatic(true);
        return portlet;
    }
}

