/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.DummyPortletURL;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.ParamAndPropertyAncestorTagImpl;
import com.liferay.taglib.util.TypedParamAccessorTag;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class ActionURLTag
extends ParamAndPropertyAncestorTagImpl
implements TypedParamAccessorTag {
    private static final String _ACTION_PARAMETER_NAMESPACE = "p_action_p_";
    private static final Log _log = LogFactoryUtil.getLog(ActionURLTag.class);
    private Boolean _anchor;
    private String _cacheability;
    private Boolean _copyCurrentRenderParameters;
    private long _doAsGroupId;
    private long _doAsUserId;
    private Boolean _encrypt;
    private Boolean _escapeXml;
    private String _name;
    private long _plid = 0L;
    private Boolean _portletConfiguration;
    private String _portletMode;
    private String _portletName;
    private long _refererPlid = 0L;
    private String _resourceID;
    private Boolean _secure;
    private String _var;
    private String _varImpl;
    private String _windowState;

    public static PortletURL doTag(String lifecycle, String windowState, String portletMode, Boolean secure, Boolean copyCurrentRenderParameters, Boolean escapeXml, String name, String resourceID, String cacheability, long plid, long refererPlid, String portletName, Boolean anchor, Boolean encrypt, long doAsGroupId, long doAsUserId, Boolean portletConfiguration, Map<String, String[]> parameterMap, Set<String> removedParameterNames, HttpServletRequest httpServletRequest) throws Exception {
        LiferayPortletURL liferayPortletURL;
        if (portletName == null) {
            portletName = ActionURLTag._getPortletName(httpServletRequest);
        }
        if ((liferayPortletURL = ActionURLTag._getLiferayPortletURL(httpServletRequest, plid, portletName, lifecycle, copyCurrentRenderParameters)) == null) {
            _log.error("Render response is null because this tag is not being called within the context of a portlet");
            return DummyPortletURL.getInstance();
        }
        if (Validator.isNotNull(windowState)) {
            liferayPortletURL.setWindowState(WindowStateFactory.getWindowState(windowState));
        }
        if (Validator.isNotNull(portletMode)) {
            liferayPortletURL.setPortletMode(PortletModeFactory.getPortletMode(portletMode));
        }
        if (secure != null) {
            liferayPortletURL.setSecure(secure);
        } else {
            liferayPortletURL.setSecure(PortalUtil.isSecure(httpServletRequest));
        }
        if (copyCurrentRenderParameters != null) {
            liferayPortletURL.setCopyCurrentRenderParameters(copyCurrentRenderParameters);
        }
        if (escapeXml != null) {
            liferayPortletURL.setEscapeXml(escapeXml);
        }
        if (lifecycle.equals("ACTION_PHASE") && Validator.isNotNull(name)) {
            liferayPortletURL.setParameter("javax.portlet.action", name);
        }
        if (resourceID != null) {
            liferayPortletURL.setResourceID(resourceID);
        }
        if (cacheability != null) {
            liferayPortletURL.setCacheability(cacheability);
        }
        if (refererPlid > 0L) {
            liferayPortletURL.setRefererPlid(refererPlid);
        }
        if (anchor != null) {
            liferayPortletURL.setAnchor(anchor);
        }
        if (encrypt != null) {
            liferayPortletURL.setEncrypt(encrypt);
        }
        if (doAsGroupId > 0L) {
            liferayPortletURL.setDoAsGroupId(doAsGroupId);
        }
        if (doAsUserId > 0L) {
            liferayPortletURL.setDoAsUserId(doAsUserId);
        }
        String settingsScope = null;
        if (portletConfiguration != null && portletConfiguration.booleanValue()) {
            String returnToFullPageURL = ParamUtil.getString(httpServletRequest, "returnToFullPageURL");
            String portletResource = ParamUtil.getString(httpServletRequest, "portletResource");
            String previewWidth = ParamUtil.getString(httpServletRequest, "previewWidth");
            settingsScope = ParamUtil.getString(httpServletRequest, "settingsScope", "portletInstance");
            if (Validator.isNull(name)) {
                liferayPortletURL.setParameter("javax.portlet.action", "editConfiguration");
            }
            liferayPortletURL.setParameter("mvcPath", "/edit_configuration.jsp");
            liferayPortletURL.setParameter("returnToFullPageURL", returnToFullPageURL);
            liferayPortletURL.setParameter("portletConfiguration", Boolean.TRUE.toString());
            liferayPortletURL.setParameter("portletResource", portletResource);
            liferayPortletURL.setParameter("previewWidth", previewWidth);
        }
        if (parameterMap != null) {
            for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                String portletNamespace;
                String key = entry.getKey();
                if (key.startsWith(_ACTION_PARAMETER_NAMESPACE) && !(key = key.substring(_ACTION_PARAMETER_NAMESPACE.length())).startsWith(portletNamespace = PortalUtil.getPortletNamespace(portletName))) {
                    key = portletNamespace.concat(key);
                }
                liferayPortletURL.setParameter(key, entry.getValue(), false);
            }
        }
        if (!(settingsScope == null || parameterMap != null && parameterMap.containsKey("settingsScope"))) {
            liferayPortletURL.setParameter("settingsScope", settingsScope);
        }
        liferayPortletURL.setRemovedParameterNames(removedParameterNames);
        return liferayPortletURL;
    }

    @Override
    public void addParam(String name, String type, String value) {
        if (Validator.isNotNull(name)) {
            if (Objects.equals(type, "action")) {
                name = _ACTION_PARAMETER_NAMESPACE.concat(name);
            } else if (Objects.equals(type, "render")) {
                name = "priv_r_p_".concat(name);
            }
        }
        super.addParam(name, value);
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            PortletURL portletURL = ActionURLTag.doTag(this.getLifecycle(), this._windowState, this._portletMode, this._secure, this._copyCurrentRenderParameters, this._escapeXml, this._name, this._resourceID, this._cacheability, this._plid, this._refererPlid, this._portletName, this._anchor, this._encrypt, this._doAsGroupId, this._doAsUserId, this._portletConfiguration, this.getParams(), this.getRemovedParameterNames(), (HttpServletRequest)this.pageContext.getRequest());
            if (Validator.isNotNull(this._var)) {
                this.pageContext.setAttribute(this._var, (Object)portletURL.toString());
            } else if (Validator.isNotNull(this._varImpl)) {
                this.pageContext.setAttribute(this._varImpl, (Object)portletURL);
            } else {
                JspWriter jspWriter = this.pageContext.getOut();
                jspWriter.write(portletURL.toString());
            }
            int n = 6;
            return n;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.clearParams();
            this.clearProperties();
            this._plid = 0L;
        }
    }

    @Override
    public int doStartTag() {
        return 1;
    }

    public String getLifecycle() {
        return "ACTION_PHASE";
    }

    public void setAnchor(boolean anchor) {
        this._anchor = anchor;
    }

    public void setCacheability(String cacheability) {
        this._cacheability = cacheability;
    }

    @Override
    public void setCopyCurrentRenderParameters(boolean copyCurrentRenderParameters) {
        super.setCopyCurrentRenderParameters(copyCurrentRenderParameters);
        this._copyCurrentRenderParameters = copyCurrentRenderParameters;
    }

    public void setDoAsGroupId(long doAsGroupId) {
        this._doAsGroupId = doAsGroupId;
    }

    public void setDoAsUserId(long doAsUserId) {
        this._doAsUserId = doAsUserId;
    }

    public void setEncrypt(boolean encrypt) {
        this._encrypt = encrypt;
    }

    public void setEscapeXml(boolean escapeXml) {
        this._escapeXml = escapeXml;
    }

    public void setId(String resourceID) {
        this._resourceID = resourceID;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    public void setPortletConfiguration(boolean portletConfiguration) {
        this._portletConfiguration = portletConfiguration;
    }

    public void setPortletMode(String portletMode) {
        this._portletMode = portletMode;
    }

    public void setPortletName(String portletName) {
        this._portletName = portletName;
    }

    public void setRefererPlid(long refererPlid) {
        this._refererPlid = refererPlid;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setVarImpl(String varImpl) {
        this._varImpl = varImpl;
    }

    public void setWindowState(String windowState) {
        this._windowState = windowState;
    }

    private static LiferayPortletURL _getLiferayPortletURL(HttpServletRequest httpServletRequest, long plid, String portletName, String lifecycle, Boolean copyCurrentRenderParameters) {
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        if (portletRequest == null) {
            return null;
        }
        PortletResponse portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
        LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse(portletResponse);
        if (copyCurrentRenderParameters != null && copyCurrentRenderParameters.booleanValue() || lifecycle.equals("RESOURCE_PHASE")) {
            return liferayPortletResponse.createLiferayPortletURL(plid, portletName, lifecycle, MimeResponse.Copy.ALL);
        }
        return liferayPortletResponse.createLiferayPortletURL(plid, portletName, lifecycle);
    }

    private static String _getPortletName(HttpServletRequest httpServletRequest) {
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        if (portletRequest == null) {
            return null;
        }
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)httpServletRequest.getAttribute("javax.portlet.config");
        return liferayPortletConfig.getPortletId();
    }
}

