/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.servlet.taglib.aui.ValidatorTag;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.BaseValidatorTagSupport;
import com.liferay.taglib.aui.base.BaseValidatorTagImpl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;

public class ValidatorTagImpl
extends BaseValidatorTagImpl
implements BodyTag,
ValidatorTag {
    private String _body;
    private boolean _custom;

    public ValidatorTagImpl() {
    }

    public ValidatorTagImpl(String name, String errorMessage, String body, boolean custom) {
        this.setName(name);
        this.setErrorMessage(errorMessage);
        this._body = body;
        this._custom = custom;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this._body = null;
        this._custom = false;
    }

    @Override
    public int doAfterBody() {
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent != null) {
            this._body = bodyContent.getString();
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        BaseValidatorTagSupport baseValidatorTagSupport = (BaseValidatorTagSupport)ValidatorTagImpl.findAncestorWithClass(this, BaseValidatorTagSupport.class);
        String name = this.getName();
        this._custom = ModelHintsUtil.isCustomValidator(name);
        if (this._custom) {
            StringBundler sb = new StringBundler(3);
            String namespace = baseValidatorTagSupport.getInputName();
            sb.append(namespace);
            sb.append("_");
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
            sb.append(PortalUtil.getUniqueElementId(httpServletRequest, namespace, name));
            name = sb.toString();
        }
        ValidatorTagImpl validatorTag = new ValidatorTagImpl(name, this.getErrorMessage(), this._body, this._custom);
        baseValidatorTagSupport.addValidatorTag(name, validatorTag);
        return 2;
    }

    @Override
    public String getBody() {
        if (Validator.isNull(this._body)) {
            return "''";
        }
        return this._body.trim();
    }

    @Override
    public String getErrorMessage() {
        String errorMessage = super.getErrorMessage();
        if (errorMessage == null) {
            return "";
        }
        return errorMessage;
    }

    @Override
    public boolean isCustom() {
        return this._custom;
    }

    public void setBody(String body) {
        this._body = body;
    }
}

