/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.aui.AUIUtil;
import com.liferay.taglib.aui.NavBarTag;
import com.liferay.taglib.aui.base.BaseNavItemTag;
import com.liferay.taglib.util.TagResourceBundleUtil;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTag;

public class NavItemTag
extends BaseNavItemTag
implements BodyTag {
    @Override
    public int doStartTag() throws JspException {
        NavBarTag navBarTag = (NavBarTag)NavItemTag.findAncestorWithClass(this, NavBarTag.class);
        if (navBarTag != null && this.getSelected()) {
            String title = this.getTitle();
            if (Validator.isNull(title)) {
                title = this.getLabel();
            }
            navBarTag.setSelectedItemName(title);
        }
        super.doStartTag();
        return 2;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        super.setAttributes(httpServletRequest);
        if (!this.getUseDialog() && AUIUtil.isOpensNewWindow(this.getTarget())) {
            String title = this.getTitle();
            if (title == null) {
                title = "";
            }
            ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
            title = title.concat(LanguageUtil.get(resourceBundle, "opens-new-window"));
            this.setNamespacedAttribute(httpServletRequest, "title", String.valueOf(title));
        }
    }
}

