/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.servlet.taglib.aui.ValidatorTag;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.aui.AUIUtil;
import com.liferay.taglib.aui.FieldWrapperTag;
import com.liferay.taglib.aui.FormTag;
import com.liferay.taglib.aui.ValidatorTagImpl;
import com.liferay.taglib.aui.base.BaseInputTag;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class InputTag
extends BaseInputTag {
    private static final boolean _CLEAN_UP_SET_ATTRIBUTES = true;

    @Override
    public int doEndTag() throws JspException {
        this.updateFormCheckboxNames();
        return super.doEndTag();
    }

    @Override
    public int doStartTag() throws JspException {
        this.addModelValidatorTags();
        if (this.getRequired()) {
            this.addRequiredValidatorTag();
        }
        return super.doStartTag();
    }

    public String getBaseType() {
        Class<?> model = this.getModel();
        String type = this.getType();
        String baseType = null;
        if (model != null && Validator.isNull(type)) {
            baseType = ModelHintsUtil.getType(model.getName(), this.getField());
        } else if (Validator.isNotNull(type)) {
            if (Objects.equals(type, "checkbox") || Objects.equals(type, "radio") || Objects.equals(type, "resource")) {
                baseType = type;
            } else if (Objects.equals(type, "toggle-card") || Objects.equals(type, "toggle-switch")) {
                baseType = "checkbox";
            }
        }
        if (Validator.isNull(baseType)) {
            baseType = "text";
        }
        return baseType;
    }

    @Override
    public String getField() {
        String field = super.getField();
        if (Validator.isNull(field)) {
            field = this.getName();
        }
        return field;
    }

    @Override
    public String getInputName() {
        String fieldParam;
        String inputName = this.getName();
        Class<?> model = this.getModel();
        String type = this.getType();
        if (model != null && Validator.isNull(type) && Validator.isNotNull(fieldParam = this.getFieldParam())) {
            inputName = fieldParam;
        }
        return inputName;
    }

    @Override
    public Class<?> getModel() {
        Class model = super.getModel();
        if (model == null) {
            model = (Class)this.pageContext.getAttribute("aui:model-context:model");
        }
        return model;
    }

    protected void addModelValidatorTags() {
        Class<?> model = this.getModel();
        if (model == null || Validator.isNotNull(this.getType())) {
            return;
        }
        List<Tuple> modelValidators = ModelHintsUtil.getValidators(model.getName(), this.getField());
        if (modelValidators == null) {
            return;
        }
        for (Tuple modelValidator : modelValidators) {
            String validatorName = (String)modelValidator.getObject(1);
            String validatorErrorMessage = (String)modelValidator.getObject(2);
            String validatorValue = (String)modelValidator.getObject(3);
            boolean customValidator = (Boolean)modelValidator.getObject(4);
            ValidatorTagImpl validatorTag = new ValidatorTagImpl(validatorName, validatorErrorMessage, validatorValue, customValidator);
            this.addValidatorTag(validatorName, validatorTag);
        }
    }

    @Override
    protected boolean isCleanUpSetAttributes() {
        return true;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        String title;
        String label;
        String languageId;
        FormTag formTag;
        String formName;
        String field;
        String name;
        int pos;
        super.setAttributes(httpServletRequest);
        Object bean = this.getBean();
        if (bean == null) {
            bean = this.pageContext.getAttribute("aui:model-context:bean");
        }
        Class<?> model = this.getModel();
        String defaultLanguageId = this.getDefaultLanguageId();
        if (Validator.isNull(defaultLanguageId)) {
            defaultLanguageId = (String)this.pageContext.getAttribute("aui:model-context:defaultLanguageId");
        }
        if (Validator.isNull(defaultLanguageId) && model != null && ModelHintsUtil.hasField(model.getName(), "groupId")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            defaultLanguageId = LocaleUtil.toLanguageId(themeDisplay.getSiteDefaultLocale());
        }
        if (Validator.isNull(defaultLanguageId)) {
            Locale defaultLocale = LocaleUtil.getDefault();
            defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);
        }
        if ((pos = (name = this.getName()).indexOf("--")) != -1) {
            name = name.substring(pos + 2, name.length() - 2);
        }
        if (Validator.isNull(field = this.getField())) {
            field = this.getName();
        }
        if ((formName = this.getFormName()) == null && (formTag = (FormTag)InputTag.findAncestorWithClass(this, FormTag.class)) != null) {
            formName = formTag.getName();
        }
        String id = this.getId();
        String type = this.getType();
        if (Validator.isNull(id)) {
            String fieldParam = this.getFieldParam();
            id = model != null && Validator.isNull(type) && Validator.isNotNull(fieldParam) ? AUIUtil.normalizeId(fieldParam) : (!Objects.equals(type, "assetTags") && !Objects.equals(type, "radio") ? AUIUtil.normalizeId(name) : PortalUtil.getUniqueElementId(httpServletRequest, "", AUIUtil.normalizeId(name)));
        }
        String forLabel = id;
        if (Objects.equals(type, "assetTags")) {
            forLabel = forLabel.concat("assetTagNames");
        }
        if (Validator.isNotNull(languageId = this.getLanguageId())) {
            forLabel = LocalizationUtil.getLocalizedName(forLabel, languageId);
        }
        if ((label = this.getLabel()) == null) {
            label = TextFormatter.format(name, 10);
        }
        if ((title = this.getTitle()) == null && (Validator.isNull(label) || Objects.equals(type, "image"))) {
            title = TextFormatter.format(name, 10);
        }
        boolean wrappedField = this.getWrappedField();
        FieldWrapperTag fieldWrapper = (FieldWrapperTag)InputTag.findAncestorWithClass(this, FieldWrapperTag.class);
        if (fieldWrapper != null) {
            wrappedField = true;
        }
        this.setNamespacedAttribute(httpServletRequest, "baseType", this.getBaseType());
        this.setNamespacedAttribute(httpServletRequest, "bean", bean);
        this.setNamespacedAttribute(httpServletRequest, "defaultLanguageId", defaultLanguageId);
        this.setNamespacedAttribute(httpServletRequest, "field", field);
        this.setNamespacedAttribute(httpServletRequest, "forLabel", forLabel);
        this.setNamespacedAttribute(httpServletRequest, "formName", formName);
        this.setNamespacedAttribute(httpServletRequest, "id", id);
        this.setNamespacedAttribute(httpServletRequest, "label", label);
        this.setNamespacedAttribute(httpServletRequest, "model", model);
        this.setNamespacedAttribute(httpServletRequest, "title", String.valueOf(title));
        this.setNamespacedAttribute(httpServletRequest, "wrappedField", wrappedField);
        httpServletRequest.setAttribute(this.getAttributeNamespace() + "value", this.getValue());
        Map<String, ValidatorTag> validatorTags = this.getValidatorTags();
        if (validatorTags != null && validatorTags.get("required") != null) {
            this.setNamespacedAttribute(httpServletRequest, "required", Boolean.TRUE.toString());
        }
    }

    protected void updateFormCheckboxNames() {
        if (!Objects.equals(this.getBaseType(), "checkbox")) {
            return;
        }
        List checkboxNames = (List)this.request.getAttribute("LIFERAY_SHARED_aui:form:checkboxNames");
        if (checkboxNames != null) {
            String inputName = this.getInputName();
            String languageId = this.getLanguageId();
            if (Validator.isNotNull(languageId)) {
                inputName = LocalizationUtil.getLocalizedName(inputName, languageId);
            }
            checkboxNames.add(inputName);
        }
    }
}

