/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.aui.AUIUtil;
import com.liferay.taglib.aui.FieldsetGroupTag;
import com.liferay.taglib.aui.base.BaseFieldsetTag;
import com.liferay.taglib.ui.IconHelpTag;
import com.liferay.taglib.ui.MessageTag;
import com.liferay.taglib.util.InlineUtil;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class FieldsetTag
extends BaseFieldsetTag {
    private static final boolean _CLEAN_UP_SET_ATTRIBUTES = true;

    @Override
    public int doStartTag() throws JspException {
        FieldsetGroupTag fieldsetGroupTag = (FieldsetGroupTag)FieldsetTag.findAncestorWithClass(this, FieldsetGroupTag.class);
        if (Validator.isNull(this.getMarkupView()) && fieldsetGroupTag != null) {
            this.setMarkupView(fieldsetGroupTag.getMarkupView());
        }
        return super.doStartTag();
    }

    @Override
    protected String getEndPage() {
        if (Validator.isNotNull(this.getMarkupView())) {
            return "/html/taglib/aui/fieldset/" + this.getMarkupView() + "/end.jsp";
        }
        return "/html/taglib/aui/fieldset/end.jsp";
    }

    @Override
    protected String getStartPage() {
        if (Validator.isNotNull(this.getMarkupView())) {
            return "/html/taglib/aui/fieldset/" + this.getMarkupView() + "/start.jsp";
        }
        return "/html/taglib/aui/fieldset/start.jsp";
    }

    @Override
    protected boolean isCleanUpSetAttributes() {
        return true;
    }

    @Override
    protected int processEndTag() throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        jspWriter.write("</div></fieldset>");
        return 6;
    }

    @Override
    protected int processStartTag() throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        jspWriter.write("<fieldset class=\"fieldset ");
        jspWriter.write(GetterUtil.getString(this.getCssClass()));
        jspWriter.write("\" ");
        String id = this.getId();
        if (id != null) {
            jspWriter.write("id=\"");
            jspWriter.write(id);
            jspWriter.write("\" ");
        }
        jspWriter.write(InlineUtil.buildDynamicAttributes(this.getDynamicAttributes()));
        jspWriter.write(">");
        String lable = this.getLabel();
        if (lable != null) {
            jspWriter.write("<legend class=\"fieldset-legend\"><span class=\"legend\">");
            MessageTag messageTag = new MessageTag();
            messageTag.setKey(lable);
            messageTag.setLocalizeKey(this.getLocalizeLabel());
            messageTag.doTag(this.pageContext);
            String helpMessage = this.getHelpMessage();
            if (helpMessage != null) {
                IconHelpTag iconHelpTag = new IconHelpTag();
                iconHelpTag.setMessage(helpMessage);
                iconHelpTag.doTag(this.pageContext);
            }
            jspWriter.write("</span></legend>");
        }
        if (this.getColumn()) {
            jspWriter.write("<div class=\"row\">");
        } else {
            jspWriter.write("<div class=\"\">");
        }
        return 1;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        if (Validator.isNull(this.getId()) && Validator.isNotNull(this.getLabel()) && this.getCollapsible()) {
            String id = PortalUtil.getUniqueElementId(httpServletRequest, this._getNamespace(), AUIUtil.normalizeId(this.getLabel()));
            this.setId(this._getNamespace() + id);
        }
        super.setAttributes(httpServletRequest);
    }

    private String _getNamespace() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        PortletResponse portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
        if (portletResponse != null) {
            return portletResponse.getNamespace();
        }
        return "";
    }
}

