/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class AUIUtil {
    public static final String BUTTON_PREFIX = "btn";
    public static final String FIELD_PREFIX = "field";
    private static final boolean[] _VALID_CHARS;

    public static String buildControlGroupCss(boolean inlineField, String inlineLabel, String wrapperCssClass, String baseType) {
        StringBundler sb = new StringBundler(8);
        sb.append("form-group");
        if (inlineField) {
            sb.append(" form-group-inline");
        }
        if (Validator.isNotNull(inlineLabel)) {
            sb.append(" form-inline");
        }
        if (Validator.isNotNull(wrapperCssClass)) {
            sb.append(" ");
            sb.append(wrapperCssClass);
        }
        if (Validator.isNotNull(baseType)) {
            sb.append(" input-");
            sb.append(baseType);
            sb.append("-wrapper");
        }
        return sb.toString();
    }

    public static String buildCss(String prefix, boolean disabled, boolean first, boolean last, String cssClass) {
        StringBundler sb = new StringBundler(7);
        sb.append(prefix);
        if (disabled) {
            sb.append(" disabled");
        }
        if (first) {
            sb.append(" ");
            sb.append(prefix);
            sb.append("-first");
        } else if (last) {
            sb.append(" ");
            sb.append(prefix);
            sb.append("-last");
        }
        if (Validator.isNotNull(cssClass)) {
            sb.append(" ");
            sb.append(cssClass);
        }
        return sb.toString();
    }

    public static String buildData(Map<String, Object> data) {
        return HtmlUtil.buildData(data);
    }

    public static String buildLabel(String baseType, boolean inlineField, boolean showForLabel, String forLabel) {
        return AUIUtil.buildLabel(baseType, inlineField, showForLabel, forLabel, false);
    }

    public static String buildLabel(String baseType, boolean inlineField, boolean showForLabel, String forLabel, boolean disabled) {
        StringBundler sb = new StringBundler(6);
        if (baseType.equals("boolean")) {
            baseType = "checkbox";
        }
        if (baseType.equals("checkbox") || baseType.equals("radio")) {
            if (inlineField) {
                sb.append("class=\"");
                sb.append(baseType);
                sb.append("-inline\"");
            }
        } else {
            sb.append("class=\"control-label");
            if (disabled) {
                sb.append(" disabled");
            }
            sb.append("\"");
        }
        if (showForLabel) {
            sb.append(" for=\"");
            sb.append(HtmlUtil.escapeAttribute(forLabel));
            sb.append("\"");
        }
        return sb.toString();
    }

    public static Object getAttribute(HttpServletRequest httpServletRequest, String namespace, String key) {
        Map dynamicAttributes = (Map)httpServletRequest.getAttribute(namespace.concat("dynamicAttributes"));
        if (dynamicAttributes != null && dynamicAttributes.containsKey(key)) {
            return httpServletRequest.getAttribute(namespace.concat(key));
        }
        return null;
    }

    public static String getNamespace(HttpServletRequest httpServletRequest) {
        return GetterUtil.getString(httpServletRequest.getAttribute("aui:form:portletNamespace"));
    }

    public static String getNamespace(PortletRequest portletRequest, PortletResponse portletResponse) {
        String namespace = "";
        if (portletRequest == null) {
            return namespace;
        }
        boolean auiFormUseNamespace = GetterUtil.getBoolean((String)portletRequest.getAttribute("aui:form:useNamespace"), true);
        if (portletResponse != null && auiFormUseNamespace) {
            namespace = GetterUtil.getString(portletRequest.getAttribute("aui:form:portletNamespace"), portletResponse.getNamespace());
        }
        return namespace;
    }

    public static boolean isOpensNewWindow(String target) {
        return target != null && (target.equals("_blank") || target.equals("_new"));
    }

    public static String normalizeId(String name) {
        char[] chars = null;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (_VALID_CHARS.length > c && _VALID_CHARS[c]) continue;
            if (chars == null) {
                chars = new char[name.length()];
                name.getChars(0, chars.length, chars, 0);
            }
            chars[i] = 45;
        }
        if (chars == null) {
            return name;
        }
        return new String(chars);
    }

    static {
        int i;
        _VALID_CHARS = new boolean[128];
        for (i = 97; i <= 122; ++i) {
            AUIUtil._VALID_CHARS[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            AUIUtil._VALID_CHARS[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            AUIUtil._VALID_CHARS[i] = true;
        }
        AUIUtil._VALID_CHARS[45] = true;
        AUIUtil._VALID_CHARS[95] = true;
    }
}

