/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.aui.AUIUtil;
import com.liferay.taglib.aui.base.BaseATag;
import com.liferay.taglib.util.InlineUtil;
import com.liferay.taglib.util.TagResourceBundleUtil;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;

public class ATag
extends BaseATag {
    @Override
    protected int processEndTag() throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        if (Validator.isNotNull(this.getHref())) {
            if (AUIUtil.isOpensNewWindow(this.getTarget())) {
                ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
                jspWriter.write(" ");
                jspWriter.write("<svg class=\"lexicon-icon ");
                jspWriter.write("lexicon-icon-shortcut\" focusable=\"false\" ");
                jspWriter.write("role=\"img\"><use data-href=\"");
                jspWriter.write(themeDisplay.getPathThemeImages());
                jspWriter.write("/lexicon/icons.svg#shortcut\" /><span ");
                jspWriter.write("class=\"sr-only\">");
                String opensNewWindowLabel = LanguageUtil.get(resourceBundle, "opens-new-window");
                jspWriter.write(opensNewWindowLabel);
                jspWriter.write("</span>");
                jspWriter.write("<title>");
                jspWriter.write(opensNewWindowLabel);
                jspWriter.write("</title>");
                jspWriter.write("</svg>");
            }
            jspWriter.write("</a>");
        } else {
            jspWriter.write("</span>");
        }
        return 6;
    }

    @Override
    protected int processStartTag() throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        String ariaRole = this.getAriaRole();
        String cssClass = this.getCssClass();
        Map<String, Object> data = this.getData();
        String href = this.getHref();
        String id = this.getId();
        String iconCssClass = this.getIconCssClass();
        String label = this.getLabel();
        String lang = this.getLang();
        String onClick = this.getOnClick();
        String title = this.getTitle();
        if (Validator.isNotNull(href)) {
            jspWriter.write("<a ");
            jspWriter.write("href=\"");
            jspWriter.write(HtmlUtil.escapeAttribute(href));
            jspWriter.write("\" ");
            String target = this.getTarget();
            if (Validator.isNotNull(target)) {
                jspWriter.write("target=\"");
                jspWriter.write(target);
                jspWriter.write("\" ");
            }
        } else {
            jspWriter.write("<span ");
        }
        if (Validator.isNotNull(cssClass)) {
            jspWriter.write("class=\"");
            jspWriter.write(cssClass);
            jspWriter.write("\" ");
        }
        if (Validator.isNotNull(id)) {
            jspWriter.write("id=\"");
            jspWriter.write(this._getNamespace());
            jspWriter.write(id);
            jspWriter.write("\" ");
        }
        if (Validator.isNotNull(lang)) {
            jspWriter.write("lang=\"");
            jspWriter.write(lang);
            jspWriter.write("\" ");
        }
        if (Validator.isNotNull(onClick)) {
            jspWriter.write("onClick=\"");
            jspWriter.write(onClick);
            jspWriter.write("\" ");
        }
        if (Validator.isNotNull(ariaRole)) {
            jspWriter.write("role=\"");
            jspWriter.write(ariaRole);
            jspWriter.write("\" ");
        }
        if (Validator.isNotNull(title)) {
            ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
            jspWriter.write("title=\"");
            if (Validator.isNotNull(title)) {
                jspWriter.write(LanguageUtil.get(resourceBundle, title));
            }
            jspWriter.write("\" ");
        }
        if (data != null && !data.isEmpty()) {
            jspWriter.write(AUIUtil.buildData(data));
        }
        this._writeDynamicAttributes(jspWriter);
        jspWriter.write(">");
        if (Validator.isNotNull(label)) {
            Boolean localizeLabel = this.getLocalizeLabel();
            if (localizeLabel.booleanValue()) {
                ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
                jspWriter.write(LanguageUtil.get(resourceBundle, label));
            } else {
                jspWriter.write(label);
            }
        }
        if (Validator.isNotNull(iconCssClass)) {
            jspWriter.write("<span class=\"icon-monospaced ");
            jspWriter.write(iconCssClass);
            jspWriter.write("\"></span>");
        }
        return 1;
    }

    private String _getNamespace() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        PortletResponse portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
        if (portletResponse == null) {
            return "";
        }
        if (GetterUtil.getBoolean((String)httpServletRequest.getAttribute("aui:form:useNamespace"), true)) {
            return portletResponse.getNamespace();
        }
        return "";
    }

    private void _writeDynamicAttributes(JspWriter jspWriter) throws IOException {
        String dynamicAttributesString = InlineUtil.buildDynamicAttributes(this.getDynamicAttributes());
        if (!dynamicAttributesString.isEmpty()) {
            jspWriter.write(dynamicAttributesString);
        }
    }
}

