/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;

public class BodyContentWrapper
extends BodyContent
implements com.liferay.portal.kernel.servlet.taglib.BodyContentWrapper {
    private static final String _LINE_SEPARATOR = System.getProperty("line.separator");
    private final StringBundler _sb;

    public BodyContentWrapper(BodyContent bodyContent, UnsyncStringWriter unsyncStringWriter) {
        super(bodyContent.getEnclosingWriter());
        this._sb = unsyncStringWriter.getStringBundler();
    }

    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    public Writer append(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            this._sb.append("null");
        } else {
            this._sb.append(charSequence.toString());
        }
        return this;
    }

    public Writer append(CharSequence charSequence, int start, int end) throws IOException {
        if (charSequence == null) {
            this._sb.append("null");
        } else {
            charSequence = charSequence.subSequence(start, end);
            this._sb.append(charSequence.toString());
        }
        return this;
    }

    public void clear() throws IOException {
        this._sb.setIndex(0);
    }

    public void clearBody() {
        this._sb.setIndex(0);
    }

    public void clearBuffer() {
        this._sb.setIndex(0);
    }

    public void close() throws IOException {
        this._sb.setIndex(0);
    }

    public void flush() throws IOException {
        throw new IOException("Illegal to flush within a custom tag");
    }

    public int getBufferSize() {
        return 0;
    }

    public JspWriter getEnclosingWriter() {
        return super.getEnclosingWriter();
    }

    public Reader getReader() {
        return new UnsyncStringReader(this._sb.toString());
    }

    public int getRemaining() {
        return 0;
    }

    public String getString() {
        return this._sb.toString();
    }

    @Override
    public StringBundler getStringBundler() {
        return this._sb;
    }

    public boolean isAutoFlush() {
        return false;
    }

    public void newLine() throws IOException {
        this._sb.append(_LINE_SEPARATOR);
    }

    public void print(boolean b) throws IOException {
        this._sb.append(String.valueOf(b));
    }

    public void print(char c) throws IOException {
        this._sb.append(String.valueOf(c));
    }

    public void print(char[] chars) throws IOException {
        this._sb.append(new String(chars));
    }

    public void print(double d) throws IOException {
        this._sb.append(String.valueOf(d));
    }

    public void print(float f) throws IOException {
        this._sb.append(String.valueOf(f));
    }

    public void print(int i) throws IOException {
        this._sb.append(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this._sb.append(String.valueOf(l));
    }

    public void print(Object object) throws IOException {
        this._sb.append(String.valueOf(object));
    }

    public void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        this._sb.append(string);
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.newLine();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(char[] chars) throws IOException {
        this.write(chars);
        this.newLine();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.newLine();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.newLine();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.newLine();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.newLine();
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.newLine();
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.newLine();
    }

    public void write(char[] chars) throws IOException {
        this._sb.append(new String(chars));
    }

    public void write(char[] chars, int offset, int length) throws IOException {
        this._sb.append(new String(chars, offset, length));
    }

    public void write(int c) throws IOException {
        if (c <= 127) {
            this._sb.append(StringPool.ASCII_TABLE[c]);
        } else {
            this._sb.append(String.valueOf(c));
        }
    }

    public void write(String string) throws IOException {
        this._sb.append(string);
    }

    public void write(String string, int offset, int length) throws IOException {
        this._sb.append(string.substring(offset, offset + length));
    }

    public void writeOut(Writer writer) throws IOException {
        this._sb.writeTo(writer);
    }
}

