/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.staging.taglib.servlet.taglib;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.staging.taglib.internal.servlet.ServletContextUtil;
import com.liferay.taglib.util.IncludeTag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DefineObjectsTag
extends IncludeTag {
    private String _portletId;

    @Override
    public int doStartTag() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong(httpServletRequest, "groupId");
        Group group = GroupLocalServiceUtil.fetchGroup(groupId);
        if (group == null) {
            group = (Group)httpServletRequest.getAttribute("GROUP");
        }
        if (group == null) {
            group = themeDisplay.getScopeGroup();
        }
        if (group == null) {
            return 0;
        }
        this.pageContext.setAttribute("group", (Object)group);
        this.pageContext.setAttribute("groupId", (Object)group.getGroupId());
        this.pageContext.setAttribute("liveGroup", null);
        this.pageContext.setAttribute("liveGroupId", (Object)0L);
        Layout layout = themeDisplay.getLayout();
        String privateLayoutString = httpServletRequest.getParameter("privateLayout");
        if (Validator.isNull(privateLayoutString)) {
            privateLayoutString = GetterUtil.getString(httpServletRequest.getAttribute("PRIVATE_LAYOUT"), null);
        }
        boolean privateLayout = GetterUtil.getBoolean(privateLayoutString, layout.isPrivateLayout());
        this.pageContext.setAttribute("privateLayout", (Object)privateLayout);
        this.pageContext.setAttribute("stagingGroup", null);
        this.pageContext.setAttribute("stagingGroupId", (Object)0L);
        if (!(group.isStaged() || group.isStagedRemotely() || group.hasLocalOrRemoteStagingGroup())) {
            return 0;
        }
        Group liveGroup = StagingUtil.getLiveGroup(group.getGroupId());
        this.pageContext.setAttribute("liveGroup", (Object)liveGroup);
        this.pageContext.setAttribute("liveGroupId", (Object)liveGroup.getGroupId());
        Group stagingGroup = null;
        if (!group.hasRemoteStagingGroup() || group.isStagedRemotely()) {
            stagingGroup = StagingUtil.getStagingGroup(group.getGroupId());
        }
        if (stagingGroup != null) {
            this.pageContext.setAttribute("stagingGroup", (Object)stagingGroup);
            this.pageContext.setAttribute("stagingGroupId", (Object)stagingGroup.getGroupId());
        }
        if (Validator.isNotNull(this._portletId)) {
            boolean stagedPortlet = liveGroup.isStagedPortlet(this._portletId);
            if (group.isStagedRemotely()) {
                stagedPortlet = stagingGroup.isStagedPortlet(this._portletId);
            }
            if (stagedPortlet) {
                this.pageContext.setAttribute("group", (Object)stagingGroup);
                this.pageContext.setAttribute("groupId", (Object)stagingGroup.getGroupId());
                this.pageContext.setAttribute("scopeGroup", (Object)stagingGroup);
                this.pageContext.setAttribute("scopeGroupId", (Object)stagingGroup.getGroupId());
            }
        }
        return 0;
    }

    public String getPortletId() {
        return this._portletId;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    @Override
    public void setPortletId(String portletId) {
        this._portletId = portletId;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._portletId = null;
    }
}

