/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.bookmarks.taglib.servlet.taglib;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.bookmarks.taglib.internal.servlet.ServletContextUtil;
import com.liferay.social.bookmarks.taglib.internal.util.SocialBookmarksRegistryUtil;
import com.liferay.taglib.util.IncludeTag;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class SocialBookmarksTag
extends IncludeTag {
    private static final String _PAGE = "/bookmarks/page.jsp";
    private static final Log _log = LogFactoryUtil.getLog(SocialBookmarksTag.class);
    private String _className;
    private long _classPK;
    private String _displayStyle;
    private int _maxInlineItems = 3;
    private String _target;
    private String _title;
    private String[] _types;
    private String _url;
    private PortletURL _urlImpl;

    @Override
    public int doEndTag() throws JspException {
        if (this._types != null && this._types.length == 0) {
            return 6;
        }
        return super.doEndTag();
    }

    @Override
    public int doStartTag() throws JspException {
        if (this._types != null && this._types.length == 0) {
            return 0;
        }
        return super.doStartTag();
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public String getDisplayStyle() {
        return this._displayStyle;
    }

    public int getMaxInlineItems() {
        return this._maxInlineItems;
    }

    public String getTarget() {
        return this._target;
    }

    public String getTitle() {
        return this._title;
    }

    public String getTypes() {
        return StringUtil.merge(this._types);
    }

    public String getUrl() {
        return this._url;
    }

    public PortletURL getUrlImpl() {
        return this._urlImpl;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setDisplayStyle(String displayStyle) {
        this._displayStyle = Validator.isNull(displayStyle) ? "inline" : displayStyle;
    }

    public void setMaxInlineItems(int maxInlineItems) {
        this._maxInlineItems = maxInlineItems;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setTypes(String types) {
        if (types != null) {
            this._types = StringUtil.split(types);
        }
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public void setUrlImpl(PortletURL urlImpl) {
        this._urlImpl = urlImpl;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._className = null;
        this._classPK = 0L;
        this._displayStyle = null;
        this._maxInlineItems = 3;
        this._target = null;
        this._title = null;
        this._types = null;
        this._url = null;
        this._urlImpl = null;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("liferay-social-bookmarks:bookmarks:className", (Object)this._className);
        httpServletRequest.setAttribute("liferay-social-bookmarks:bookmarks:classPK", (Object)this._classPK);
        httpServletRequest.setAttribute("liferay-social-bookmarks:bookmarks:displayStyle", (Object)this._displayStyle);
        httpServletRequest.setAttribute("liferay-social-bookmarks:bookmarks:maxInlineItems", (Object)this._maxInlineItems);
        httpServletRequest.setAttribute("liferay-social-bookmarks:bookmarks:target", (Object)this._target);
        httpServletRequest.setAttribute("liferay-social-bookmarks:bookmarks:title", (Object)this._title);
        String[] types = this._types;
        if (types == null) {
            List<String> allTypes = SocialBookmarksRegistryUtil.getSocialBookmarksTypes();
            types = allTypes.toArray(new String[0]);
        }
        httpServletRequest.setAttribute("liferay-social-bookmarks:bookmarks:types", (Object)types);
        if (this._url == null && this._urlImpl != null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            try {
                this._url = PortalUtil.getCanonicalURL(this._urlImpl.toString(), themeDisplay, themeDisplay.getLayout());
            }
            catch (PortalException pe) {
                _log.error("Unable to get canonical URL " + this._urlImpl, pe);
            }
        }
        if (this._url == null) {
            throw new IllegalArgumentException();
        }
        httpServletRequest.setAttribute("liferay-social-bookmarks:bookmarks:url", (Object)this._url);
    }
}

