/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.bookmarks.taglib.internal.util;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.bookmarks.SocialBookmark;
import com.liferay.social.bookmarks.SocialBookmarksRegistry;
import com.liferay.social.bookmarks.taglib.internal.util.DeprecatedSocialBookmark;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={SocialBookmarksRegistry.class})
public class SocialBookmarksRegistryImpl
implements SocialBookmarksRegistry {
    private static final String _SOCIAL_BOOKMARK_ICON = "social.bookmark.icon";
    private static final String _SOCIAL_BOOKMARK_JSP = "social.bookmark.jsp";
    private static final String _SOCIAL_BOOKMARK_POST_URL = "social.bookmark.post.url";
    private static final String _SOCIAL_BOOKMARK_TYPES = "social.bookmark.types";
    private static final Log _log = LogFactoryUtil.getLog(SocialBookmarksRegistryImpl.class);
    private ServiceTrackerList<SocialBookmark, String> _serviceTrackerList;
    private ServiceTrackerMap<String, SocialBookmark> _serviceTrackerMap;

    @Override
    public SocialBookmark getSocialBookmark(String type) {
        SocialBookmark socialBookmark = this._serviceTrackerMap.getService(type);
        if (socialBookmark == null && this._isDeprecatedSocialBookmark(type)) {
            socialBookmark = new DeprecatedSocialBookmark(type);
        }
        if (socialBookmark == null && _log.isWarnEnabled()) {
            _log.warn(String.format("Social bookmark %s is not available", type));
        }
        return socialBookmark;
    }

    @Override
    public List<SocialBookmark> getSocialBookmarks() {
        ArrayList<SocialBookmark> socialBookmarks = new ArrayList<SocialBookmark>();
        for (String type : this.getSocialBookmarksTypes()) {
            socialBookmarks.add(this.getSocialBookmark(type));
        }
        return socialBookmarks;
    }

    @Override
    public List<String> getSocialBookmarksTypes() {
        LinkedHashSet<String> socialBookmarksTypes = new LinkedHashSet<String>();
        for (String type : this._serviceTrackerList) {
            socialBookmarksTypes.add(type);
        }
        for (String type : PropsUtil.getArray(_SOCIAL_BOOKMARK_TYPES)) {
            if (!this._isValidDeprecatedSocialBookmark(type)) continue;
            socialBookmarksTypes.add(type);
        }
        return new ArrayList<String>(socialBookmarksTypes);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open(bundleContext, SocialBookmark.class, null, new SocialBookmarkTypeServiceTrackerCustomizer(), new PropertyServiceReferenceComparator("social.bookmarks.priority"));
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(bundleContext, SocialBookmark.class, "social.bookmarks.type");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
        this._serviceTrackerMap.close();
    }

    private boolean _isDeprecatedSocialBookmark(String type) {
        List<String> deprecatedSocialBookmarksTypes = Arrays.asList(PropsUtil.getArray(_SOCIAL_BOOKMARK_TYPES));
        return deprecatedSocialBookmarksTypes.contains(type) && this._isValidDeprecatedSocialBookmark(type);
    }

    private boolean _isValidDeprecatedSocialBookmark(String type) {
        String icon = PropsUtil.get(_SOCIAL_BOOKMARK_ICON, new Filter(type));
        String jspPath = PropsUtil.get(_SOCIAL_BOOKMARK_JSP, new Filter(type));
        String postUrl = PropsUtil.get(_SOCIAL_BOOKMARK_POST_URL, new Filter(type));
        return Validator.isNotNull(postUrl) && (Validator.isNotNull(icon) || Validator.isNotNull(jspPath));
    }

    private static class SocialBookmarkTypeServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SocialBookmark, String> {
        private SocialBookmarkTypeServiceTrackerCustomizer() {
        }

        public String addingService(ServiceReference<SocialBookmark> serviceReference) {
            return (String)serviceReference.getProperty("social.bookmarks.type");
        }

        public void modifiedService(ServiceReference<SocialBookmark> serviceReference, String service) {
        }

        public void removedService(ServiceReference<SocialBookmark> serviceReference, String service) {
        }
    }
}

