/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.taglib.internal.servlet.taglib.clay;

import com.liferay.frontend.taglib.clay.servlet.taglib.soy.VerticalCard;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

public class SiteVerticalCard
implements VerticalCard {
    private final Group _group;
    private final HttpServletRequest _httpServletRequest;
    private final long[] _selectedGroupIds;
    private final ThemeDisplay _themeDisplay;

    public SiteVerticalCard(Group group, RenderRequest renderRequest, long[] selectedGroupIds) {
        this._group = group;
        this._selectedGroupIds = selectedGroupIds;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    @Override
    public Map<String, String> getData() {
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            data.put("groupdescriptivename", this._group.getDescriptiveName(this._themeDisplay.getLocale()));
            data.put("groupid", String.valueOf(this._group.getGroupId()));
            data.put("groupscopelabel", this._group.getScopeLabel(this._themeDisplay));
            data.put("grouptype", LanguageUtil.get(this._httpServletRequest, this._group.getTypeLabel()));
            data.put("url", this._group.getDisplayURL(this._themeDisplay));
            data.put("uuid", this._group.getUuid());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    @Override
    public String getElementClasses() {
        if (ArrayUtil.contains(this._selectedGroupIds, this._group.getGroupId())) {
            return "text-muted";
        }
        return "card-interactive card-interactive-secondary selector-button";
    }

    @Override
    public String getIcon() {
        return "sites";
    }

    @Override
    public String getImageSrc() {
        return this._group.getLogoURL(this._themeDisplay, false);
    }

    @Override
    public String getSubtitle() {
        return null;
    }

    @Override
    public String getTitle() {
        try {
            return HtmlUtil.escape(this._group.getDescriptiveName(this._themeDisplay.getLocale()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isSelectable() {
        return false;
    }
}

