/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.taglib.internal.display.context;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

public class SiteBrowserDisplayContext {
    private String _displayStyle;
    private final String _emptyResultsMessage;
    private final List<Group> _groups;
    private final int _groupsCount;
    private final HttpServletRequest _httpServletRequest;
    private String _orderByCol;
    private String _orderByType;
    private PortletURL _portletURL;
    private final RenderRequest _renderRequest;
    private SearchContainer _searchContainer;

    public SiteBrowserDisplayContext(HttpServletRequest httpServletRequest, RenderRequest renderRequest) {
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        this._emptyResultsMessage = GetterUtil.getString(httpServletRequest.getAttribute("liferay-site:site-browser:emptyResultsMessage"));
        this._groups = (List)httpServletRequest.getAttribute("liferay-site:site-browser:groups");
        this._groupsCount = GetterUtil.getInteger(httpServletRequest.getAttribute("liferay-site:site-browser:groupsCount"));
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull(this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = GetterUtil.getString(this._httpServletRequest.getAttribute("liferay-site:site-browser:displayStyle"));
        return this._displayStyle;
    }

    public String getOrderByCol() {
        if (Validator.isNotNull(this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString(this._httpServletRequest, "orderByCol", "name");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull(this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString(this._httpServletRequest, "orderByType", "asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        if (this._portletURL != null) {
            return this._portletURL;
        }
        this._portletURL = (PortletURL)this._httpServletRequest.getAttribute("liferay-site:site-browser:portletURL");
        return this._portletURL;
    }

    public SearchContainer getSearchContainer() {
        if (this._searchContainer != null) {
            return this._searchContainer;
        }
        SearchContainer<Group> searchContainer = new SearchContainer<Group>((PortletRequest)this._renderRequest, this.getPortletURL(), null, this._emptyResultsMessage);
        searchContainer.setOrderByCol(this.getOrderByCol());
        searchContainer.setOrderByType(this.getOrderByType());
        searchContainer.setResults(this._groups);
        searchContainer.setTotal(this._groupsCount);
        this._searchContainer = searchContainer;
        return this._searchContainer;
    }
}

