/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.taglib.servlet.taglib;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portletdisplaytemplate.PortletDisplayTemplateManagerUtil;
import com.liferay.portal.kernel.theme.NavItem;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.display.template.PortletDisplayTemplate;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemLocalServiceUtil;
import com.liferay.site.navigation.taglib.internal.portlet.display.template.PortletDisplayTemplateUtil;
import com.liferay.site.navigation.taglib.internal.servlet.NavItemClassNameIdUtil;
import com.liferay.site.navigation.taglib.internal.servlet.ServletContextUtil;
import com.liferay.site.navigation.taglib.internal.util.NavItemUtil;
import com.liferay.site.navigation.taglib.internal.util.SiteNavigationMenuNavItem;
import com.liferay.taglib.util.IncludeTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class NavigationMenuTag
extends IncludeTag {
    private static final String _PAGE = "/navigation/page.jsp";
    private static final Log _log = LogFactoryUtil.getLog(NavigationMenuTag.class);
    private long _ddmTemplateGroupId;
    private String _ddmTemplateKey;
    private int _displayDepth;
    private String _expandedLevels = "auto";
    private boolean _preview;
    private String _rootItemId;
    private int _rootItemLevel = 1;
    private String _rootItemType = "absolute";
    private long _siteNavigationMenuId;

    public long getDdmTemplateGroupId() {
        return this._ddmTemplateGroupId;
    }

    public String getDdmTemplateKey() {
        return this._ddmTemplateKey;
    }

    public int getDisplayDepth() {
        return this._displayDepth;
    }

    public String getExpandedLevels() {
        return this._expandedLevels;
    }

    public String getRootItemId() {
        return this._rootItemId;
    }

    public int getRootItemLevel() {
        return this._rootItemLevel;
    }

    public String getRootItemType() {
        return this._rootItemType;
    }

    public long getSiteNavigationMenuId() {
        return this._siteNavigationMenuId;
    }

    public boolean isPreview() {
        return this._preview;
    }

    @Override
    public int processEndTag() throws Exception {
        PortletDisplayTemplate portletDisplayTemplate = PortletDisplayTemplateUtil.getPortletDisplayTemplate();
        if (portletDisplayTemplate == null) {
            return 6;
        }
        DDMTemplate portletDisplayDDMTemplate = portletDisplayTemplate.getPortletDisplayTemplateDDMTemplate(this.getDisplayStyleGroupId(), NavItemClassNameIdUtil.getNavItemClassNameId(), this.getDisplayStyle(), true);
        if (portletDisplayDDMTemplate == null) {
            return 6;
        }
        List<NavItem> branchNavItems = null;
        List<NavItem> navItems = null;
        try {
            if (this._siteNavigationMenuId > 0L) {
                branchNavItems = this._getBranchNavItems();
                navItems = this._getMenuNavItems(this.request, branchNavItems);
            } else {
                branchNavItems = this.getBranchNavItems(this.request);
                navItems = NavItemUtil.getNavItems(this.request, this._rootItemType, this._rootItemLevel, this._rootItemId, branchNavItems);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        contextObjects.put("branchNavItems", branchNavItems);
        contextObjects.put("displayDepth", this._displayDepth);
        contextObjects.put("includedLayouts", this._expandedLevels);
        contextObjects.put("preview", this._preview);
        contextObjects.put("rootLayoutLevel", this._rootItemLevel);
        contextObjects.put("rootLayoutType", this._rootItemType);
        String result = portletDisplayTemplate.renderDDMTemplate(this.request, httpServletResponse, portletDisplayDDMTemplate, navItems, contextObjects);
        JspWriter jspWriter = this.pageContext.getOut();
        jspWriter.write(result);
        return 6;
    }

    public void setDdmTemplateGroupId(long ddmTemplateGroupId) {
        this._ddmTemplateGroupId = ddmTemplateGroupId;
    }

    public void setDdmTemplateKey(String ddmTemplateKey) {
        this._ddmTemplateKey = ddmTemplateKey;
    }

    public void setDisplayDepth(int displayDepth) {
        this._displayDepth = displayDepth;
    }

    public void setExpandedLevels(String expandedLevels) {
        this._expandedLevels = expandedLevels;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    public void setPreview(boolean preview) {
        this._preview = preview;
    }

    public void setRootItemId(String rootItemId) {
        this._rootItemId = rootItemId;
    }

    public void setRootItemLevel(int rootItemLevel) {
        this._rootItemLevel = rootItemLevel;
    }

    public void setRootItemType(String rootItemType) {
        this._rootItemType = rootItemType;
    }

    public void setSiteNavigationMenuId(long siteNavigationMenuId) {
        this._siteNavigationMenuId = siteNavigationMenuId;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._ddmTemplateGroupId = 0L;
        this._ddmTemplateKey = null;
        this._displayDepth = 0;
        this._expandedLevels = "auto";
        this._preview = false;
        this._rootItemId = null;
        this._rootItemLevel = 1;
        this._rootItemType = "absolute";
        this._siteNavigationMenuId = 0L;
    }

    protected List<NavItem> getBranchNavItems(HttpServletRequest httpServletRequest) throws PortalException {
        return NavItemUtil.getBranchNavItems(httpServletRequest);
    }

    protected String getDisplayStyle() {
        if (Validator.isNotNull(this._ddmTemplateKey)) {
            return PortletDisplayTemplateManagerUtil.getDisplayStyle(this._ddmTemplateKey);
        }
        return "";
    }

    protected long getDisplayStyleGroupId() {
        if (this._ddmTemplateGroupId > 0L) {
            return this._ddmTemplateGroupId;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay.getScopeGroupId();
    }

    @Deprecated
    protected List<NavItem> getMenuItems() {
        try {
            return this._getMenuNavItems(this.request, new ArrayList<NavItem>());
        }
        catch (Exception e) {
            _log.error(e, e);
            return new ArrayList<NavItem>();
        }
    }

    @Deprecated
    protected List<NavItem> getNavItems(List<NavItem> branchNavItems) throws Exception {
        return NavItemUtil.getNavItems(this.request, this._rootItemType, this._rootItemLevel, this._rootItemId, branchNavItems);
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
    }

    private List<NavItem> _getBranchNavItems() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        long siteNavigationMenuItemId = this._getRelativeSiteNavigationMenuItemId(layout);
        SiteNavigationMenuItem siteNavigationMenuItem = SiteNavigationMenuItemLocalServiceUtil.fetchSiteNavigationMenuItem(siteNavigationMenuItemId);
        if (siteNavigationMenuItem == null) {
            return new ArrayList<NavItem>();
        }
        SiteNavigationMenuItem originalSiteNavigationMenuItem = siteNavigationMenuItem;
        ArrayList<SiteNavigationMenuItem> ancestorSiteNavigationMenuItems = new ArrayList<SiteNavigationMenuItem>();
        while (siteNavigationMenuItem.getParentSiteNavigationMenuItemId() != 0L) {
            siteNavigationMenuItem = SiteNavigationMenuItemLocalServiceUtil.getSiteNavigationMenuItem(siteNavigationMenuItem.getParentSiteNavigationMenuItemId());
            ancestorSiteNavigationMenuItems.add(siteNavigationMenuItem);
        }
        ArrayList<NavItem> navItems = new ArrayList<NavItem>(ancestorSiteNavigationMenuItems.size() + 1);
        for (int i = ancestorSiteNavigationMenuItems.size() - 1; i >= 0; --i) {
            SiteNavigationMenuItem ancestorSiteNavigationMenuItem = (SiteNavigationMenuItem)ancestorSiteNavigationMenuItems.get(i);
            navItems.add(new SiteNavigationMenuNavItem(this.request, themeDisplay, ancestorSiteNavigationMenuItem));
        }
        navItems.add(new SiteNavigationMenuNavItem(this.request, themeDisplay, originalSiteNavigationMenuItem));
        return navItems;
    }

    private List<NavItem> _getMenuNavItems(HttpServletRequest httpServletRequest, List<NavItem> branchNavItems) throws Exception {
        if (this._rootItemType.equals("absolute")) {
            if (this._rootItemLevel == 0) {
                return NavItemUtil.getChildNavItems(httpServletRequest, this._siteNavigationMenuId, 0L);
            }
            if (branchNavItems.size() >= this._rootItemLevel) {
                NavItem rootNavItem = branchNavItems.get(this._rootItemLevel - 1);
                return rootNavItem.getChildren();
            }
        } else if (this._rootItemType.equals("relative") && this._rootItemLevel >= 0 && this._rootItemLevel < branchNavItems.size() + 1) {
            int absoluteLevel = branchNavItems.size() - 1 - this._rootItemLevel;
            if (absoluteLevel == -1) {
                return NavItemUtil.getChildNavItems(httpServletRequest, this._siteNavigationMenuId, 0L);
            }
            if (absoluteLevel >= 0 && absoluteLevel < branchNavItems.size()) {
                NavItem rootNavItem = branchNavItems.get(absoluteLevel);
                return rootNavItem.getChildren();
            }
        } else if (this._rootItemType.equals("select")) {
            return NavItemUtil.getChildNavItems(httpServletRequest, this._siteNavigationMenuId, GetterUtil.getLong(this._rootItemId));
        }
        return new ArrayList<NavItem>();
    }

    private long _getRelativeSiteNavigationMenuItemId(Layout layout) {
        List<SiteNavigationMenuItem> siteNavigationMenuItems = SiteNavigationMenuItemLocalServiceUtil.getSiteNavigationMenuItems(this._siteNavigationMenuId);
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            UnicodeProperties unicodeProperties = new UnicodeProperties();
            unicodeProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
            String itemLayoutUuid = unicodeProperties.getProperty("layoutUuid");
            if (!Objects.equals(layout.getUuid(), itemLayoutUuid)) continue;
            return siteNavigationMenuItem.getSiteNavigationMenuItemId();
        }
        return 0L;
    }
}

