/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.menu.item.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;

public class SiteNavigationMenuItemUtil {
    public static UnicodeProperties getSiteNavigationMenuItemProperties(PortletRequest portletRequest, String prefix) {
        Map parameterMap = portletRequest.getParameterMap();
        String[] localizableParameters = new String[]{};
        for (String key : parameterMap.keySet()) {
            if (key.startsWith(prefix)) continue;
            localizableParameters = ArrayUtil.append(localizableParameters, key);
        }
        UnicodeProperties unicodeProperties = PropertiesParamUtil.getProperties(portletRequest, prefix);
        for (String localizableParameter : localizableParameters) {
            Map<Locale, String> map = LocalizationUtil.getLocalizationMap(portletRequest, localizableParameter);
            if (MapUtil.isEmpty(map)) continue;
            for (Map.Entry<Locale, String> entry : map.entrySet()) {
                String value = entry.getValue();
                if (Validator.isNull(value)) continue;
                String key = localizableParameter + "_" + LocaleUtil.toLanguageId(entry.getKey());
                unicodeProperties.setProperty(key, value);
            }
        }
        if (!unicodeProperties.containsKey("defaultLanguageId")) {
            unicodeProperties.setProperty("defaultLanguageId", LocaleUtil.toLanguageId(LocaleUtil.getMostRelevantLocale()));
        }
        return unicodeProperties;
    }

    public static String getSiteNavigationMenuItemXML(SiteNavigationMenuItem siteNavigationMenuItem, String name) throws PortalException {
        Stream stream;
        Map<String, String> map;
        if (siteNavigationMenuItem == null) {
            return "";
        }
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
        Set<Locale> availableLocales = LanguageUtil.getAvailableLocales(siteNavigationMenuItem.getGroupId());
        if (Objects.equals(siteNavigationMenuItem.getType(), "layout")) {
            String layoutUuid = (String)typeSettingsProperties.get("layoutUuid");
            boolean privateLayout = GetterUtil.getBoolean((String)typeSettingsProperties.get("privateLayout"));
            Layout layout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId(layoutUuid, siteNavigationMenuItem.getGroupId(), privateLayout);
            Map<Locale, String> nameMap = layout.getNameMap();
            for (Map.Entry<Locale, String> nameEntry : nameMap.entrySet()) {
                String languageId2 = LocaleUtil.toLanguageId(nameEntry.getKey());
                String value = nameEntry.getValue();
                if (!Validator.isNull(typeSettingsProperties.getProperty("name_" + languageId2))) continue;
                typeSettingsProperties.setProperty("name_" + languageId2, value);
            }
        }
        if (MapUtil.isEmpty(map = (stream = availableLocales.stream()).map(locale -> LocaleUtil.toLanguageId(locale)).filter(languageId -> Validator.isNotNull(typeSettingsProperties.getProperty(name + "_" + languageId))).collect(Collectors.toMap(languageId -> languageId, languageId -> typeSettingsProperties.getProperty(name + "_" + languageId))))) {
            String defaultLanguageId = typeSettingsProperties.getProperty("defaultLanguageId", LocaleUtil.toLanguageId(PortalUtil.getSiteDefaultLocale(siteNavigationMenuItem.getGroupId())));
            map.put(defaultLanguageId, typeSettingsProperties.getProperty(name));
        }
        return LocalizationUtil.getXml(map, LocaleUtil.toLanguageId(LocaleUtil.getMostRelevantLocale()), name);
    }
}

