/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.test.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.CriteriaSerializer;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsEntryLocalServiceUtil;
import com.liferay.segments.service.SegmentsEntryRelLocalServiceUtil;
import com.liferay.segments.service.SegmentsExperienceLocalServiceUtil;
import java.util.HashMap;
import java.util.Locale;

public class SegmentsTestUtil {
    private static final String _EMPTY_CRITERIA_STRING = CriteriaSerializer.serialize(new Criteria());

    public static SegmentsEntry addSegmentsEntry(long groupId) throws PortalException {
        return SegmentsTestUtil.addSegmentsEntry(groupId, RandomTestUtil.randomString(new RandomizerBumper[0]));
    }

    public static SegmentsEntry addSegmentsEntry(long groupId, String segmentsEntryKey) throws PortalException {
        return SegmentsTestUtil.addSegmentsEntry(groupId, segmentsEntryKey, RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), _EMPTY_CRITERIA_STRING, RandomTestUtil.randomString(new RandomizerBumper[0]));
    }

    public static SegmentsEntry addSegmentsEntry(long groupId, String className, long classPK) throws PortalException {
        SegmentsEntry segmentsEntry = SegmentsTestUtil.addSegmentsEntry(groupId, _EMPTY_CRITERIA_STRING, className);
        SegmentsEntryRelLocalServiceUtil.addSegmentsEntryRel(segmentsEntry.getSegmentsEntryId(), PortalUtil.getClassNameId(className), classPK, ServiceContextTestUtil.getServiceContext(groupId));
        return segmentsEntry;
    }

    public static SegmentsEntry addSegmentsEntry(long groupId, String criteria, String type) throws PortalException {
        return SegmentsTestUtil.addSegmentsEntry(groupId, RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), criteria, type);
    }

    public static SegmentsEntry addSegmentsEntry(long groupId, String segmentsEntryKey, String name, String description, String criteria, String type) throws PortalException {
        return SegmentsTestUtil.addSegmentsEntry(segmentsEntryKey, name, description, criteria, "DEFAULT", type, ServiceContextTestUtil.getServiceContext(groupId));
    }

    public static SegmentsEntry addSegmentsEntry(ServiceContext serviceContext) throws PortalException {
        return SegmentsTestUtil.addSegmentsEntry(RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), _EMPTY_CRITERIA_STRING, "DEFAULT", RandomTestUtil.randomString(new RandomizerBumper[0]), serviceContext);
    }

    public static SegmentsEntry addSegmentsEntry(String segmentsEntryKey, String name, String description, String criteria, String source, String type, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getDefault(), description);
        return SegmentsEntryLocalServiceUtil.addSegmentsEntry(segmentsEntryKey, nameMap, descriptionMap, true, criteria, source, type, serviceContext);
    }

    public static SegmentsExperience addSegmentsExperience(long groupId, long classNameId, long classPK) throws PortalException {
        SegmentsEntry segmentsEntry = SegmentsTestUtil.addSegmentsEntry(groupId);
        return SegmentsTestUtil.addSegmentsExperience(groupId, segmentsEntry.getSegmentsEntryId(), classNameId, classPK);
    }

    public static SegmentsExperience addSegmentsExperience(long groupId, long segmentsEntryId, long classNameId, long classPK) throws PortalException {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext(groupId);
        return SegmentsTestUtil.addSegmentsExperience(segmentsEntryId, classNameId, classPK, serviceContext);
    }

    public static SegmentsExperience addSegmentsExperience(long segmentsEntryId, long classNameId, long classPK, ServiceContext serviceContext) throws PortalException {
        return SegmentsExperienceLocalServiceUtil.addSegmentsExperience(segmentsEntryId, classNameId, classPK, RandomTestUtil.randomLocaleStringMap(), true, serviceContext);
    }

    public static SegmentsExperience addSegmentsExperience(long classNameId, long classPK, ServiceContext serviceContext) throws PortalException {
        SegmentsEntry segmentsEntry = SegmentsTestUtil.addSegmentsEntry(serviceContext.getScopeGroupId());
        return SegmentsTestUtil.addSegmentsExperience(segmentsEntry.getSegmentsEntryId(), classNameId, classPK, serviceContext);
    }
}

