/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.reading.time.taglib.servlet.taglib;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.reading.time.message.ReadingTimeMessageProvider;
import com.liferay.reading.time.model.ReadingTimeEntry;
import com.liferay.reading.time.service.ReadingTimeEntryLocalServiceUtil;
import com.liferay.reading.time.taglib.servlet.internal.servlet.reading.time.ReadingTimeUtil;
import com.liferay.taglib.util.AttributesTagSupport;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import javax.portlet.RenderResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTag;

public class ReadingTimeTag
extends AttributesTagSupport
implements BodyTag {
    private String _displayStyle = "simple";
    private GroupedModel _groupedModel;
    private String _id;

    @Override
    public int doEndTag() throws JspException {
        try {
            Optional<Duration> readingTimeDurationOptional = this._getReadingTimeDurationOptional();
            Optional tagOptional = readingTimeDurationOptional.flatMap(this::_buildTag);
            if (tagOptional.isPresent()) {
                JspWriter jspWriter = this.pageContext.getOut();
                jspWriter.write((String)tagOptional.get());
            }
            return 6;
        }
        catch (IOException ioe) {
            throw new JspException((Throwable)ioe);
        }
    }

    public void setDisplayStyle(String displayStyle) {
        this._displayStyle = displayStyle;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setModel(GroupedModel groupedModel) {
        this._groupedModel = groupedModel;
    }

    private Optional<String> _buildTag(Duration readingTimeDuration) {
        String readingTimeMessage = this._getReadingTimeMessage(readingTimeDuration);
        if (Validator.isNotNull(readingTimeMessage)) {
            StringBundler sb = new StringBundler(10);
            sb.append("<time class=\"reading-time\" datetime=\"");
            sb.append(String.valueOf(readingTimeDuration.getSeconds()));
            sb.append("s\"");
            if (Validator.isNotNull(this._id)) {
                sb.append(" id=\"");
                sb.append(this._getNamespace());
                sb.append(this._id);
                sb.append("\"");
            }
            sb.append(">");
            sb.append(readingTimeMessage);
            sb.append("</time>");
            return Optional.of(sb.toString());
        }
        return Optional.empty();
    }

    private String _getNamespace() {
        RenderResponse renderResponse = (RenderResponse)this.request.getAttribute("javax.portlet.response");
        return renderResponse.getNamespace();
    }

    private Optional<Duration> _getReadingTimeDurationOptional() {
        if (this._groupedModel == null) {
            return Optional.of(Duration.ZERO);
        }
        ReadingTimeEntry readingTimeEntry = ReadingTimeEntryLocalServiceUtil.fetchOrAddReadingTimeEntry(this._groupedModel);
        if (readingTimeEntry != null) {
            return Optional.of(Duration.ofMillis(readingTimeEntry.getReadingTime()));
        }
        return Optional.empty();
    }

    private String _getReadingTimeMessage(Duration readingTimeDuration) {
        ReadingTimeMessageProvider readingTimeMessageProvider = ReadingTimeUtil.getReadingTimeMessageProvider(this._displayStyle);
        if (readingTimeMessageProvider == null) {
            return null;
        }
        return readingTimeMessageProvider.provide(readingTimeDuration, PortalUtil.getLocale(this.request));
    }
}

