/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.reading.time.taglib.servlet.internal.servlet.reading.time;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.reading.time.message.ReadingTimeMessageProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={})
public class ReadingTimeUtil {
    private static final Log _log = LogFactoryUtil.getLog(ReadingTimeUtil.class);
    private static ReadingTimeUtil _instance;
    private ServiceTrackerMap<String, ReadingTimeMessageProvider> _serviceTrackerMap;

    public static ReadingTimeMessageProvider getReadingTimeMessageProvider(String displayStyle) {
        ReadingTimeMessageProvider readingTimeMessageProvider = ReadingTimeUtil._instance._serviceTrackerMap.getService(displayStyle);
        if (readingTimeMessageProvider == null && _log.isWarnEnabled()) {
            _log.warn(String.format("Reading time provider \"%s\" is not available", displayStyle));
        }
        return readingTimeMessageProvider;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        _instance = this;
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(bundleContext, ReadingTimeMessageProvider.class, "display.style");
    }

    @Deactivate
    protected void deactivate() {
        _instance = null;
        this._serviceTrackerMap.close();
    }
}

