/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.product.navigation.product.menu.display.context;

import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.PanelCategory;
import com.liferay.application.list.PanelCategoryRegistry;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public class ProductMenuDisplayContext {
    private List<PanelCategory> _childPanelCategories;
    private final PanelAppRegistry _panelAppRegistry;
    private final PanelCategoryHelper _panelCategoryHelper;
    private final PanelCategoryRegistry _panelCategoryRegistry;
    private final PortletRequest _portletRequest;
    private final PortletResponse _portletResponse;
    private String _rootPanelCategoryKey;
    private final ThemeDisplay _themeDisplay;

    public ProductMenuDisplayContext(PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        this._portletRequest = portletRequest;
        this._portletResponse = portletResponse;
        this._panelAppRegistry = (PanelAppRegistry)this._portletRequest.getAttribute("PANEL_APP_REGISTRY");
        this._panelCategoryHelper = (PanelCategoryHelper)this._portletRequest.getAttribute("PANEL_CATEGORY_HELPER");
        this._panelCategoryRegistry = (PanelCategoryRegistry)this._portletRequest.getAttribute("PANEL_CATEGORY_REGISTRY");
        this._themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<PanelCategory> getChildPanelCategories() {
        if (this._childPanelCategories != null) {
            return this._childPanelCategories;
        }
        this._childPanelCategories = this._panelCategoryRegistry.getChildPanelCategories("root", this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroup());
        return this._childPanelCategories;
    }

    public int getNotificationsCount(PanelCategory panelCategory) {
        return this._panelCategoryHelper.getNotificationsCount(panelCategory.getKey(), this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroup(), this._themeDisplay.getUser());
    }

    public String getRootPanelCategoryKey() {
        if (this._rootPanelCategoryKey != null) {
            return this._rootPanelCategoryKey;
        }
        this._rootPanelCategoryKey = "";
        List<PanelCategory> childPanelCategories = this.getChildPanelCategories();
        if (!childPanelCategories.isEmpty()) {
            PanelCategory lastChildPanelCategory = childPanelCategories.get(childPanelCategories.size() - 1);
            this._rootPanelCategoryKey = lastChildPanelCategory.getKey();
            if (Validator.isNotNull(this._themeDisplay.getPpid())) {
                PanelCategoryHelper panelCategoryHelper = new PanelCategoryHelper(this._panelAppRegistry, this._panelCategoryRegistry);
                for (PanelCategory panelCategory : this._panelCategoryRegistry.getChildPanelCategories("root")) {
                    if (!panelCategoryHelper.containsPortlet(this._themeDisplay.getPpid(), panelCategory.getKey(), this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroup())) continue;
                    this._rootPanelCategoryKey = panelCategory.getKey();
                    return this._rootPanelCategoryKey;
                }
            }
        }
        return this._rootPanelCategoryKey;
    }

    public boolean hasUserPanelCategory() {
        List<PanelCategory> panelCategories = this.getChildPanelCategories();
        for (PanelCategory panelCategory : panelCategories) {
            String panelCategoryKey = panelCategory.getKey();
            if (!panelCategoryKey.equals("user")) continue;
            return true;
        }
        return false;
    }

    public boolean isShowProductMenu() {
        Layout layout = this._themeDisplay.getLayout();
        if (layout.isTypeControlPanel()) {
            return true;
        }
        List<PanelCategory> childPanelCategories = this.getChildPanelCategories();
        return !childPanelCategories.isEmpty();
    }
}

