/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.util;

import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.NoSuchContactException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ContactImpl;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@Deprecated
@OSGiBeanProperties
public class UserIndexer
extends BaseIndexer<User> {
    public static final String CLASS_NAME = User.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(UserIndexer.class);

    public static long getUserId(Document document) {
        return GetterUtil.getLong(document.get("userId"));
    }

    public UserIndexer() {
        this.setDefaultSelectedFieldNames("assetTagNames", "companyId", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "uid", "userId");
        this.setPermissionAware(true);
        this.setStagingAware(false);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        LinkedHashMap params;
        int status = GetterUtil.getInteger(searchContext.getAttribute("status"), 0);
        if (status != -1) {
            contextBooleanFilter.addRequiredTerm("status", status);
        }
        if ((params = (LinkedHashMap)searchContext.getAttribute("params")) == null) {
            return;
        }
        for (Map.Entry entry : params.entrySet()) {
            Object[] values;
            Class<?> clazz;
            Object value = entry.getValue();
            if (value == null || (clazz = value.getClass()).isArray() && (values = (Object[])value).length == 0) continue;
            this.addContextQueryParams(contextBooleanFilter, searchContext, (String)entry.getKey(), value);
        }
    }

    @Override
    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "city", false);
        this.addSearchTerm(searchQuery, searchContext, "country", false);
        this.addSearchTerm(searchQuery, searchContext, "emailAddress", false);
        this.addSearchTerm(searchQuery, searchContext, "firstName", false);
        this.addSearchTerm(searchQuery, searchContext, "fullName", false);
        this.addSearchTerm(searchQuery, searchContext, "lastName", false);
        this.addSearchTerm(searchQuery, searchContext, "middleName", false);
        this.addSearchTerm(searchQuery, searchContext, "region", false);
        this.addSearchTerm(searchQuery, searchContext, "screenName", false);
        this.addSearchTerm(searchQuery, searchContext, "street", false);
        this.addSearchTerm(searchQuery, searchContext, "zip", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull(expandoAttributes = (String)params.get("expandoAttributes"))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void addContextQueryParams(BooleanFilter contextFilter, SearchContext searchContext, String key, Object value) throws Exception {
        if (key.equals("usersGroups")) {
            if (value instanceof Long[]) {
                Object[] values = (Long[])value;
                if (ArrayUtil.isEmpty(values)) {
                    return;
                }
                TermsFilter userGroupsTermsFilter = new TermsFilter("groupIds");
                userGroupsTermsFilter.addValues(ArrayUtil.toStringArray(values));
                contextFilter.add(userGroupsTermsFilter, BooleanClauseOccur.MUST);
            } else {
                contextFilter.addRequiredTerm("groupIds", String.valueOf(value));
            }
        } else if (key.equals("usersOrgs")) {
            if (value instanceof Long[]) {
                Object[] values = (Long[])value;
                if (ArrayUtil.isEmpty(values)) {
                    return;
                }
                TermsFilter organizationsTermsFilter = new TermsFilter("organizationIds");
                TermsFilter ancestorOrgsTermsFilter = new TermsFilter("ancestorOrganizationIds");
                String[] organizationIdsStrings = ArrayUtil.toStringArray(values);
                ancestorOrgsTermsFilter.addValues(organizationIdsStrings);
                organizationsTermsFilter.addValues(organizationIdsStrings);
                BooleanFilter userOrgsBooleanFilter = new BooleanFilter();
                userOrgsBooleanFilter.add(ancestorOrgsTermsFilter);
                userOrgsBooleanFilter.add(organizationsTermsFilter);
                contextFilter.add(userOrgsBooleanFilter, BooleanClauseOccur.MUST);
            } else {
                contextFilter.addRequiredTerm("organizationIds", String.valueOf(value));
            }
        } else if (key.equals("usersOrgsCount")) {
            contextFilter.addRequiredTerm("organizationCount", String.valueOf(value));
        } else if (key.equals("usersRoles")) {
            contextFilter.addRequiredTerm("roleIds", String.valueOf(value));
        } else if (key.equals("usersTeams")) {
            contextFilter.addRequiredTerm("teamIds", String.valueOf(value));
        } else if (key.equals("usersUserGroups")) {
            contextFilter.addRequiredTerm("userGroupIds", String.valueOf(value));
        }
    }

    @Override
    protected void doDelete(User user) throws Exception {
        this.deleteDocument(user.getCompanyId(), user.getUserId());
        Indexer<Contact> indexer = IndexerRegistryUtil.nullSafeGetIndexer(Contact.class);
        ContactImpl contact = new ContactImpl();
        contact.setContactId(user.getContactId());
        contact.setCompanyId(user.getCompanyId());
        indexer.delete(contact);
    }

    @Override
    protected Document doGetDocument(User user) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, user);
        long[] organizationIds = user.getOrganizationIds();
        document.addKeyword("companyId", user.getCompanyId());
        document.addKeyword("groupId", user.getGroupIds());
        document.addDate("modified", user.getModifiedDate());
        document.addKeyword("scopeGroupId", user.getGroupIds());
        document.addKeyword("status", user.getStatus());
        document.addKeyword("userId", user.getUserId());
        document.addKeyword("userName", user.getFullName());
        document.addKeyword("ancestorOrganizationIds", this.getAncestorOrganizationIds(user.getOrganizationIds()));
        document.addText("emailAddress", user.getEmailAddress());
        document.addText("firstName", user.getFirstName());
        document.addText("fullName", user.getFullName());
        document.addKeyword("groupIds", user.getGroupIds());
        document.addText("jobTitle", user.getJobTitle());
        document.addText("lastName", user.getLastName());
        document.addText("middleName", user.getMiddleName());
        document.addKeyword("organizationIds", organizationIds);
        document.addKeyword("organizationCount", String.valueOf(organizationIds.length));
        document.addKeyword("roleIds", user.getRoleIds());
        document.addText("screenName", user.getScreenName());
        document.addKeyword("teamIds", user.getTeamIds());
        document.addKeyword("userGroupIds", user.getUserGroupIds());
        this.populateAddresses(document, user.getAddresses(), 0L, 0L);
        return document;
    }

    @Override
    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("email-address")) {
            return "emailAddress";
        }
        if (orderByCol.equals("first-name")) {
            return "firstName";
        }
        if (orderByCol.equals("job-title")) {
            return "jobTitle";
        }
        if (orderByCol.equals("last-name")) {
            return "lastName";
        }
        if (orderByCol.equals("screen-name")) {
            return "screenName";
        }
        return orderByCol;
    }

    @Override
    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String firstName = document.get("firstName");
        String middleName = document.get("middleName");
        String lastName = document.get("lastName");
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        String title = fullNameGenerator.getFullName(firstName, middleName, lastName);
        String content = null;
        return new Summary(title, content);
    }

    @Override
    protected void doReindex(String className, long classPK) throws Exception {
        User user = UserLocalServiceUtil.getUserById(classPK);
        this.doReindex(user);
    }

    @Override
    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong(ids[0]);
        this.reindexUsers(companyId);
    }

    @Override
    protected void doReindex(User user) throws Exception {
        block3: {
            if (user.isDefaultUser()) {
                return;
            }
            Document document = this.getDocument(user);
            IndexWriterHelperUtil.updateDocument(this.getSearchEngineId(), user.getCompanyId(), document, this.isCommitImmediately());
            Indexer<Contact> indexer = IndexerRegistryUtil.nullSafeGetIndexer(Contact.class);
            try {
                indexer.reindex(user.getContact());
            }
            catch (NoSuchContactException nsce) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug(nsce, nsce);
            }
        }
    }

    protected long[] getAncestorOrganizationIds(long[] organizationIds) throws Exception {
        HashSet<Long> ancestorOrganizationIds = new HashSet<Long>();
        for (long organizationId : organizationIds) {
            Organization organization = OrganizationLocalServiceUtil.getOrganization(organizationId);
            for (long ancestorOrganizationId : organization.getAncestorOrganizationIds()) {
                ancestorOrganizationIds.add(ancestorOrganizationId);
            }
        }
        return ArrayUtil.toLongArray(ancestorOrganizationIds);
    }

    protected void reindexUsers(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = UserLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(user -> {
            block3: {
                if (!user.isDefaultUser()) {
                    try {
                        Document document = this.getDocument(user);
                        indexableActionableDynamicQuery.addDocuments(document);
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn("Unable to index user " + user.getUserId(), pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

