/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.util;

import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.service.ContactLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@Deprecated
public class ContactIndexer
extends BaseIndexer<Contact> {
    public static final String CLASS_NAME = Contact.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(ContactIndexer.class);

    public ContactIndexer() {
        this.setStagingAware(false);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "city", false);
        this.addSearchTerm(searchQuery, searchContext, "country", false);
        this.addSearchTerm(searchQuery, searchContext, "emailAddress", false);
        this.addSearchTerm(searchQuery, searchContext, "firstName", false);
        this.addSearchTerm(searchQuery, searchContext, "fullName", false);
        this.addSearchTerm(searchQuery, searchContext, "lastName", false);
        this.addSearchTerm(searchQuery, searchContext, "middleName", false);
        this.addSearchTerm(searchQuery, searchContext, "region", false);
        this.addSearchTerm(searchQuery, searchContext, "screenName", false);
        this.addSearchTerm(searchQuery, searchContext, "street", false);
        this.addSearchTerm(searchQuery, searchContext, "zip", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull(expandoAttributes = (String)params.get("expandoAttributes"))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    @Override
    protected void doDelete(Contact contact) throws Exception {
        this.deleteDocument(contact.getCompanyId(), contact.getContactId());
    }

    @Override
    protected Document doGetDocument(Contact contact) throws Exception {
        User user;
        if (contact.isUser() && ((user = UserLocalServiceUtil.fetchUserByContactId(contact.getContactId())) == null || user.isDefaultUser() || user.getStatus() != 0)) {
            return null;
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, contact);
        document.addKeyword("companyId", contact.getCompanyId());
        document.addDate("modified", contact.getModifiedDate());
        document.addKeyword("userId", contact.getUserId());
        document.addKeyword("userName", contact.getFullName());
        document.addText("emailAddress", contact.getEmailAddress());
        document.addText("firstName", contact.getFirstName());
        document.addText("fullName", contact.getFullName());
        document.addText("jobTitle", contact.getJobTitle());
        document.addText("lastName", contact.getLastName());
        document.addText("middleName", contact.getMiddleName());
        return document;
    }

    @Override
    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("email-address")) {
            return "emailAddress";
        }
        if (orderByCol.equals("first-name")) {
            return "firstName";
        }
        if (orderByCol.equals("job-title")) {
            return "jobTitle";
        }
        if (orderByCol.equals("last-name")) {
            return "lastName";
        }
        return orderByCol;
    }

    @Override
    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    @Override
    protected void doReindex(Contact contact) throws Exception {
        Document document = this.getDocument(contact);
        IndexWriterHelperUtil.updateDocument(this.getSearchEngineId(), contact.getCompanyId(), document, this.isCommitImmediately());
    }

    @Override
    protected void doReindex(String className, long classPK) throws Exception {
        Contact contact = ContactLocalServiceUtil.getContact(classPK);
        this.doReindex(contact);
    }

    @Override
    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong(ids[0]);
        this.reindexContacts(companyId);
    }

    protected void reindexContacts(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = ContactLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(contact -> {
            block2: {
                try {
                    Document document = this.getDocument(contact);
                    indexableActionableDynamicQuery.addDocuments(document);
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn("Unable to index contact " + contact.getContactId(), pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

