/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.search;

import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class UserOrganizationChecker
extends RowChecker {
    private static final Log _log = LogFactoryUtil.getLog(UserOrganizationChecker.class);
    private final Organization _organization;

    public UserOrganizationChecker(RenderResponse renderResponse, Organization organization) {
        super((PortletResponse)renderResponse);
        this._organization = organization;
    }

    @Override
    public boolean isChecked(Object obj) {
        User user = (User)obj;
        try {
            return UserLocalServiceUtil.hasOrganizationUser(this._organization.getOrganizationId(), user.getUserId());
        }
        catch (Exception e) {
            _log.error(e, e);
            return false;
        }
    }

    @Override
    public boolean isDisabled(Object obj) {
        if (!PropsValues.ORGANIZATIONS_ASSIGNMENT_STRICT) {
            return false;
        }
        User user = (User)obj;
        try {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (this.isChecked(user) ? OrganizationMembershipPolicyUtil.isMembershipProtected(permissionChecker, user.getUserId(), this._organization.getOrganizationId()) || OrganizationMembershipPolicyUtil.isMembershipRequired(user.getUserId(), this._organization.getOrganizationId()) : !OrganizationMembershipPolicyUtil.isMembershipAllowed(user.getUserId(), this._organization.getOrganizationId())) {
                return true;
            }
            return !UserPermissionUtil.contains(permissionChecker, user.getUserId(), "UPDATE");
        }
        catch (Exception e) {
            _log.error(e, e);
            return super.isDisabled(obj);
        }
    }
}

