/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.search;

import com.liferay.portal.kernel.dao.search.DAOParamUtil;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import com.liferay.portal.kernel.service.RegionServiceUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.OrganizationDisplayTerms;
import javax.portlet.PortletRequest;

public class OrganizationSearchTerms
extends OrganizationDisplayTerms {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationSearchTerms.class);

    public OrganizationSearchTerms(PortletRequest portletRequest) {
        super(portletRequest);
        this.city = DAOParamUtil.getString(portletRequest, "city");
        this.countryId = ParamUtil.getLong(portletRequest, "countryId");
        this.name = DAOParamUtil.getString(portletRequest, "name");
        this.parentOrganizationId = ParamUtil.getLong(portletRequest, "parentOrganizationId");
        this.regionId = ParamUtil.getLong(portletRequest, "regionId");
        this.street = DAOParamUtil.getString(portletRequest, "street");
        this.type = DAOParamUtil.getString(portletRequest, "type");
        this.zip = DAOParamUtil.getString(portletRequest, "zip");
    }

    public Long getCountryIdObj() {
        if (this.countryId == 0L) {
            return null;
        }
        return this.countryId;
    }

    public String getCountryName() throws PortalException {
        String countryName;
        block3: {
            countryName = null;
            if (this.countryId != 0L) {
                try {
                    Country country = CountryServiceUtil.getCountry(this.countryId);
                    countryName = StringUtil.toLowerCase(country.getName());
                    countryName = StringUtil.quote(countryName, "\"");
                }
                catch (NoSuchCountryException nsce) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn(nsce.getMessage());
                }
            }
        }
        return countryName;
    }

    public Long getRegionIdObj() {
        if (this.regionId == 0L) {
            return null;
        }
        return this.regionId;
    }

    public String getRegionName() throws PortalException {
        String regionName;
        block3: {
            regionName = null;
            if (this.regionId != 0L) {
                try {
                    Region region = RegionServiceUtil.getRegion(this.regionId);
                    regionName = StringUtil.toLowerCase(region.getName());
                    regionName = StringUtil.quote(regionName, "\"");
                }
                catch (NoSuchRegionException nsre) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn(nsre.getMessage());
                }
            }
        }
        return regionName;
    }

    public boolean hasSearchTerms() {
        return this.isAdvancedSearch() ? Validator.isNotNull(this.city) || this.countryId > 0L || Validator.isNotNull(this.name) || this.regionId > 0L || Validator.isNotNull(this.street) || Validator.isNotNull(this.type) || Validator.isNotNull(this.zip) : Validator.isNotNull(this.keywords);
    }
}

