/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.search;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.OrganizationDisplayTerms;
import com.liferay.portlet.usersadmin.search.OrganizationSearchTerms;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class OrganizationSearch
extends SearchContainer<Organization> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-organizations-were-found";
    public static List<String> headerNames = new ArrayList<String>(){
        {
            this.add("name");
            this.add("parent-organization");
            this.add("type");
            this.add("city");
            this.add("region");
            this.add("country");
        }
    };
    public static Map<String, String> orderableHeaders = new HashMap<String, String>(){
        {
            this.put("name", "name");
            this.put("type", "type");
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(OrganizationSearch.class);

    public OrganizationSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        this(portletRequest, "cur", iteratorURL);
    }

    public OrganizationSearch(PortletRequest portletRequest, String curParam, PortletURL iteratorURL) {
        super(portletRequest, new OrganizationDisplayTerms(portletRequest), new OrganizationSearchTerms(portletRequest), curParam, DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        OrganizationDisplayTerms displayTerms = (OrganizationDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("city", displayTerms.getCity());
        iteratorURL.setParameter("countryId", String.valueOf(displayTerms.getCountryId()));
        iteratorURL.setParameter("name", displayTerms.getName());
        iteratorURL.setParameter("parentOrganizationId", String.valueOf(displayTerms.getParentOrganizationId()));
        iteratorURL.setParameter("regionId", String.valueOf(displayTerms.getRegionId()));
        iteratorURL.setParameter("street", displayTerms.getStreet());
        iteratorURL.setParameter("type", displayTerms.getType());
        iteratorURL.setParameter("zip", displayTerms.getZip());
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences(portletRequest);
            String portletId = PortletProviderUtil.getPortletId(User.class.getName(), PortletProvider.Action.VIEW);
            String orderByCol = ParamUtil.getString(portletRequest, "orderByCol");
            String orderByType = ParamUtil.getString(portletRequest, "orderByType");
            if (Validator.isNotNull(orderByCol) && Validator.isNotNull(orderByType)) {
                preferences.setValue(portletId, "organizations-order-by-col", orderByCol);
                preferences.setValue(portletId, "organizations-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue(portletId, "organizations-order-by-col", "name");
                orderByType = preferences.getValue(portletId, "organizations-order-by-type", "asc");
            }
            OrderByComparator<Organization> orderByComparator = UsersAdminUtil.getOrganizationOrderByComparator(orderByCol, orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error("Unable to initialize organization search", e);
        }
    }
}

