/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.search;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.GroupDisplayTerms;
import com.liferay.portlet.usersadmin.search.GroupSearchTerms;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class GroupSearch
extends SearchContainer<Group> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-sites-were-found";
    public static List<String> headerNames = new ArrayList<String>(){
        {
            this.add("name");
            this.add("type");
        }
    };
    public static Map<String, String> orderableHeaders = new HashMap<String, String>(){
        {
            this.put("name", "name");
            this.put("type", "type");
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(GroupSearch.class);

    public GroupSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, new GroupDisplayTerms(portletRequest), new GroupSearchTerms(portletRequest), "cur", DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        GroupDisplayTerms displayTerms = (GroupDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("description", displayTerms.getDescription());
        iteratorURL.setParameter("name", displayTerms.getName());
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences(portletRequest);
            String portletId = PortletProviderUtil.getPortletId(User.class.getName(), PortletProvider.Action.VIEW);
            String orderByCol = ParamUtil.getString(portletRequest, "orderByCol");
            String orderByType = ParamUtil.getString(portletRequest, "orderByType");
            if (Validator.isNotNull(orderByCol) && Validator.isNotNull(orderByType)) {
                preferences.setValue(portletId, "groups-order-by-col", orderByCol);
                preferences.setValue(portletId, "groups-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue(portletId, "groups-order-by-col", "name");
                orderByType = preferences.getValue(portletId, "groups-order-by-type", "asc");
            }
            OrderByComparator<Group> orderByComparator = UsersAdminUtil.getGroupOrderByComparator(orderByCol, orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error("Unable to initialize group search", e);
        }
    }
}

