/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usergroupsadmin.search;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.membershippolicy.UserGroupMembershipPolicyUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class SetUserUserGroupChecker
extends EmptyOnClickRowChecker {
    private static final Log _log = LogFactoryUtil.getLog(SetUserUserGroupChecker.class);
    private final UserGroup _userGroup;

    public SetUserUserGroupChecker(RenderResponse renderResponse, UserGroup userGroup) {
        super((PortletResponse)renderResponse);
        this._userGroup = userGroup;
    }

    @Override
    public boolean isChecked(Object obj) {
        User user = (User)obj;
        try {
            return UserLocalServiceUtil.hasUserGroupUser(this._userGroup.getUserGroupId(), user.getUserId());
        }
        catch (Exception e) {
            _log.error(e, e);
            return false;
        }
    }

    @Override
    public boolean isDisabled(Object obj) {
        User user = (User)obj;
        try {
            if (this.isChecked(user) || !UserGroupMembershipPolicyUtil.isMembershipAllowed(user.getUserId(), this._userGroup.getUserGroupId())) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return super.isDisabled(obj);
    }
}

