/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.util;

import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.model.TrashVersion;
import com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil;
import com.liferay.trash.kernel.service.TrashVersionLocalServiceUtil;
import com.liferay.trash.kernel.util.Trash;
import com.liferay.trash.kernel.util.comparator.EntryCreateDateComparator;
import com.liferay.trash.kernel.util.comparator.EntryTypeComparator;
import com.liferay.trash.kernel.util.comparator.EntryUserNameComparator;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

@Deprecated
public class TrashImpl
implements Trash {
    protected final String TRASH_PREFIX = "/";
    private static final Log _log = LogFactoryUtil.getLog(TrashImpl.class);

    @Override
    public void addBaseModelBreadcrumbEntries(HttpServletRequest httpServletRequest, LiferayPortletResponse liferayPortletResponse, String className, long classPK, PortletURL containerModelURL) throws PortalException, PortletException {
        this.addBreadcrumbEntries(httpServletRequest, liferayPortletResponse, className, classPK, "classPK", containerModelURL, true);
    }

    @Override
    public void addContainerModelBreadcrumbEntries(HttpServletRequest httpServletRequest, LiferayPortletResponse liferayPortletResponse, String className, long classPK, PortletURL containerModelURL) throws PortalException, PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler(className);
        String rootContainerModelTitle = LanguageUtil.get(themeDisplay.getLocale(), trashHandler.getRootContainerModelName());
        if (classPK == 0L) {
            PortalUtil.addPortletBreadcrumbEntry(httpServletRequest, rootContainerModelTitle, null);
            return;
        }
        containerModelURL.setParameter("containerModelId", "0");
        PortalUtil.addPortletBreadcrumbEntry(httpServletRequest, rootContainerModelTitle, containerModelURL.toString());
        this.addBreadcrumbEntries(httpServletRequest, liferayPortletResponse, className, classPK, "containerModelId", containerModelURL, false);
    }

    @Override
    public void addTrashSessionMessages(ActionRequest actionRequest, List<TrashedModel> trashedModels) {
        this.addTrashSessionMessages(actionRequest, trashedModels, "move_to_trash");
    }

    @Override
    public void addTrashSessionMessages(ActionRequest actionRequest, List<TrashedModel> trashedModels, String cmd) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cmd", new String[]{cmd});
        data.put("trashedModels", trashedModels);
        SessionMessages.add((PortletRequest)actionRequest, PortalUtil.getPortletId((PortletRequest)actionRequest) + ".deleteSuccessData", data);
    }

    @Override
    public void addTrashSessionMessages(ActionRequest actionRequest, TrashedModel trashedModel) {
        this.addTrashSessionMessages(actionRequest, trashedModel, "move_to_trash");
    }

    @Override
    public void addTrashSessionMessages(ActionRequest actionRequest, TrashedModel trashedModel, String cmd) {
        this.addTrashSessionMessages(actionRequest, ListUtil.toList(trashedModel), cmd);
    }

    @Override
    public void deleteEntriesAttachments(long companyId, long repositoryId, Date date, String[] attachmentFileNames) {
        for (String attachmentFileName : attachmentFileNames) {
            String trashTime = this.getTrashTime(attachmentFileName, "_TRASH_TIME_");
            long timestamp = GetterUtil.getLong(trashTime);
            if (timestamp >= date.getTime()) continue;
            DLStoreUtil.deleteDirectory(companyId, repositoryId, attachmentFileName);
        }
    }

    @Override
    public Group disableTrash(Group group) {
        UnicodeProperties typeSettingsProperties = group.getParentLiveGroupTypeSettingsProperties();
        typeSettingsProperties.setProperty("trashEnabled", "false");
        group.setTypeSettingsProperties(typeSettingsProperties);
        return GroupLocalServiceUtil.updateGroup(group);
    }

    @Override
    public List<TrashEntry> getEntries(Hits hits) {
        ArrayList<TrashEntry> entries = new ArrayList<TrashEntry>();
        for (Document document : hits.getDocs()) {
            String entryClassName = GetterUtil.getString(document.get("entryClassName"));
            long classPK = GetterUtil.getLong(document.get("entryClassPK"));
            try {
                TrashEntry entry = TrashEntryLocalServiceUtil.fetchEntry(entryClassName, classPK);
                if (entry == null) {
                    String userName = GetterUtil.getString(document.get("removedByUserName"));
                    Date removedDate = document.getDate("removedDate");
                    entry = TrashEntryLocalServiceUtil.createTrashEntry(0L);
                    entry.setUserName(userName);
                    entry.setCreateDate(removedDate);
                    TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler(entryClassName);
                    TrashRenderer trashRenderer = trashHandler.getTrashRenderer(classPK);
                    entry.setClassName(trashRenderer.getClassName());
                    entry.setClassPK(trashRenderer.getClassPK());
                    String rootEntryClassName = GetterUtil.getString(document.get("rootEntryClassName"));
                    long rootEntryClassPK = GetterUtil.getLong(document.get("rootEntryClassPK"));
                    TrashEntry rootTrashEntry = TrashEntryLocalServiceUtil.fetchEntry(rootEntryClassName, rootEntryClassPK);
                    if (rootTrashEntry != null) {
                        entry.setRootEntry(rootTrashEntry);
                    }
                }
                entries.add(entry);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(StringBundler.concat("Unable to find trash entry for ", entryClassName, " with primary key ", classPK));
            }
        }
        return entries;
    }

    @Override
    public OrderByComparator<TrashEntry> getEntryOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        OrderByComparator orderByComparator = null;
        if (orderByCol.equals("removed-by")) {
            orderByComparator = new EntryUserNameComparator(orderByAsc);
        } else if (orderByCol.equals("removed-date")) {
            orderByComparator = new EntryCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("type")) {
            orderByComparator = new EntryTypeComparator(orderByAsc);
        }
        return orderByComparator;
    }

    @Override
    public int getMaxAge(Group group) {
        int trashEntriesMaxAge = PrefsPropsUtil.getInteger(group.getCompanyId(), "trash.entries.max.age", PropsValues.TRASH_ENTRIES_MAX_AGE);
        UnicodeProperties typeSettingsProperties = group.getParentLiveGroupTypeSettingsProperties();
        return GetterUtil.getInteger(typeSettingsProperties.getProperty("trashEntriesMaxAge"), trashEntriesMaxAge);
    }

    @Override
    public String getNewName(String oldName, String token) {
        StringBundler sb = new StringBundler(3);
        sb.append(oldName);
        sb.append(" ");
        sb.append(token);
        return sb.toString();
    }

    @Override
    public String getNewName(ThemeDisplay themeDisplay, String className, long classPK, String oldName) throws PortalException {
        TrashRenderer trashRenderer = null;
        if (Validator.isNotNull(className) && classPK > 0L) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler(className);
            trashRenderer = trashHandler.getTrashRenderer(classPK);
        }
        StringBundler sb = new StringBundler(3);
        sb.append("(");
        Format format = FastDateFormatFactoryUtil.getDateTime(themeDisplay.getLocale(), themeDisplay.getTimeZone());
        sb.append(StringUtil.replace(format.format(new Date()), new char[]{'/', ':'}, new char[]{'.', '.'}));
        sb.append(")");
        if (trashRenderer != null) {
            return trashRenderer.getNewName(oldName, sb.toString());
        }
        return this.getNewName(oldName, sb.toString());
    }

    @Override
    public String getOriginalTitle(String title) {
        return this.getOriginalTitle(title, "title", "/");
    }

    @Override
    public String getOriginalTitle(String title, String paramName) {
        return this.getOriginalTitle(title, paramName, "/");
    }

    @Override
    public String getTrashTime(String title, String separator) {
        int index = title.lastIndexOf(separator);
        if (index < 0) {
            return "";
        }
        return title.substring(index + 1);
    }

    @Override
    public String getTrashTitle(long trashEntryId) {
        return this.getTrashTitle(trashEntryId, "/");
    }

    @Override
    public PortletURL getViewContentURL(HttpServletRequest httpServletRequest, long trashEntryId) throws PortalException {
        TrashEntry trashEntry = TrashEntryLocalServiceUtil.fetchEntry(trashEntryId);
        return this.getViewContentURL(httpServletRequest, trashEntry.getClassName(), trashEntry.getClassPK());
    }

    @Override
    public PortletURL getViewContentURL(HttpServletRequest httpServletRequest, String className, long classPK) throws PortalException {
        TrashRenderer trashRenderer;
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler(className);
        if (trashHandler.isInTrashContainer(classPK)) {
            TrashEntry trashEntry = trashHandler.getTrashEntry(classPK);
            className = trashEntry.getClassName();
            classPK = trashEntry.getClassPK();
            trashHandler = TrashHandlerRegistryUtil.getTrashHandler(className);
        }
        if ((trashRenderer = trashHandler.getTrashRenderer(classPK)) == null) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = PortletProviderUtil.getPortletURL(httpServletRequest, TrashEntry.class.getName(), PortletProvider.Action.VIEW);
        portletURL.setParameter("mvcPath", "/view_content.jsp");
        portletURL.setParameter("redirect", themeDisplay.getURLCurrent());
        TrashEntry trashEntry = TrashEntryLocalServiceUtil.getEntry(className, classPK);
        if (trashEntry.getRootEntry() != null) {
            portletURL.setParameter("className", className);
            portletURL.setParameter("classPK", String.valueOf(classPK));
        } else {
            portletURL.setParameter("trashEntryId", String.valueOf(trashEntry.getEntryId()));
        }
        portletURL.setParameter("showAssetMetadata", Boolean.TRUE.toString());
        return portletURL;
    }

    @Override
    public PortletURL getViewURL(HttpServletRequest httpServletRequest) throws PortalException {
        return PortletProviderUtil.getPortletURL(httpServletRequest, TrashEntry.class.getName(), PortletProvider.Action.VIEW);
    }

    @Override
    public boolean isInTrash(String className, long classPK) throws PortalException {
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler(className);
        if (trashHandler == null) {
            return false;
        }
        return trashHandler.isInTrash(classPK);
    }

    @Override
    public boolean isTrashEnabled(Group group) {
        boolean companyTrashEnabled = PrefsPropsUtil.getBoolean(group.getCompanyId(), "trash.enabled");
        if (!companyTrashEnabled) {
            return false;
        }
        UnicodeProperties typeSettingsProperties = group.getParentLiveGroupTypeSettingsProperties();
        return GetterUtil.getBoolean(typeSettingsProperties.getProperty("trashEnabled"), true);
    }

    @Override
    public boolean isTrashEnabled(long groupId) throws PortalException {
        return this.isTrashEnabled(GroupLocalServiceUtil.getGroup(groupId));
    }

    @Override
    public boolean isValidTrashTitle(String title) {
        return this.isValidTrashTitle(title, "/");
    }

    protected void addBreadcrumbEntries(HttpServletRequest httpServletRequest, LiferayPortletResponse liferayPortletResponse, String className, long classPK, String paramName, PortletURL containerModelURL, boolean checkInTrashContainers) throws PortalException, PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = PortletURLUtil.clone(containerModelURL, liferayPortletResponse);
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler(className);
        List<ContainerModel> containerModels = trashHandler.getParentContainerModels(classPK);
        Collections.reverse(containerModels);
        for (ContainerModel containerModel : containerModels) {
            TrashHandler containerModelTrashHandler = TrashHandlerRegistryUtil.getTrashHandler(containerModel.getModelClassName());
            if (checkInTrashContainers && !containerModelTrashHandler.isInTrash(containerModel.getContainerModelId())) continue;
            portletURL.setParameter(paramName, String.valueOf(containerModel.getContainerModelId()));
            String name = containerModel.getContainerModelName();
            if (containerModelTrashHandler.isInTrash(containerModel.getContainerModelId())) {
                name = this.getOriginalTitle(name);
            }
            PortalUtil.addPortletBreadcrumbEntry(httpServletRequest, name, portletURL.toString());
        }
        TrashRenderer trashRenderer = trashHandler.getTrashRenderer(classPK);
        PortalUtil.addPortletBreadcrumbEntry(httpServletRequest, trashRenderer.getTitle(themeDisplay.getLocale()), null);
    }

    protected String getOriginalTitle(String title, String paramName, String prefix) {
        block6: {
            if (!this.isValidTrashTitle(title, prefix)) {
                return title;
            }
            long trashEntryId = GetterUtil.getLong(title = title.substring(prefix.length()));
            if (trashEntryId <= 0L) {
                return title;
            }
            try {
                TrashEntry trashEntry = TrashEntryLocalServiceUtil.fetchEntry(trashEntryId);
                if (trashEntry == null) {
                    TrashVersion trashVersion = TrashVersionLocalServiceUtil.getTrashVersion(trashEntryId);
                    title = trashVersion.getTypeSettingsProperty(paramName);
                } else {
                    title = trashEntry.getTypeSettingsProperty(paramName);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug("No trash entry or trash version exists with ID " + trashEntryId);
            }
        }
        return title;
    }

    protected String getTrashTitle(long trashEntryId, String prefix) {
        return prefix.concat(String.valueOf(trashEntryId));
    }

    protected boolean isValidTrashTitle(String title, String prefix) {
        return title.startsWith(prefix);
    }
}

