/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.subscriptions.test;

import com.liferay.portal.test.mail.MailServiceTestUtil;
import com.liferay.portlet.subscriptions.test.BaseSubscriptionTestCase;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSubscriptionClassTypeTestCase
extends BaseSubscriptionTestCase {
    @Test
    public void testSubscriptionClassTypeWhenAddingBaseModel() throws Exception {
        long classTypeId = this.addClassType();
        this.addSubscriptionClassType(classTypeId);
        this.addBaseModelWithClassType(0L, classTypeId);
        Assert.assertEquals(1L, MailServiceTestUtil.getInboxSize());
    }

    @Test
    public void testSubscriptionClassTypeWhenUpdatingBaseModel() throws Exception {
        long classTypeId = this.addClassType();
        long baseModelId = this.addBaseModelWithClassType(0L, classTypeId);
        this.addSubscriptionClassType(classTypeId);
        this.updateBaseModel(this.creatorUser.getUserId(), baseModelId);
        Assert.assertEquals(1L, MailServiceTestUtil.getInboxSize());
    }

    @Test
    public void testSubscriptionDefaultClassTypeWhenAddingBaseModel() throws Exception {
        Long classTypeId = this.getDefaultClassTypeId();
        this.addSubscriptionClassType(classTypeId);
        this.addBaseModelWithClassType(0L, classTypeId);
        Assert.assertEquals(1L, MailServiceTestUtil.getInboxSize());
        this.deleteSubscriptionClassType(classTypeId);
    }

    @Test
    public void testSubscriptionDefaultClassTypeWhenUpdatingBaseModel() throws Exception {
        Long classTypeId = this.getDefaultClassTypeId();
        long baseModelId = this.addBaseModelWithClassType(0L, classTypeId);
        this.addSubscriptionClassType(classTypeId);
        this.updateBaseModel(this.creatorUser.getUserId(), baseModelId);
        Assert.assertEquals(1L, MailServiceTestUtil.getInboxSize());
        this.deleteSubscriptionClassType(classTypeId);
    }

    protected abstract long addBaseModelWithClassType(long var1, long var3) throws Exception;

    protected abstract long addClassType() throws Exception;

    protected abstract void addSubscriptionClassType(long var1) throws Exception;

    protected abstract void deleteSubscriptionClassType(long var1) throws Exception;

    protected abstract Long getDefaultClassTypeId() throws Exception;
}

