/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.subscriptions.test;

import com.liferay.portal.test.mail.MailServiceTestUtil;
import com.liferay.portlet.subscriptions.test.BaseSubscriptionTestCase;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSubscriptionAuthorTestCase
extends BaseSubscriptionTestCase {
    @Test
    public void testSubscriptionForAuthorWhenAddingBaseModel() throws Exception {
        long containerModelId = this.addContainerModel(this.creatorUser.getUserId(), 0L);
        this.addSubscription(this.creatorUser.getUserId(), containerModelId);
        this.addBaseModel(this.creatorUser.getUserId(), containerModelId);
        if (this.isSubscriptionForAuthorEnabled()) {
            Assert.assertEquals(1L, MailServiceTestUtil.getInboxSize());
        } else {
            Assert.assertEquals(0L, MailServiceTestUtil.getInboxSize());
        }
    }

    @Test
    public void testSubscriptionForAuthorWhenUpdatingBaseModel() throws Exception {
        long containerModelId = this.addContainerModel(this.creatorUser.getUserId(), 0L);
        long baseModelId = this.addBaseModel(this.creatorUser.getUserId(), containerModelId);
        this.addSubscription(this.creatorUser.getUserId(), containerModelId);
        this.updateBaseModel(this.creatorUser.getUserId(), baseModelId);
        if (this.isSubscriptionForAuthorEnabled()) {
            Assert.assertEquals(1L, MailServiceTestUtil.getInboxSize());
        } else {
            Assert.assertEquals(0L, MailServiceTestUtil.getInboxSize());
        }
    }

    protected abstract void addSubscription(long var1, long var3) throws Exception;

    protected boolean isSubscriptionForAuthorEnabled() {
        return false;
    }
}

