/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portlet.social.service.base.SocialRequestLocalServiceBaseImpl;
import com.liferay.social.kernel.exception.RequestUserIdException;
import com.liferay.social.kernel.model.SocialRequest;
import java.util.List;

public class SocialRequestLocalServiceImpl
extends SocialRequestLocalServiceBaseImpl {
    @Override
    public SocialRequest addRequest(long userId, long groupId, String className, long classPK, int type, String extraData, long receiverUserId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        User receiverUser = this.userPersistence.findByPrimaryKey(receiverUserId);
        long now = System.currentTimeMillis();
        if (userId == receiverUserId || user.isDefaultUser() || receiverUser.isDefaultUser() || user.getCompanyId() != receiverUser.getCompanyId()) {
            throw new RequestUserIdException();
        }
        long classNameId = this.classNameLocalService.getClassNameId(className);
        SocialRequest request = this.socialRequestPersistence.fetchByU_C_C_T_R(userId, classNameId, classPK, type, receiverUserId);
        if (request == null) {
            long requestId = this.counterLocalService.increment(SocialRequest.class.getName());
            request = this.socialRequestPersistence.create(requestId);
        }
        request.setGroupId(groupId);
        request.setCompanyId(user.getCompanyId());
        request.setUserId(user.getUserId());
        request.setCreateDate(now);
        request.setModifiedDate(now);
        request.setClassNameId(classNameId);
        request.setClassPK(classPK);
        request.setType(type);
        request.setExtraData(extraData);
        request.setReceiverUserId(receiverUserId);
        request.setStatus(3);
        this.socialRequestPersistence.update(request);
        return request;
    }

    @Override
    public void deleteReceiverUserRequests(long receiverUserId) {
        List<SocialRequest> requests = this.socialRequestPersistence.findByReceiverUserId(receiverUserId);
        for (SocialRequest request : requests) {
            this.deleteRequest(request);
        }
    }

    @Override
    public void deleteRequest(long requestId) throws PortalException {
        SocialRequest request = this.socialRequestPersistence.findByPrimaryKey(requestId);
        this.deleteRequest(request);
    }

    @Override
    public void deleteRequest(SocialRequest request) {
        this.socialRequestPersistence.remove(request);
    }

    @Override
    public void deleteRequests(long className, long classPK) {
        List<SocialRequest> requests = this.socialRequestPersistence.findByC_C(className, classPK);
        for (SocialRequest request : requests) {
            this.deleteRequest(request);
        }
    }

    @Override
    public void deleteUserRequests(long userId) {
        List<SocialRequest> requests = this.socialRequestPersistence.findByUserId(userId);
        for (SocialRequest request : requests) {
            this.deleteRequest(request);
        }
    }

    @Override
    public List<SocialRequest> getReceiverUserRequests(long receiverUserId, int start, int end) {
        return this.socialRequestPersistence.findByReceiverUserId(receiverUserId, start, end);
    }

    @Override
    public List<SocialRequest> getReceiverUserRequests(long receiverUserId, int status, int start, int end) {
        return this.socialRequestPersistence.findByR_S(receiverUserId, status, start, end);
    }

    @Override
    public int getReceiverUserRequestsCount(long receiverUserId) {
        return this.socialRequestPersistence.countByReceiverUserId(receiverUserId);
    }

    @Override
    public int getReceiverUserRequestsCount(long receiverUserId, int status) {
        return this.socialRequestPersistence.countByR_S(receiverUserId, status);
    }

    @Override
    public List<SocialRequest> getUserRequests(long userId, int start, int end) {
        return this.socialRequestPersistence.findByUserId(userId, start, end);
    }

    @Override
    public List<SocialRequest> getUserRequests(long userId, int status, int start, int end) {
        return this.socialRequestPersistence.findByU_S(userId, status, start, end);
    }

    @Override
    public int getUserRequestsCount(long userId) {
        return this.socialRequestPersistence.countByUserId(userId);
    }

    @Override
    public int getUserRequestsCount(long userId, int status) {
        return this.socialRequestPersistence.countByU_S(userId, status);
    }

    @Override
    public boolean hasRequest(long userId, String className, long classPK, int type, int status) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.socialRequestPersistence.countByU_C_C_T_S(userId, classNameId, classPK, type, status) > 0;
    }

    @Override
    public boolean hasRequest(long userId, String className, long classPK, int type, long receiverUserId, int status) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        SocialRequest socialRequest = this.socialRequestPersistence.fetchByU_C_C_T_R(userId, classNameId, classPK, type, receiverUserId);
        return socialRequest != null && socialRequest.getStatus() == status;
    }

    @Override
    public SocialRequest updateRequest(long requestId, int status, ThemeDisplay themeDisplay) throws PortalException {
        SocialRequest request = this.socialRequestPersistence.findByPrimaryKey(requestId);
        request.setModifiedDate(System.currentTimeMillis());
        request.setStatus(status);
        this.socialRequestPersistence.update(request);
        if (status == 1) {
            this.socialRequestInterpreterLocalService.processConfirmation(request, themeDisplay);
        } else if (status == 2) {
            this.socialRequestInterpreterLocalService.processRejection(request, themeDisplay);
        }
        return request;
    }
}

