/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.social.service.base.SocialRequestInterpreterLocalServiceBaseImpl;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import com.liferay.social.kernel.model.SocialRequest;
import com.liferay.social.kernel.model.SocialRequestFeedEntry;
import com.liferay.social.kernel.model.SocialRequestInterpreter;
import com.liferay.social.kernel.model.impl.SocialRequestInterpreterImpl;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SocialRequestInterpreterLocalServiceImpl
extends SocialRequestInterpreterLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(SocialRequestInterpreterLocalServiceImpl.class);
    private final List<SocialRequestInterpreter> _requestInterpreters = new CopyOnWriteArrayList<SocialRequestInterpreter>();
    private final ServiceRegistrationMap<SocialRequestInterpreter> _serviceRegistrations = new ServiceRegistrationMapImpl<SocialRequestInterpreter>();
    private ServiceTracker<SocialRequestInterpreter, SocialRequestInterpreter> _serviceTracker;

    @Override
    public void addRequestInterpreter(SocialRequestInterpreter requestInterpreter) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        SocialRequestInterpreterImpl requestInterpreterImpl = (SocialRequestInterpreterImpl)requestInterpreter;
        properties.put("javax.portlet.name", requestInterpreterImpl.getPortletId());
        ServiceRegistration<SocialRequestInterpreter> serviceRegistration = registry.registerService(SocialRequestInterpreter.class, requestInterpreter, properties);
        this._serviceRegistrations.put(requestInterpreter, serviceRegistration);
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(javax.portlet.name=*)(objectClass=" + SocialRequestInterpreter.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, new SocialRequestInterpreterServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    @Override
    public void deleteRequestInterpreter(SocialRequestInterpreter requestInterpreter) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove(requestInterpreter);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    @Override
    public SocialRequestFeedEntry interpret(SocialRequest request, ThemeDisplay themeDisplay) {
        String className = PortalUtil.getClassName(request.getClassNameId());
        for (SocialRequestInterpreter requestInterpreter : this._requestInterpreters) {
            SocialRequestFeedEntry requestFeedEntry;
            SocialRequestInterpreterImpl requestInterpreterImpl = (SocialRequestInterpreterImpl)requestInterpreter;
            if (!this.matches(requestInterpreterImpl, className, request) || (requestFeedEntry = requestInterpreterImpl.interpret(request, themeDisplay)) == null) continue;
            requestFeedEntry.setPortletId(requestInterpreterImpl.getPortletId());
            return requestFeedEntry;
        }
        return null;
    }

    @Override
    public void processConfirmation(SocialRequest request, ThemeDisplay themeDisplay) {
        String className = PortalUtil.getClassName(request.getClassNameId());
        for (SocialRequestInterpreter requestInterpreter : this._requestInterpreters) {
            boolean value;
            SocialRequestInterpreterImpl requestInterpreterImpl = (SocialRequestInterpreterImpl)requestInterpreter;
            if (!this.matches(requestInterpreterImpl, className, request) || !(value = requestInterpreterImpl.processConfirmation(request, themeDisplay))) continue;
            return;
        }
    }

    @Override
    public void processRejection(SocialRequest request, ThemeDisplay themeDisplay) {
        String className = PortalUtil.getClassName(request.getClassNameId());
        for (SocialRequestInterpreter requestInterpreter : this._requestInterpreters) {
            boolean value;
            SocialRequestInterpreterImpl requestInterpreterImpl = (SocialRequestInterpreterImpl)requestInterpreter;
            if (!this.matches(requestInterpreterImpl, className, request) || !(value = requestInterpreterImpl.processRejection(request, themeDisplay))) continue;
            return;
        }
    }

    protected String getSocialRequestPortletId(SocialRequest request) {
        try {
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject(request.getExtraData());
            return extraDataJSONObject.getString("portletId");
        }
        catch (JSONException jsone) {
            _log.error("Unable to create JSON object from " + request.getExtraData(), jsone);
            return "";
        }
    }

    protected boolean matches(SocialRequestInterpreterImpl requestInterpreter, String className, SocialRequest request) {
        if (!requestInterpreter.hasClassName(className)) {
            return false;
        }
        String requestPortletId = this.getSocialRequestPortletId(request);
        return Validator.isNull(requestPortletId) || requestPortletId.equals(requestInterpreter.getPortletId());
    }

    private class SocialRequestInterpreterServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SocialRequestInterpreter, SocialRequestInterpreter> {
        private SocialRequestInterpreterServiceTrackerCustomizer() {
        }

        @Override
        public SocialRequestInterpreter addingService(ServiceReference<SocialRequestInterpreter> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            SocialRequestInterpreter requestInterpreter = registry.getService(serviceReference);
            if (!(requestInterpreter instanceof SocialRequestInterpreterImpl)) {
                String portletId = (String)serviceReference.getProperty("javax.portlet.name");
                requestInterpreter = new SocialRequestInterpreterImpl(portletId, requestInterpreter);
            }
            SocialRequestInterpreterLocalServiceImpl.this._requestInterpreters.add(requestInterpreter);
            return requestInterpreter;
        }

        @Override
        public void modifiedService(ServiceReference<SocialRequestInterpreter> serviceReference, SocialRequestInterpreter requestInterpreter) {
        }

        @Override
        public void removedService(ServiceReference<SocialRequestInterpreter> serviceReference, SocialRequestInterpreter requestInterpreter) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            SocialRequestInterpreterLocalServiceImpl.this._requestInterpreters.remove(requestInterpreter);
        }
    }
}

