/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portlet.social.service.base.SocialActivitySetLocalServiceBaseImpl;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivitySet;
import com.liferay.social.kernel.util.comparator.SocialActivitySetModifiedDateComparator;
import java.util.List;

public class SocialActivitySetLocalServiceImpl
extends SocialActivitySetLocalServiceBaseImpl {
    @Override
    public SocialActivitySet addActivitySet(long activityId) throws PortalException {
        SocialActivity activity = this.socialActivityPersistence.findByPrimaryKey(activityId);
        long activitySetId = this.counterLocalService.increment();
        SocialActivitySet activitySet = this.socialActivitySetPersistence.create(activitySetId);
        activitySet.setGroupId(activity.getGroupId());
        activitySet.setCompanyId(activity.getCompanyId());
        activitySet.setUserId(activity.getUserId());
        activitySet.setCreateDate(activity.getCreateDate());
        activitySet.setModifiedDate(activity.getCreateDate());
        activitySet.setClassName(activity.getClassName());
        activitySet.setClassPK(activity.getClassPK());
        activitySet.setType(activity.getType());
        activitySet.setActivityCount(1);
        this.socialActivitySetPersistence.update(activitySet);
        activity.setActivitySetId(activitySetId);
        this.socialActivityPersistence.update(activity);
        return activitySet;
    }

    @Override
    public void decrementActivityCount(long activitySetId) throws PortalException {
        if (activitySetId == 0L) {
            return;
        }
        SocialActivitySet activitySet = this.socialActivitySetPersistence.fetchByPrimaryKey(activitySetId);
        if (activitySet == null) {
            return;
        }
        if (activitySet.getActivityCount() == 1) {
            this.socialActivitySetPersistence.remove(activitySetId);
            return;
        }
        activitySet.setActivityCount(activitySet.getActivityCount() - 1);
        this.socialActivitySetPersistence.update(activitySet);
    }

    @Override
    public void decrementActivityCount(long classNameId, long classPK) throws PortalException {
        List<SocialActivity> activities = this.socialActivityPersistence.findByC_C(classNameId, classPK);
        for (SocialActivity activity : activities) {
            this.decrementActivityCount(activity.getActivitySetId());
        }
    }

    @Override
    public SocialActivitySet getClassActivitySet(long classNameId, long classPK, int type) {
        return this.socialActivitySetPersistence.fetchByC_C_T_First(classNameId, classPK, type, new SocialActivitySetModifiedDateComparator());
    }

    @Override
    public SocialActivitySet getClassActivitySet(long userId, long classNameId, long classPK, int type) {
        return this.socialActivitySetPersistence.fetchByU_C_C_T_First(userId, classNameId, classPK, type, new SocialActivitySetModifiedDateComparator());
    }

    @Override
    public List<SocialActivitySet> getGroupActivitySets(long groupId, int start, int end) {
        return this.socialActivitySetPersistence.findByGroupId(groupId, start, end, new SocialActivitySetModifiedDateComparator());
    }

    @Override
    public int getGroupActivitySetsCount(long groupId) {
        return this.socialActivitySetPersistence.countByGroupId(groupId);
    }

    @Override
    public List<SocialActivitySet> getOrganizationActivitySets(long organizationId, int start, int end) {
        return this.socialActivitySetFinder.findByOrganizationId(organizationId, start, end);
    }

    @Override
    public int getOrganizationActivitySetsCount(long organizationId) {
        return this.socialActivitySetFinder.countByOrganizationId(organizationId);
    }

    @Override
    public List<SocialActivitySet> getRelationActivitySets(long userId, int start, int end) {
        return this.socialActivitySetFinder.findByRelation(userId, start, end);
    }

    @Override
    public List<SocialActivitySet> getRelationActivitySets(long userId, int type, int start, int end) {
        return this.socialActivitySetFinder.findByRelationType(userId, type, start, end);
    }

    @Override
    public int getRelationActivitySetsCount(long userId) {
        return this.socialActivitySetFinder.countByRelation(userId);
    }

    @Override
    public int getRelationActivitySetsCount(long userId, int type) {
        return this.socialActivitySetFinder.countByRelationType(userId, type);
    }

    @Override
    public SocialActivitySet getUserActivitySet(long groupId, long userId, int type) {
        return this.socialActivitySetPersistence.fetchByG_U_T_First(groupId, userId, type, new SocialActivitySetModifiedDateComparator());
    }

    @Override
    public SocialActivitySet getUserActivitySet(long groupId, long userId, long classNameId, int type) {
        return this.socialActivitySetPersistence.fetchByG_U_C_T_First(groupId, userId, classNameId, type, new SocialActivitySetModifiedDateComparator());
    }

    @Override
    public List<SocialActivitySet> getUserActivitySets(long userId, int start, int end) {
        return this.socialActivitySetPersistence.findByUserId(userId, start, end);
    }

    @Override
    public int getUserActivitySetsCount(long userId) {
        return this.socialActivitySetPersistence.countByUserId(userId);
    }

    @Override
    public List<SocialActivitySet> getUserGroupsActivitySets(long userId, int start, int end) {
        return this.socialActivitySetFinder.findByUserGroups(userId, start, end);
    }

    @Override
    public int getUserGroupsActivitySetsCount(long userId) {
        return this.socialActivitySetFinder.countByUserGroups(userId);
    }

    @Override
    public List<SocialActivitySet> getUserViewableActivitySets(long userId, int start, int end) {
        return this.socialActivitySetFinder.findByUser(userId, start, end);
    }

    @Override
    public int getUserViewableActivitySetsCount(long userId) {
        return this.socialActivitySetFinder.countByUser(userId);
    }

    @Override
    public void incrementActivityCount(long activitySetId, long activityId) throws PortalException {
        SocialActivitySet activitySet = this.socialActivitySetPersistence.findByPrimaryKey(activitySetId);
        SocialActivity activity = this.socialActivityPersistence.findByPrimaryKey(activityId);
        activitySet.setUserId(activity.getUserId());
        activitySet.setModifiedDate(activity.getCreateDate());
        activitySet.setActivityCount(activitySet.getActivityCount() + 1);
        this.socialActivitySetPersistence.update(activitySet);
        activity.setActivitySetId(activitySetId);
        this.socialActivityPersistence.update(activity);
    }
}

