/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.social.service.base.SocialActivityServiceBaseImpl;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.social.kernel.model.impl.SocialActivityInterpreterImpl;
import java.util.ArrayList;
import java.util.List;

public class SocialActivityServiceImpl
extends SocialActivityServiceBaseImpl {
    @Override
    public List<SocialActivity> getActivities(long classNameId, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getActivities(classNameId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public List<SocialActivity> getActivities(long mirrorActivityId, long classNameId, long classPK, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getActivities(mirrorActivityId, classNameId, classPK, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public List<SocialActivity> getActivities(long mirrorActivityId, String className, long classPK, int start, int end) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List<SocialActivity> activities = this.socialActivityLocalService.getActivities(mirrorActivityId, classNameId, classPK, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public List<SocialActivity> getActivities(String className, int start, int end) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List<SocialActivity> activities = this.socialActivityLocalService.getActivities(classNameId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public int getActivitiesCount(long classNameId) {
        return this.socialActivityLocalService.getActivitiesCount(classNameId);
    }

    @Override
    public int getActivitiesCount(long mirrorActivityId, long classNameId, long classPK) {
        return this.socialActivityLocalService.getActivitiesCount(mirrorActivityId, classNameId, classPK);
    }

    @Override
    public int getActivitiesCount(long mirrorActivityId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getActivitiesCount(mirrorActivityId, classNameId, classPK);
    }

    @Override
    public int getActivitiesCount(String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getActivitiesCount(classNameId);
    }

    @Override
    public SocialActivity getActivity(long activityId) throws PortalException {
        List<SocialActivityInterpreter> activityInterpreters;
        SocialActivity activity = this.socialActivityLocalService.getActivity(activityId);
        if (!this.hasPermission(activity, activityInterpreters = this.socialActivityInterpreterLocalService.getActivityInterpreters(""))) {
            throw new PrincipalException.MustHavePermission(0L, SocialActivity.class.getName(), activityId, new String[0]);
        }
        return activity;
    }

    @Override
    public List<SocialActivity> getActivitySetActivities(long activitySetId, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getActivitySetActivities(activitySetId, start, end);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public List<SocialActivity> getGroupActivities(long groupId, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getGroupActivities(groupId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public int getGroupActivitiesCount(long groupId) {
        return this.socialActivityLocalService.getGroupActivitiesCount(groupId);
    }

    @Override
    public List<SocialActivity> getGroupUsersActivities(long groupId, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getGroupUsersActivities(groupId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public int getGroupUsersActivitiesCount(long groupId) {
        return this.socialActivityLocalService.getGroupUsersActivitiesCount(groupId);
    }

    @Override
    public SocialActivity getMirrorActivity(long mirrorActivityId) throws PortalException {
        List<SocialActivityInterpreter> activityInterpreters;
        SocialActivity activity = this.socialActivityLocalService.getMirrorActivity(mirrorActivityId);
        if (!this.hasPermission(activity, activityInterpreters = this.socialActivityInterpreterLocalService.getActivityInterpreters(""))) {
            throw new PrincipalException.MustHavePermission(0L, SocialActivity.class.getName(), mirrorActivityId, new String[0]);
        }
        return activity;
    }

    @Override
    public List<SocialActivity> getOrganizationActivities(long organizationId, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getOrganizationActivities(organizationId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public int getOrganizationActivitiesCount(long organizationId) {
        return this.socialActivityLocalService.getOrganizationActivitiesCount(organizationId);
    }

    @Override
    public List<SocialActivity> getOrganizationUsersActivities(long organizationId, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getOrganizationUsersActivities(organizationId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public int getOrganizationUsersActivitiesCount(long organizationId) {
        return this.socialActivityLocalService.getOrganizationUsersActivitiesCount(organizationId);
    }

    @Override
    public List<SocialActivity> getRelationActivities(long userId, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getRelationActivities(userId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public List<SocialActivity> getRelationActivities(long userId, int type, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getRelationActivities(userId, type, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public int getRelationActivitiesCount(long userId) {
        return this.socialActivityLocalService.getRelationActivitiesCount(userId);
    }

    @Override
    public int getRelationActivitiesCount(long userId, int type) {
        return this.socialActivityLocalService.getRelationActivitiesCount(userId, type);
    }

    @Override
    public List<SocialActivity> getUserActivities(long userId, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getUserActivities(userId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public int getUserActivitiesCount(long userId) {
        return this.socialActivityLocalService.getUserActivitiesCount(userId);
    }

    @Override
    public List<SocialActivity> getUserGroupsActivities(long userId, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getUserGroupsActivities(userId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public int getUserGroupsActivitiesCount(long userId) {
        return this.socialActivityLocalService.getUserGroupsActivitiesCount(userId);
    }

    @Override
    public List<SocialActivity> getUserGroupsAndOrganizationsActivities(long userId, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getUserGroupsAndOrganizationsActivities(userId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public int getUserGroupsAndOrganizationsActivitiesCount(long userId) {
        return this.socialActivityLocalService.getUserGroupsAndOrganizationsActivitiesCount(userId);
    }

    @Override
    public List<SocialActivity> getUserOrganizationsActivities(long userId, int start, int end) throws PortalException {
        List<SocialActivity> activities = this.socialActivityLocalService.getUserOrganizationsActivities(userId, 0, end + PropsValues.SOCIAL_ACTIVITY_FILTER_SEARCH_LIMIT);
        return this.filterActivities(activities, start, end);
    }

    @Override
    public int getUserOrganizationsActivitiesCount(long userId) {
        return this.socialActivityLocalService.getUserOrganizationsActivitiesCount(userId);
    }

    protected List<SocialActivity> filterActivities(List<SocialActivity> activities, int start, int end) throws PortalException {
        List<SocialActivity> filteredActivities = new ArrayList<SocialActivity>();
        List<SocialActivityInterpreter> activityInterpreters = this.socialActivityInterpreterLocalService.getActivityInterpreters("");
        for (SocialActivity activity : activities) {
            if (this.hasPermission(activity, activityInterpreters)) {
                filteredActivities.add(activity);
            }
            if (end == -1 || filteredActivities.size() <= end) continue;
            break;
        }
        if (end != -1 && start != -1) {
            if (end > filteredActivities.size()) {
                end = filteredActivities.size();
            }
            if (start > filteredActivities.size()) {
                start = filteredActivities.size();
            }
            filteredActivities = filteredActivities.subList(start, end);
        }
        return filteredActivities;
    }

    protected boolean hasPermission(SocialActivity activity, List<SocialActivityInterpreter> activityInterpreters) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        ServiceContext serviceContext = new ServiceContext();
        for (SocialActivityInterpreter activityInterpreter : activityInterpreters) {
            SocialActivityInterpreterImpl activityInterpreterImpl = (SocialActivityInterpreterImpl)activityInterpreter;
            if (!activityInterpreterImpl.hasClassName(activity.getClassName())) continue;
            try {
                if (!activityInterpreterImpl.hasPermission(permissionChecker, activity, "VIEW", serviceContext)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }
}

