/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portlet.social.service.base.SocialActivityAchievementLocalServiceBaseImpl;
import com.liferay.social.kernel.model.SocialAchievement;
import com.liferay.social.kernel.model.SocialActivityAchievement;
import java.util.List;

public class SocialActivityAchievementLocalServiceImpl
extends SocialActivityAchievementLocalServiceBaseImpl {
    @Override
    public void addActivityAchievement(long userId, long groupId, SocialAchievement achievement) throws PortalException {
        SocialActivityAchievement activityAchievement = this.socialActivityAchievementPersistence.fetchByG_U_N(groupId, userId, achievement.getName());
        if (activityAchievement != null) {
            return;
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        long activityAchievementId = this.counterLocalService.increment();
        activityAchievement = this.socialActivityAchievementPersistence.create(activityAchievementId);
        activityAchievement.setGroupId(groupId);
        activityAchievement.setCompanyId(user.getCompanyId());
        activityAchievement.setUserId(userId);
        activityAchievement.setCreateDate(System.currentTimeMillis());
        int count = this.socialActivityAchievementPersistence.countByG_N(groupId, achievement.getName());
        if (count == 0) {
            activityAchievement.setFirstInGroup(true);
        }
        activityAchievement.setName(achievement.getName());
        this.socialActivityAchievementPersistence.update(activityAchievement);
        this.socialActivityCounterLocalService.incrementUserAchievementCounter(userId, groupId);
    }

    @Override
    public SocialActivityAchievement fetchUserAchievement(long userId, long groupId, String name) {
        return this.socialActivityAchievementPersistence.fetchByG_U_N(groupId, userId, name);
    }

    @Override
    public List<SocialActivityAchievement> getGroupAchievements(long groupId) {
        return this.socialActivityAchievementPersistence.findByGroupId(groupId);
    }

    @Override
    public List<SocialActivityAchievement> getGroupAchievements(long groupId, String name) {
        return this.socialActivityAchievementPersistence.findByG_N(groupId, name);
    }

    @Override
    public int getGroupAchievementsCount(long groupId) {
        return this.socialActivityAchievementPersistence.countByGroupId(groupId);
    }

    @Override
    public int getGroupAchievementsCount(long groupId, String name) {
        return this.socialActivityAchievementPersistence.countByG_N(groupId, name);
    }

    @Override
    public List<SocialActivityAchievement> getGroupFirstAchievements(long groupId) {
        return this.socialActivityAchievementPersistence.findByG_F(groupId, true);
    }

    @Override
    public int getGroupFirstAchievementsCount(long groupId) {
        return this.socialActivityAchievementPersistence.countByG_F(groupId, true);
    }

    @Override
    public List<SocialActivityAchievement> getUserAchievements(long userId, long groupId) {
        return this.socialActivityAchievementPersistence.findByG_U(groupId, userId);
    }

    @Override
    public int getUserAchievementsCount(long userId, long groupId) {
        return this.socialActivityAchievementPersistence.countByG_U(groupId, userId);
    }
}

