/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.http;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.social.kernel.model.SocialActivityCounterDefinition;
import com.liferay.social.kernel.model.SocialActivitySetting;
import com.liferay.social.kernel.model.SocialActivitySettingSoap;
import com.liferay.social.kernel.service.SocialActivitySettingServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SocialActivitySettingServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(SocialActivitySettingServiceSoap.class);

    public static SocialActivitySettingSoap[] getActivitySettings(long groupId) throws RemoteException {
        try {
            List<SocialActivitySetting> returnValue = SocialActivitySettingServiceUtil.getActivitySettings(groupId);
            return SocialActivitySettingSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String getJSONActivityDefinitions(long groupId, String className) throws RemoteException {
        try {
            JSONArray returnValue = SocialActivitySettingServiceUtil.getJSONActivityDefinitions(groupId, className);
            return returnValue.toString();
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void updateActivitySetting(long groupId, String className, boolean enabled) throws RemoteException {
        try {
            SocialActivitySettingServiceUtil.updateActivitySetting(groupId, className, enabled);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void updateActivitySetting(long groupId, String className, int activityType, SocialActivityCounterDefinition activityCounterDefinition) throws RemoteException {
        try {
            SocialActivitySettingServiceUtil.updateActivitySetting(groupId, className, activityType, activityCounterDefinition);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void updateActivitySettings(long groupId, String className, int activityType, List<SocialActivityCounterDefinition> activityCounterDefinitions) throws RemoteException {
        try {
            SocialActivitySettingServiceUtil.updateActivitySettings(groupId, className, activityType, activityCounterDefinitions);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

