/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivitySoap;
import com.liferay.social.kernel.service.SocialActivityServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SocialActivityServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(SocialActivityServiceSoap.class);

    public static SocialActivitySoap[] getActivities(long classNameId, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getActivities(classNameId, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getActivities(long mirrorActivityId, long classNameId, long classPK, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getActivities(mirrorActivityId, classNameId, classPK, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getActivities(long mirrorActivityId, String className, long classPK, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getActivities(mirrorActivityId, className, classPK, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getActivities(String className, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getActivities(className, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getActivitiesCount(long classNameId) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getActivitiesCount(classNameId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getActivitiesCount(long mirrorActivityId, long classNameId, long classPK) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getActivitiesCount(mirrorActivityId, classNameId, classPK);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getActivitiesCount(long mirrorActivityId, String className, long classPK) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getActivitiesCount(mirrorActivityId, className, classPK);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getActivitiesCount(String className) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getActivitiesCount(className);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap getActivity(long activityId) throws RemoteException {
        try {
            SocialActivity returnValue = SocialActivityServiceUtil.getActivity(activityId);
            return SocialActivitySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getActivitySetActivities(long activitySetId, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getActivitySetActivities(activitySetId, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getGroupActivities(long groupId, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getGroupActivities(groupId, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupActivitiesCount(long groupId) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getGroupActivitiesCount(groupId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getGroupUsersActivities(long groupId, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getGroupUsersActivities(groupId, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupUsersActivitiesCount(long groupId) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getGroupUsersActivitiesCount(groupId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap getMirrorActivity(long mirrorActivityId) throws RemoteException {
        try {
            SocialActivity returnValue = SocialActivityServiceUtil.getMirrorActivity(mirrorActivityId);
            return SocialActivitySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getOrganizationActivities(long organizationId, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getOrganizationActivities(organizationId, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getOrganizationActivitiesCount(long organizationId) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getOrganizationActivitiesCount(organizationId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getOrganizationUsersActivities(long organizationId, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getOrganizationUsersActivities(organizationId, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getOrganizationUsersActivitiesCount(long organizationId) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getOrganizationUsersActivitiesCount(organizationId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getRelationActivities(long userId, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getRelationActivities(userId, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getRelationActivities(long userId, int type, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getRelationActivities(userId, type, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getRelationActivitiesCount(long userId) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getRelationActivitiesCount(userId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getRelationActivitiesCount(long userId, int type) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getRelationActivitiesCount(userId, type);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getUserActivities(long userId, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getUserActivities(userId, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getUserActivitiesCount(long userId) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getUserActivitiesCount(userId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getUserGroupsActivities(long userId, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getUserGroupsActivities(userId, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getUserGroupsActivitiesCount(long userId) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getUserGroupsActivitiesCount(userId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getUserGroupsAndOrganizationsActivities(long userId, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getUserGroupsAndOrganizationsActivities(userId, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getUserGroupsAndOrganizationsActivitiesCount(long userId) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getUserGroupsAndOrganizationsActivitiesCount(userId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SocialActivitySoap[] getUserOrganizationsActivities(long userId, int start, int end) throws RemoteException {
        try {
            List<SocialActivity> returnValue = SocialActivityServiceUtil.getUserOrganizationsActivities(userId, start, end);
            return SocialActivitySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getUserOrganizationsActivitiesCount(long userId) throws RemoteException {
        try {
            int returnValue = SocialActivityServiceUtil.getUserOrganizationsActivitiesCount(userId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

