/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.model.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.social.model.impl.SocialActivityBaseImpl;
import java.util.Locale;

public class SocialActivityImpl
extends SocialActivityBaseImpl {
    private AssetEntry _assetEntry;
    private JSONObject _extraDataJSONObject;

    @Override
    public AssetEntry getAssetEntry() {
        if (this._assetEntry == null && Validator.isNotNull(this.getClassName()) && this.getClassPK() > 0L) {
            this._assetEntry = AssetEntryLocalServiceUtil.fetchEntry(this.getClassName(), this.getClassPK());
        }
        return this._assetEntry;
    }

    @Override
    public String getExtraDataValue(String key) throws JSONException {
        JSONObject extraDataJSONObject = this.getExtraDataJSONObject();
        return extraDataJSONObject.getString(key);
    }

    @Override
    public String getExtraDataValue(String key, Locale locale) throws JSONException {
        JSONObject extraDataJSONObject = this.getExtraDataJSONObject();
        return LocalizationUtil.getLocalization(extraDataJSONObject.getString(key), LocaleUtil.toLanguageId(locale));
    }

    @Override
    public boolean isClassName(String className) {
        if (className == null) {
            return false;
        }
        return className.equals(this.getClassName());
    }

    @Override
    public void setAssetEntry(AssetEntry assetEntry) {
        this._assetEntry = assetEntry;
    }

    @Override
    public void setExtraData(String extraData) {
        this._extraDataJSONObject = null;
        super.setExtraData(extraData);
    }

    @Override
    public void setExtraDataValue(String key, String value) throws JSONException {
        JSONObject extraDataJSONObject = this.getExtraDataJSONObject();
        extraDataJSONObject.put(key, value);
        super.setExtraData(extraDataJSONObject.toString());
    }

    protected JSONObject getExtraDataJSONObject() throws JSONException {
        if (this._extraDataJSONObject != null) {
            return this._extraDataJSONObject;
        }
        this._extraDataJSONObject = JSONFactoryUtil.createJSONObject(this.getExtraData());
        return this._extraDataJSONObject;
    }
}

