/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sitesadmin.search;

import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class SiteMembershipChecker
extends RowChecker {
    private static final Log _log = LogFactoryUtil.getLog(SiteMembershipChecker.class);
    private final Group _group;

    public SiteMembershipChecker(RenderResponse renderResponse, Group group) {
        super((PortletResponse)renderResponse);
        this._group = group;
    }

    @Override
    public boolean isChecked(Object obj) {
        User user = null;
        if (obj instanceof User) {
            user = (User)obj;
        } else if (obj instanceof Object[]) {
            user = (User)((Object[])obj)[0];
        } else {
            throw new IllegalArgumentException(obj + " is not a user");
        }
        try {
            return UserLocalServiceUtil.hasGroupUser(this._group.getGroupId(), user.getUserId());
        }
        catch (Exception e) {
            _log.error(e, e);
            return false;
        }
    }

    @Override
    public boolean isDisabled(Object obj) {
        User user = (User)obj;
        try {
            PermissionChecker permissionChecker;
            if (this.isChecked(user) ? SiteMembershipPolicyUtil.isMembershipProtected(permissionChecker = PermissionThreadLocal.getPermissionChecker(), user.getUserId(), this._group.getGroupId()) || SiteMembershipPolicyUtil.isMembershipRequired(user.getUserId(), this._group.getGroupId()) : !SiteMembershipPolicyUtil.isMembershipAllowed(user.getUserId(), this._group.getGroupId())) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return super.isDisabled(obj);
    }
}

