/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sites.util;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.exportimport.kernel.service.ExportImportServiceUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredLayoutException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.persistence.LayoutSetUtil;
import com.liferay.portal.kernel.service.persistence.LayoutUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.sites.kernel.util.Sites;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SitesImpl
implements Sites {
    private static final String _TEMP_DIR = SystemProperties.get("java.io.tmpdir") + "/liferay/layout_set_prototype/";
    private static final Log _log = LogFactoryUtil.getLog(SitesImpl.class);

    @Override
    public void addMergeFailFriendlyURLLayout(Layout layout) throws PortalException {
        LayoutSet layoutSet = layout.getLayoutSet();
        layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(layoutSet.getGroupId(), layoutSet.isPrivateLayout());
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        String mergeFailFriendlyURLLayouts = settingsProperties.getProperty("merge-fail-friendly-url-layouts", "");
        mergeFailFriendlyURLLayouts = StringUtil.add(mergeFailFriendlyURLLayouts, layout.getUuid());
        settingsProperties.setProperty("merge-fail-friendly-url-layouts", mergeFailFriendlyURLLayouts);
        LayoutSetLocalServiceUtil.updateLayoutSet(layoutSet);
    }

    @Override
    public void addPortletBreadcrumbEntries(Group group, HttpServletRequest httpServletRequest, PortletURL portletURL) throws Exception {
        List<Group> ancestorGroups = group.getAncestors();
        Collections.reverse(ancestorGroups);
        for (Group ancestorGroup : ancestorGroups) {
            portletURL.setParameter("groupId", String.valueOf(ancestorGroup.getGroupId()));
            PortalUtil.addPortletBreadcrumbEntry(httpServletRequest, ancestorGroup.getDescriptiveName(), portletURL.toString());
        }
        Group unescapedGroup = (Group)group.toUnescapedModel();
        portletURL.setParameter("groupId", String.valueOf(unescapedGroup.getGroupId()));
        PortalUtil.addPortletBreadcrumbEntry(httpServletRequest, unescapedGroup.getDescriptiveName(), portletURL.toString());
    }

    @Override
    public void addPortletBreadcrumbEntries(Group group, HttpServletRequest httpServletRequest, RenderResponse renderResponse) throws Exception {
        PortletURL portletURL = renderResponse.createRenderURL();
        this.addPortletBreadcrumbEntries(group, httpServletRequest, portletURL);
    }

    @Override
    public void addPortletBreadcrumbEntries(Group group, String pagesName, PortletURL redirectURL, HttpServletRequest httpServletRequest, RenderResponse renderResponse) throws Exception {
        if (renderResponse == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group unescapedGroup = (Group)group.toUnescapedModel();
        Locale locale = themeDisplay.getLocale();
        if (group.isLayoutPrototype()) {
            PortalUtil.addPortletBreadcrumbEntry(httpServletRequest, LanguageUtil.get(locale, "page-template"), null);
            PortalUtil.addPortletBreadcrumbEntry(httpServletRequest, unescapedGroup.getDescriptiveName(), redirectURL.toString());
        } else {
            PortalUtil.addPortletBreadcrumbEntry(httpServletRequest, unescapedGroup.getDescriptiveName(), null);
        }
        if (!group.isLayoutPrototype()) {
            PortalUtil.addPortletBreadcrumbEntry(httpServletRequest, LanguageUtil.get(locale, pagesName), redirectURL.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyLayoutPrototype(LayoutPrototype layoutPrototype, Layout targetLayout, boolean linkEnabled) throws Exception {
        Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
        LayoutTypePortlet targetLayoutType = (LayoutTypePortlet)targetLayout.getLayoutType();
        List<String> targetLayoutPortletIds = targetLayoutType.getPortletIds();
        Layout layoutPrototypeLayout = layoutPrototype.getLayout();
        byte[] iconBytes = null;
        if (layoutPrototypeLayout.isIconImage()) {
            Image image = ImageLocalServiceUtil.getImage(layoutPrototypeLayout.getIconImageId());
            iconBytes = image.getTextObj();
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Serializable originalLayoutPrototypeLinkEnabled = serviceContext.getAttribute("layoutPrototypeLinkEnabled");
        Serializable originalLayoutPrototypeUuid = serviceContext.getAttribute("layoutPrototypeUuid");
        try {
            serviceContext.setAttribute("layoutPrototypeLinkEnabled", Boolean.valueOf(linkEnabled));
            serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
            Locale targetSiteDefaultLocale = PortalUtil.getSiteDefaultLocale(targetLayout.getGroupId());
            LocaleThreadLocal.setSiteDefaultLocale(targetSiteDefaultLocale);
            targetLayout = LayoutLocalServiceUtil.updateLayout(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), targetLayout.getParentLayoutId(), targetLayout.getNameMap(), targetLayout.getTitleMap(), targetLayout.getDescriptionMap(), targetLayout.getKeywordsMap(), targetLayout.getRobotsMap(), layoutPrototypeLayout.getType(), targetLayout.isHidden(), targetLayout.getFriendlyURLMap(), layoutPrototypeLayout.isIconImage(), iconBytes, serviceContext);
        }
        finally {
            if (originalLayoutPrototypeLinkEnabled == null) {
                serviceContext.removeAttribute("layoutPrototypeLinkEnabled");
            } else {
                serviceContext.setAttribute("layoutPrototypeLinkEnabled", originalLayoutPrototypeLinkEnabled);
            }
            if (originalLayoutPrototypeUuid == null) {
                serviceContext.removeAttribute("layoutPrototypeUuid");
            } else {
                serviceContext.setAttribute("layoutPrototypeUuid", originalLayoutPrototypeUuid);
            }
            LocaleThreadLocal.setSiteDefaultLocale(siteDefaultLocale);
        }
        targetLayout = LayoutLocalServiceUtil.updateLayout(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), layoutPrototypeLayout.getTypeSettings());
        this.copyPortletPermissions(targetLayout, layoutPrototypeLayout);
        this.copyPortletSetups(layoutPrototypeLayout, targetLayout);
        this.copyLookAndFeel(targetLayout, layoutPrototypeLayout);
        this.deleteUnreferencedPortlets(targetLayoutPortletIds, targetLayout, layoutPrototypeLayout);
        targetLayout = LayoutLocalServiceUtil.getLayout(targetLayout.getPlid());
        UnicodeProperties typeSettingsProperties = targetLayout.getTypeSettingsProperties();
        Date modifiedDate = targetLayout.getModifiedDate();
        typeSettingsProperties.setProperty("last-merge-time", String.valueOf(modifiedDate.getTime()));
        LayoutLocalServiceUtil.updateLayout(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), targetLayout.getTypeSettings());
        UnicodeProperties prototypeTypeSettingsProperties = layoutPrototypeLayout.getTypeSettingsProperties();
        prototypeTypeSettingsProperties.setProperty("merge-fail-count", "0");
        LayoutLocalServiceUtil.updateLayout(layoutPrototypeLayout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyLayout(long userId, Layout sourceLayout, Layout targetLayout, ServiceContext serviceContext) throws Exception {
        User user = UserLocalServiceUtil.getUser(userId);
        Map<String, String[]> parameterMap = this.getLayoutSetPrototypeParameters(serviceContext);
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        Map<String, Serializable> exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap(user, sourceLayout.getGroupId(), sourceLayout.isPrivateLayout(), new long[]{sourceLayout.getLayoutId()}, parameterMap);
        ExportImportConfiguration exportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration(user.getUserId(), 0, exportLayoutSettingsMap);
        File file = ExportImportLocalServiceUtil.exportLayoutsAsFile(exportConfiguration);
        try {
            Map<String, Serializable> importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap(userId, targetLayout.getGroupId(), targetLayout.isPrivateLayout(), null, parameterMap, user.getLocale(), user.getTimeZone());
            ExportImportConfiguration importConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration(userId, 6, importLayoutSettingsMap);
            ExportImportLocalServiceUtil.importLayouts(importConfiguration, file);
        }
        finally {
            file.delete();
        }
    }

    @Override
    public void copyLookAndFeel(Layout targetLayout, Layout sourceLayout) throws Exception {
        LayoutLocalServiceUtil.updateLookAndFeel(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), sourceLayout.getThemeId(), sourceLayout.getColorSchemeId(), sourceLayout.getCss());
    }

    @Override
    public void copyPortletPermissions(Layout targetLayout, Layout sourceLayout) throws Exception {
        List<Role> roles = RoleLocalServiceUtil.getGroupRelatedRoles(targetLayout.getGroupId());
        Group targetGroup = targetLayout.getGroup();
        LayoutTypePortlet sourceLayoutTypePortlet = (LayoutTypePortlet)sourceLayout.getLayoutType();
        List<String> sourcePortletIds = sourceLayoutTypePortlet.getPortletIds();
        for (String sourcePortletId : sourcePortletIds) {
            String resourceName = PortletIdCodec.decodePortletName(sourcePortletId);
            String sourceResourcePrimKey = PortletPermissionUtil.getPrimaryKey(sourceLayout.getPlid(), sourcePortletId);
            String targetResourcePrimKey = PortletPermissionUtil.getPrimaryKey(targetLayout.getPlid(), sourcePortletId);
            List<String> actionIds = ResourceActionsUtil.getPortletResourceActions(resourceName);
            for (Role role : roles) {
                String roleName = role.getName();
                if (roleName.equals("Administrator") || !targetGroup.isLayoutSetPrototype() && targetLayout.isPrivateLayout() && roleName.equals("Guest")) continue;
                List<String> actions = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds(targetLayout.getCompanyId(), resourceName, 4, sourceResourcePrimKey, role.getRoleId(), actionIds);
                ResourcePermissionLocalServiceUtil.setResourcePermissions(targetLayout.getCompanyId(), resourceName, 4, targetResourcePrimKey, role.getRoleId(), actions.toArray(new String[0]));
            }
        }
    }

    @Override
    public void copyPortletSetups(Layout sourceLayout, Layout targetLayout) throws Exception {
        LayoutTypePortlet sourceLayoutTypePortlet = (LayoutTypePortlet)sourceLayout.getLayoutType();
        List<String> sourcePortletIds = sourceLayoutTypePortlet.getPortletIds();
        for (String sourcePortletId : sourcePortletIds) {
            PortletPreferences sourcePreferences = PortletPreferencesFactoryUtil.getPortletSetup(sourceLayout, sourcePortletId, null);
            PortletPreferencesImpl sourcePreferencesImpl = (PortletPreferencesImpl)sourcePreferences;
            PortletPreferences targetPreferences = PortletPreferencesFactoryUtil.getPortletSetup(targetLayout, sourcePortletId, null);
            PortletPreferencesImpl targetPreferencesImpl = (PortletPreferencesImpl)targetPreferences;
            PortletPreferencesLocalServiceUtil.updatePreferences(targetPreferencesImpl.getOwnerId(), targetPreferencesImpl.getOwnerType(), targetPreferencesImpl.getPlid(), sourcePortletId, sourcePreferences);
            if (sourcePreferencesImpl.getOwnerId() != 0L && sourcePreferencesImpl.getOwnerType() != 3) {
                sourcePreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup(sourceLayout, sourcePortletId);
                sourcePreferencesImpl = (PortletPreferencesImpl)sourcePreferences;
                targetPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup(targetLayout, sourcePortletId);
                targetPreferencesImpl = (PortletPreferencesImpl)targetPreferences;
                PortletPreferencesLocalServiceUtil.updatePreferences(targetPreferencesImpl.getOwnerId(), targetPreferencesImpl.getOwnerType(), targetPreferencesImpl.getPlid(), sourcePortletId, sourcePreferences);
            }
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            this.updateLayoutScopes(serviceContext.getUserId(), sourceLayout, targetLayout, sourcePreferences, targetPreferences, sourcePortletId, serviceContext.getLanguageId());
        }
    }

    @Override
    public void copyTypeSettings(Group sourceGroup, Group targetGroup) throws Exception {
        GroupServiceUtil.updateGroup(targetGroup.getGroupId(), sourceGroup.getTypeSettings());
    }

    @Override
    public Object[] deleteLayout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        long selPlid = ParamUtil.getLong(httpServletRequest, "selPlid");
        long groupId = ParamUtil.getLong(httpServletRequest, "groupId");
        boolean privateLayout = ParamUtil.getBoolean(httpServletRequest, "privateLayout");
        long layoutId = ParamUtil.getLong(httpServletRequest, "layoutId");
        Layout layout = null;
        if (selPlid <= 0L) {
            layout = LayoutLocalServiceUtil.getLayout(groupId, privateLayout, layoutId);
        } else {
            layout = LayoutLocalServiceUtil.getLayout(selPlid);
            groupId = layout.getGroupId();
            privateLayout = layout.isPrivateLayout();
            layoutId = layout.getLayoutId();
        }
        Group group = layout.getGroup();
        String oldFriendlyURL = themeDisplay.getLayoutFriendlyURL(layout);
        if (group.isStagingGroup() && !GroupPermissionUtil.contains(permissionChecker, group, "MANAGE_STAGING") && !GroupPermissionUtil.contains(permissionChecker, group, "PUBLISH_STAGING")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), group.getGroupId(), "MANAGE_STAGING", "PUBLISH_STAGING");
        }
        if (LayoutPermissionUtil.contains(permissionChecker, layout, "DELETE")) {
            LayoutType layoutType = layout.getLayoutType();
            EventsProcessorUtil.process("layout.configuration.action.delete", layoutType.getConfigurationActionDelete(), httpServletRequest, httpServletResponse);
        }
        if (group.isGuest() && !layout.isPrivateLayout() && layout.isRootLayout() && LayoutLocalServiceUtil.getLayoutsCount(group, false, 0L) == 1) {
            throw new RequiredLayoutException(1);
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance(httpServletRequest);
        LayoutServiceUtil.deleteLayout(groupId, privateLayout, layoutId, serviceContext);
        return new Object[]{group, oldFriendlyURL, 0L};
    }

    @Override
    public Object[] deleteLayout(PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest(portletRequest);
        HttpServletResponse httpServletResponse = PortalUtil.getHttpServletResponse(portletResponse);
        return this.deleteLayout(httpServletRequest, httpServletResponse);
    }

    @Override
    public void deleteLayout(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        HttpServletResponse httpServletResponse = PortalUtil.getHttpServletResponse((PortletResponse)renderResponse);
        this.deleteLayout(httpServletRequest, httpServletResponse);
    }

    @Override
    public File exportLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype, ServiceContext serviceContext) throws PortalException {
        BackgroundTask backgroundTask;
        User user = UserLocalServiceUtil.fetchUser(serviceContext.getUserId());
        if (user == null && (backgroundTask = BackgroundTaskManagerUtil.fetchBackgroundTask(BackgroundTaskThreadLocal.getBackgroundTaskId())) != null) {
            user = UserLocalServiceUtil.getUser(backgroundTask.getUserId());
        }
        if (user == null) {
            user = UserLocalServiceUtil.getUser(GetterUtil.getLong(PrincipalThreadLocal.getName()));
        }
        LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
        List<Layout> layoutSetPrototypeLayouts = LayoutLocalServiceUtil.getLayouts(layoutSet.getGroupId(), layoutSet.isPrivateLayout());
        Map<String, String[]> parameterMap = this.getLayoutSetPrototypeParameters(serviceContext);
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.FALSE.toString()});
        Map<String, Serializable> exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap(user, layoutSet.getGroupId(), layoutSet.isPrivateLayout(), ExportImportHelperUtil.getLayoutIds(layoutSetPrototypeLayouts), parameterMap);
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration(user.getUserId(), 0, exportLayoutSettingsMap);
        return ExportImportLocalServiceUtil.exportLayoutsAsFile(exportImportConfiguration);
    }

    @Override
    public Long[] filterGroups(List<Group> groups, String[] groupKeys) {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (Group group : groups) {
            if (ArrayUtil.contains(groupKeys, group.getGroupKey())) continue;
            groupIds.add(group.getGroupId());
        }
        return ArrayUtil.toArray(ArrayUtil.toLongArray(groupIds));
    }

    @Override
    public Layout getLayoutSetPrototypeLayout(Layout layout) {
        try {
            LayoutSet layoutSet = layout.getLayoutSet();
            if (!layoutSet.isLayoutSetPrototypeLinkActive()) {
                return null;
            }
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId(layoutSet.getLayoutSetPrototypeUuid(), layout.getCompanyId());
            return LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId(layout.getSourcePrototypeLayoutUuid(), layoutSetPrototype.getGroupId(), true);
        }
        catch (Exception e) {
            _log.error("Unable to fetch the the layout set prototype's layout", e);
            return null;
        }
    }

    @Override
    public Map<String, String[]> getLayoutSetPrototypeParameters(ServiceContext serviceContext) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_SETTINGS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_SETTINGS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUTS_IMPORT_MODE", new String[]{"CREATED_FROM_PROTOTYPE"});
        parameterMap.put("LOGO", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        return parameterMap;
    }

    @Override
    public int getMergeFailCount(LayoutPrototype layoutPrototype) throws PortalException {
        if (layoutPrototype == null || layoutPrototype.getLayoutPrototypeId() == 0L) {
            return 0;
        }
        Layout layoutPrototypeLayout = layoutPrototype.getLayout();
        UnicodeProperties prototypeTypeSettingsProperties = layoutPrototypeLayout.getTypeSettingsProperties();
        return GetterUtil.getInteger(prototypeTypeSettingsProperties.getProperty("merge-fail-count"));
    }

    @Override
    public int getMergeFailCount(LayoutSetPrototype layoutSetPrototype) throws PortalException {
        if (layoutSetPrototype == null || layoutSetPrototype.getLayoutSetPrototypeId() == 0L) {
            return 0;
        }
        LayoutSet layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
        UnicodeProperties layoutSetPrototypeSettingsProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
        return GetterUtil.getInteger(layoutSetPrototypeSettingsProperties.getProperty("merge-fail-count"));
    }

    @Override
    public List<Layout> getMergeFailFriendlyURLLayouts(LayoutSet layoutSet) throws PortalException {
        if (layoutSet == null) {
            return Collections.emptyList();
        }
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        String uuids = settingsProperties.getProperty("merge-fail-friendly-url-layouts");
        if (Validator.isNotNull(uuids)) {
            ArrayList<Layout> layouts = new ArrayList<Layout>();
            for (String uuid : StringUtil.split(uuids)) {
                Layout layout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId(uuid, layoutSet.getGroupId(), layoutSet.isPrivateLayout());
                layouts.add(layout);
            }
            return layouts;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getOrganizationNames(Group group, User user) throws Exception {
        List<Organization> organizations = OrganizationLocalServiceUtil.getGroupUserOrganizations(group.getGroupId(), user.getUserId());
        return ListUtil.toList(organizations, Organization.NAME_ACCESSOR);
    }

    @Override
    public List<String> getUserGroupNames(Group group, User user) throws Exception {
        List<UserGroup> userGroups = UserGroupLocalServiceUtil.getGroupUserUserGroups(group.getGroupId(), user.getUserId());
        return ListUtil.toList(userGroups, UserGroup.NAME_ACCESSOR);
    }

    @Override
    public void importLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        BackgroundTask backgroundTask;
        LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
        Map<String, String[]> parameterMap = this.getLayoutSetPrototypeParameters(serviceContext);
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.FALSE.toString()});
        this.setLayoutSetPrototypeLinkEnabledParameter(parameterMap, layoutSet, serviceContext);
        User user = UserLocalServiceUtil.fetchUser(serviceContext.getUserId());
        if (user == null && (backgroundTask = BackgroundTaskManagerUtil.fetchBackgroundTask(BackgroundTaskThreadLocal.getBackgroundTaskId())) != null) {
            user = UserLocalServiceUtil.getUser(backgroundTask.getUserId());
        }
        if (user == null) {
            user = UserLocalServiceUtil.getUser(GetterUtil.getLong(PrincipalThreadLocal.getName()));
        }
        Map<String, Serializable> importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap(user.getUserId(), layoutSet.getGroupId(), layoutSet.isPrivateLayout(), null, parameterMap, user.getLocale(), user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration(user.getUserId(), 6, importLayoutSettingsMap);
        ExportImportServiceUtil.importLayouts(exportImportConfiguration, inputStream);
    }

    @Override
    public boolean isContentSharingWithChildrenEnabled(Group group) {
        int companyContentSharingEnabled = PrefsPropsUtil.getInteger(group.getCompanyId(), "sites.content.sharing.with.children.enabled");
        if (companyContentSharingEnabled == 0) {
            return false;
        }
        UnicodeProperties typeSettingsProperties = group.getParentLiveGroupTypeSettingsProperties();
        int groupContentSharingEnabled = GetterUtil.getInteger(typeSettingsProperties.getProperty("contentSharingWithChildrenEnabled"), -1);
        return groupContentSharingEnabled == 3 || companyContentSharingEnabled == 2 && groupContentSharingEnabled == -1;
    }

    @Override
    public boolean isFirstLayout(long groupId, boolean privateLayout, long layoutId) {
        Layout firstLayout = LayoutLocalServiceUtil.fetchFirstLayout(groupId, privateLayout, 0L);
        return firstLayout != null && firstLayout.getLayoutId() == layoutId;
    }

    @Override
    public boolean isLayoutDeleteable(Layout layout) {
        block6: {
            try {
                if (layout instanceof VirtualLayout) {
                    return false;
                }
                if (Validator.isNull(layout.getSourcePrototypeLayoutUuid())) {
                    return true;
                }
                LayoutSet layoutSet = layout.getLayoutSet();
                if (!layoutSet.isLayoutSetPrototypeLinkActive()) {
                    return true;
                }
                if (LayoutLocalServiceUtil.hasLayoutSetPrototypeLayout(layoutSet.getLayoutSetPrototypeUuid(), layout.getCompanyId(), layout.getSourcePrototypeLayoutUuid())) {
                    return false;
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug(e, e);
            }
        }
        return true;
    }

    @Override
    public boolean isLayoutModifiedSinceLastMerge(Layout layout) {
        if (layout == null || Validator.isNull(layout.getSourcePrototypeLayoutUuid()) || layout.isLayoutPrototypeLinkActive() || !this.isLayoutUpdateable(layout)) {
            return false;
        }
        long lastMergeTime = GetterUtil.getLong(layout.getTypeSettingsProperty("last-merge-time"));
        if (lastMergeTime == 0L) {
            return false;
        }
        Date existingLayoutModifiedDate = layout.getModifiedDate();
        return existingLayoutModifiedDate != null && existingLayoutModifiedDate.getTime() > lastMergeTime;
    }

    @Override
    public boolean isLayoutSetMergeable(Group group, LayoutSet layoutSet) throws PortalException {
        LayoutSetPrototype layoutSetPrototype;
        Date modifiedDate;
        if (!layoutSet.isLayoutSetPrototypeLinkActive() || group.isLayoutPrototype() || group.isLayoutSetPrototype()) {
            return false;
        }
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        long lastMergeTime = GetterUtil.getLong(settingsProperties.getProperty("last-merge-time"));
        if (lastMergeTime >= (modifiedDate = (layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId(layoutSet.getLayoutSetPrototypeUuid(), layoutSet.getCompanyId())).getModifiedDate()).getTime()) {
            return false;
        }
        LayoutSet layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
        UnicodeProperties layoutSetPrototypeSettingsProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
        int mergeFailCount = GetterUtil.getInteger(layoutSetPrototypeSettingsProperties.getProperty("merge-fail-count"));
        if (mergeFailCount > PropsValues.LAYOUT_SET_PROTOTYPE_MERGE_FAIL_THRESHOLD) {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(6);
                sb.append("Merge not performed because the fail threshold ");
                sb.append("was reached for layoutSetPrototypeId ");
                sb.append(layoutSetPrototype.getLayoutSetPrototypeId());
                sb.append(" and layoutId ");
                sb.append(layoutSetPrototypeLayoutSet.getLayoutSetId());
                sb.append(". Update the count in the database to try again.");
                _log.warn(sb.toString());
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isLayoutSetPrototypeUpdateable(LayoutSet layoutSet) {
        block4: {
            if (!layoutSet.isLayoutSetPrototypeLinkActive()) {
                return true;
            }
            try {
                LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId(layoutSet.getLayoutSetPrototypeUuid(), layoutSet.getCompanyId());
                String layoutsUpdateable = layoutSetPrototype.getSettingsProperty("layoutsUpdateable");
                if (Validator.isNotNull(layoutsUpdateable)) {
                    return GetterUtil.getBoolean(layoutsUpdateable, true);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug(e, e);
            }
        }
        return true;
    }

    @Override
    public boolean isLayoutSortable(Layout layout) {
        return this.isLayoutDeleteable(layout);
    }

    @Override
    public boolean isLayoutUpdateable(Layout layout) {
        block8: {
            try {
                if (layout instanceof VirtualLayout) {
                    return false;
                }
                if (Validator.isNull(layout.getLayoutPrototypeUuid()) && Validator.isNull(layout.getSourcePrototypeLayoutUuid())) {
                    return true;
                }
                LayoutSet layoutSet = layout.getLayoutSet();
                if (layoutSet.isLayoutSetPrototypeLinkActive()) {
                    boolean layoutSetPrototypeUpdateable = this.isLayoutSetPrototypeUpdateable(layoutSet);
                    if (!layoutSetPrototypeUpdateable) {
                        return false;
                    }
                    Layout layoutSetPrototypeLayout = this.getLayoutSetPrototypeLayout(layout);
                    if (layoutSetPrototypeLayout == null) {
                        return true;
                    }
                    String layoutUpdateable = layoutSetPrototypeLayout.getTypeSettingsProperty("layoutUpdateable");
                    if (Validator.isNull(layoutUpdateable)) {
                        return true;
                    }
                    return GetterUtil.getBoolean(layoutUpdateable);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug(e, e);
            }
        }
        return true;
    }

    @Override
    public boolean isUserGroupLayout(Layout layout) throws PortalException {
        if (!(layout instanceof VirtualLayout)) {
            return false;
        }
        VirtualLayout virtualLayout = (VirtualLayout)layout;
        Layout sourceLayout = virtualLayout.getSourceLayout();
        Group sourceGroup = sourceLayout.getGroup();
        return sourceGroup.isUserGroup();
    }

    @Override
    public boolean isUserGroupLayoutSetViewable(PermissionChecker permissionChecker, Group userGroupGroup) throws PortalException {
        if (!userGroupGroup.isUserGroup()) {
            return false;
        }
        if (GroupPermissionUtil.contains(permissionChecker, userGroupGroup, "VIEW")) {
            return true;
        }
        UserGroup userGroup = UserGroupLocalServiceUtil.getUserGroup(userGroupGroup.getClassPK());
        return UserLocalServiceUtil.hasUserGroupUser(userGroup.getUserGroupId(), permissionChecker.getUserId());
    }

    @Override
    public void mergeLayoutPrototypeLayout(Group group, Layout layout) throws Exception {
        Group layoutSetPrototypeGroup;
        Layout sourcePrototypeLayout;
        String sourcePrototypeLayoutUuid = layout.getSourcePrototypeLayoutUuid();
        if (Validator.isNull(sourcePrototypeLayoutUuid)) {
            this.doMergeLayoutPrototypeLayout(group, layout);
            return;
        }
        LayoutSet layoutSet = layout.getLayoutSet();
        long layoutSetPrototypeId = layoutSet.getLayoutSetPrototypeId();
        if (layoutSetPrototypeId > 0L && (sourcePrototypeLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId(sourcePrototypeLayoutUuid, (layoutSetPrototypeGroup = GroupLocalServiceUtil.getLayoutSetPrototypeGroup(layout.getCompanyId(), layoutSetPrototypeId)).getGroupId(), true)) != null) {
            this.doMergeLayoutPrototypeLayout(layoutSetPrototypeGroup, sourcePrototypeLayout);
        }
        this.doMergeLayoutPrototypeLayout(group, layout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeLayoutSetPrototypeLayouts(Group group, LayoutSet layoutSet) throws Exception {
        if (!this.isLayoutSetMergeable(group, layoutSet)) {
            return;
        }
        String owner = this._acquireLock(LayoutSet.class.getName(), layoutSet.getLayoutSetId(), 1000L * PropsValues.LAYOUT_SET_PROTOTYPE_MERGE_LOCK_MAX_TIME);
        if (owner == null) {
            return;
        }
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId(layoutSet.getLayoutSetPrototypeUuid(), layoutSet.getCompanyId());
        try {
            MergeLayoutPrototypesThreadLocal.setInProgress(true);
            boolean importData = true;
            long lastMergeTime = GetterUtil.getLong(settingsProperties.getProperty("last-merge-time"));
            long lastResetTime = GetterUtil.getLong(settingsProperties.getProperty("last-reset-time"));
            if (lastMergeTime > 0L || lastResetTime > 0L) {
                importData = false;
            }
            Map<String, String[]> parameterMap = this.getLayoutSetPrototypesParameters(importData);
            layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(layoutSet.getLayoutSetId());
            this.removeMergeFailFriendlyURLLayouts(layoutSet);
            this.importLayoutSetPrototype(layoutSetPrototype, layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parameterMap, importData);
        }
        catch (Exception e) {
            LayoutSet layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
            UnicodeProperties layoutSetPrototypeSettingsProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
            int mergeFailCount = GetterUtil.getInteger(layoutSetPrototypeSettingsProperties.getProperty("merge-fail-count"));
            StringBundler sb = new StringBundler(6);
            sb.append("Merge fail count increased to ");
            sb.append(++mergeFailCount);
            sb.append(" for layout set prototype ");
            sb.append(layoutSetPrototype.getLayoutSetPrototypeId());
            sb.append(" and layout set ");
            sb.append(layoutSet.getLayoutSetId());
            _log.error(sb.toString(), e);
            layoutSetPrototypeSettingsProperties.setProperty("merge-fail-count", String.valueOf(mergeFailCount));
            LayoutSetUtil.updateImpl(layoutSetPrototypeLayoutSet);
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setInProgress(false);
            this._releaseLock(LayoutSet.class.getName(), layoutSet.getLayoutSetId(), owner);
        }
    }

    @Override
    public void removeMergeFailFriendlyURLLayouts(LayoutSet layoutSet) throws PortalException {
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        settingsProperties.remove("merge-fail-friendly-url-layouts");
        LayoutSetLocalServiceUtil.updateLayoutSet(layoutSet);
    }

    @Override
    public void resetPrototype(Layout layout) throws PortalException {
        this.checkResetPrototypePermissions(layout.getGroup(), layout);
        this.doResetPrototype(layout);
    }

    @Override
    public void resetPrototype(LayoutSet layoutSet) throws PortalException {
        this.checkResetPrototypePermissions(layoutSet.getGroup(), null);
        this.doResetPrototype(layoutSet);
    }

    @Override
    public void setMergeFailCount(LayoutPrototype layoutPrototype, int newMergeFailCount) throws PortalException {
        Layout layoutPrototypeLayout = layoutPrototype.getLayout();
        UnicodeProperties prototypeTypeSettingsProperties = layoutPrototypeLayout.getTypeSettingsProperties();
        if (newMergeFailCount == 0) {
            prototypeTypeSettingsProperties.remove("merge-fail-count");
        } else {
            prototypeTypeSettingsProperties.setProperty("merge-fail-count", String.valueOf(newMergeFailCount));
        }
        LayoutServiceUtil.updateLayout(layoutPrototypeLayout.getGroupId(), layoutPrototypeLayout.isPrivateLayout(), layoutPrototypeLayout.getLayoutId(), layoutPrototypeLayout.getTypeSettings());
    }

    @Override
    public void setMergeFailCount(LayoutSetPrototype layoutSetPrototype, int newMergeFailCount) throws PortalException {
        LayoutSet layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
        UnicodeProperties layoutSetPrototypeSettingsProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
        if (newMergeFailCount == 0) {
            layoutSetPrototypeSettingsProperties.remove("merge-fail-count");
        } else {
            layoutSetPrototypeSettingsProperties.setProperty("merge-fail-count", String.valueOf(newMergeFailCount));
        }
        LayoutSetServiceUtil.updateSettings(layoutSetPrototypeLayoutSet.getGroupId(), layoutSetPrototypeLayoutSet.isPrivateLayout(), layoutSetPrototypeLayoutSet.getSettings());
    }

    @Override
    public void updateLayoutScopes(long userId, Layout sourceLayout, Layout targetLayout, PortletPreferences sourcePreferences, PortletPreferences targetPreferences, String sourcePortletId, String languageId) throws Exception {
        String scopeType = GetterUtil.getString(sourcePreferences.getValue("lfrScopeType", null));
        if (Validator.isNull(scopeType) || !scopeType.equals("layout")) {
            return;
        }
        Layout targetScopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId(targetLayout.getUuid(), targetLayout.getGroupId(), targetLayout.isPrivateLayout());
        if (!targetScopeLayout.hasScopeGroup()) {
            GroupLocalServiceUtil.addGroup(userId, 0L, Layout.class.getName(), targetLayout.getPlid(), 0L, targetLayout.getNameMap(), null, 0, true, 0, null, false, true, null);
        }
        String portletTitle = PortalUtil.getPortletTitle(PortletIdCodec.decodePortletName(sourcePortletId), languageId);
        String newPortletTitle = PortalUtil.getNewPortletTitle(portletTitle, String.valueOf(sourceLayout.getLayoutId()), targetLayout.getName(languageId));
        targetPreferences.setValue("groupId", String.valueOf(targetLayout.getGroupId()));
        targetPreferences.setValue("lfrScopeType", "layout");
        targetPreferences.setValue("lfrScopeLayoutUuid", targetLayout.getUuid());
        targetPreferences.setValue("portletSetupTitle_" + languageId, newPortletTitle);
        targetPreferences.setValue("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        targetPreferences.store();
    }

    @Override
    public void updateLayoutSetPrototypesLinks(Group group, long publicLayoutSetPrototypeId, long privateLayoutSetPrototypeId, boolean publicLayoutSetPrototypeLinkEnabled, boolean privateLayoutSetPrototypeLinkEnabled) throws Exception {
        this.updateLayoutSetPrototypeLink(group.getGroupId(), true, privateLayoutSetPrototypeId, privateLayoutSetPrototypeLinkEnabled);
        this.updateLayoutSetPrototypeLink(group.getGroupId(), false, publicLayoutSetPrototypeId, publicLayoutSetPrototypeLinkEnabled);
    }

    protected void checkResetPrototypePermissions(Group group, Layout layout) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (layout != null && !LayoutPermissionUtil.contains(permissionChecker, layout, "UPDATE")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, layout.getName(), layout.getLayoutId(), "UPDATE");
        }
        if (!(GroupPermissionUtil.contains(permissionChecker, group, "UPDATE") || group.isUser() && permissionChecker.getUserId() == group.getClassPK())) {
            throw new PrincipalException.MustHavePermission(permissionChecker, group.getName(), group.getGroupId(), "UPDATE");
        }
    }

    protected void deleteUnreferencedPortlets(List<String> targetLayoutPortletIds, Layout targetLayout, Layout sourceLayout) throws Exception {
        LayoutTypePortlet sourceLayoutType = (LayoutTypePortlet)sourceLayout.getLayoutType();
        ArrayList<String> unreferencedPortletIds = new ArrayList<String>(targetLayoutPortletIds);
        unreferencedPortletIds.removeAll(sourceLayoutType.getPortletIds());
        PortletLocalServiceUtil.deletePortlets(targetLayout.getCompanyId(), unreferencedPortletIds.toArray(new String[0]), targetLayout.getPlid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMergeLayoutPrototypeLayout(Group group, Layout layout) throws Exception {
        LayoutPrototype layoutPrototype;
        Layout layoutPrototypeLayout;
        Date modifiedDate;
        if (!layout.isLayoutPrototypeLinkActive() || group.isLayoutPrototype() || group.hasStagingGroup()) {
            return;
        }
        long lastMergeTime = GetterUtil.getLong(layout.getTypeSettingsProperty("last-merge-time"));
        if (lastMergeTime == 0L) {
            try {
                MergeLayoutPrototypesThreadLocal.setInProgress(true);
                Layout targetLayout = LayoutLocalServiceUtil.getLayout(layout.getPlid());
                if (targetLayout != null) {
                    lastMergeTime = GetterUtil.getLong(targetLayout.getTypeSettingsProperty("last-merge-time"));
                }
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setInProgress(false);
            }
        }
        if (lastMergeTime >= (modifiedDate = (layoutPrototypeLayout = (layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuidAndCompanyId(layout.getLayoutPrototypeUuid(), layout.getCompanyId())).getLayout()).getModifiedDate()).getTime()) {
            return;
        }
        UnicodeProperties prototypeTypeSettingsProperties = layoutPrototypeLayout.getTypeSettingsProperties();
        int mergeFailCount = GetterUtil.getInteger(prototypeTypeSettingsProperties.getProperty("merge-fail-count"));
        if (mergeFailCount > PropsValues.LAYOUT_PROTOTYPE_MERGE_FAIL_THRESHOLD) {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(6);
                sb.append("Merge not performed because the fail threshold ");
                sb.append("was reached for layoutPrototypeId ");
                sb.append(layoutPrototype.getLayoutPrototypeId());
                sb.append(" and layoutId ");
                sb.append(layoutPrototypeLayout.getLayoutId());
                sb.append(". Update the count in the database to try again.");
                _log.warn(sb.toString());
            }
            return;
        }
        String owner = this._acquireLock(Layout.class.getName(), layout.getPlid(), 1000L * PropsValues.LAYOUT_PROTOTYPE_MERGE_LOCK_MAX_TIME);
        if (owner == null) {
            return;
        }
        try {
            MergeLayoutPrototypesThreadLocal.setInProgress(true);
            this.applyLayoutPrototype(layoutPrototype, layout, true);
        }
        catch (Exception e) {
            _log.error(e, e);
            prototypeTypeSettingsProperties.setProperty("merge-fail-count", String.valueOf(++mergeFailCount));
            LayoutUtil.updateImpl(layoutPrototypeLayout);
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setInProgress(false);
            this._releaseLock(Layout.class.getName(), layout.getPlid(), owner);
        }
    }

    protected void doResetPrototype(Layout layout) throws PortalException {
        layout.setModifiedDate(null);
        LayoutLocalServiceUtil.updateLayout(layout);
        LayoutSet layoutSet = layout.getLayoutSet();
        this.doResetPrototype(layoutSet);
    }

    protected void doResetPrototype(LayoutSet layoutSet) throws PortalException {
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        settingsProperties.remove("last-merge-time");
        settingsProperties.setProperty("last-reset-time", String.valueOf(System.currentTimeMillis()));
        LayoutSetLocalServiceUtil.updateLayoutSet(layoutSet);
    }

    protected Map<String, String[]> getLayoutSetPrototypesParameters(boolean importData) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("IGNORE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_SETTINGS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_SETTINGS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUTS_IMPORT_MODE", new String[]{"CREATED_FROM_PROTOTYPE"});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        if (importData) {
            parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
            parameterMap.put("LOGO", new String[]{Boolean.TRUE.toString()});
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
            parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        } else {
            if (PropsValues.LAYOUT_SET_PROTOTYPE_PROPAGATE_LOGO) {
                parameterMap.put("LOGO", new String[]{Boolean.TRUE.toString()});
            } else {
                parameterMap.put("LOGO", new String[]{Boolean.FALSE.toString()});
            }
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
            parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.FALSE.toString()});
        }
        return parameterMap;
    }

    protected void importLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, boolean importData) throws PortalException {
        String cacheFileName;
        File cacheFile = null;
        File file = null;
        if (!importData && (cacheFile = new File(cacheFileName = StringBundler.concat(_TEMP_DIR, layoutSetPrototype.getUuid(), ".v", layoutSetPrototype.getMvccVersion(), ".lar"))).exists()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Using cached layout set prototype LAR file " + cacheFile.getAbsolutePath());
            }
            file = cacheFile;
        }
        User user = UserLocalServiceUtil.getDefaultUser(layoutSetPrototype.getCompanyId());
        if (file == null) {
            List<Layout> layoutSetPrototypeLayouts = LayoutLocalServiceUtil.getLayouts(layoutSetPrototype.getGroupId(), true);
            Map<String, Serializable> exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap(user, layoutSetPrototype.getGroupId(), true, ExportImportHelperUtil.getLayoutIds(layoutSetPrototypeLayouts), parameterMap);
            ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addDraftExportImportConfiguration(user.getUserId(), 0, exportLayoutSettingsMap);
            file = ExportImportLocalServiceUtil.exportLayoutsAsFile(exportImportConfiguration);
        }
        Map<String, Serializable> importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap(user.getUserId(), groupId, privateLayout, null, parameterMap, user.getLocale(), user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.addExportImportConfiguration(user.getUserId(), groupId, "", "", 6, importLayoutSettingsMap, 2, new ServiceContext());
        ExportImportLocalServiceUtil.importLayouts(exportImportConfiguration, file);
        if (cacheFile != null && !cacheFile.exists()) {
            try {
                FileUtil.copyFile(file, cacheFile);
                if (_log.isDebugEnabled()) {
                    _log.debug(StringBundler.concat("Copied ", file.getAbsolutePath(), " to ", cacheFile.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                _log.error(StringBundler.concat("Unable to copy file ", file.getAbsolutePath(), " to ", cacheFile.getAbsolutePath()), e);
            }
        }
    }

    protected void setLayoutSetPrototypeLinkEnabledParameter(Map<String, String[]> parameterMap, LayoutSet targetLayoutSet, ServiceContext serviceContext) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null || !PortalPermissionUtil.contains(permissionChecker, "UNLINK_LAYOUT_SET_PROTOTYPE")) {
            return;
        }
        if (targetLayoutSet.isPrivateLayout()) {
            boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean(serviceContext, "privateLayoutSetPrototypeLinkEnabled", true);
            if (!privateLayoutSetPrototypeLinkEnabled) {
                privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean(serviceContext, "layoutSetPrototypeLinkEnabled");
            }
            parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{String.valueOf(privateLayoutSetPrototypeLinkEnabled)});
        } else {
            boolean publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean(serviceContext, "publicLayoutSetPrototypeLinkEnabled");
            if (!publicLayoutSetPrototypeLinkEnabled) {
                publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean(serviceContext, "layoutSetPrototypeLinkEnabled", true);
            }
            parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{String.valueOf(publicLayoutSetPrototypeLinkEnabled)});
        }
    }

    protected void updateLayoutSetPrototypeLink(long groupId, boolean privateLayout, long layoutSetPrototypeId, boolean layoutSetPrototypeLinkEnabled) throws Exception {
        LayoutSetPrototype layoutSetPrototype;
        String layoutSetPrototypeUuid = null;
        if (layoutSetPrototypeId > 0L && (layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.fetchLayoutSetPrototype(layoutSetPrototypeId)) != null) {
            layoutSetPrototypeUuid = layoutSetPrototype.getUuid();
            if (!layoutSetPrototypeLinkEnabled && layoutSetPrototypeId > 0L) {
                Map<String, String[]> parameterMap = this.getLayoutSetPrototypesParameters(true);
                this.importLayoutSetPrototype(layoutSetPrototype, groupId, privateLayout, parameterMap, true);
            }
        }
        LayoutSetServiceUtil.updateLayoutSetPrototypeLinkEnabled(groupId, privateLayout, layoutSetPrototypeLinkEnabled, layoutSetPrototypeUuid);
        LayoutLocalServiceUtil.updatePriorities(groupId, privateLayout);
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(groupId, privateLayout);
        this.mergeLayoutSetPrototypeLayouts(group, layoutSet);
    }

    private String _acquireLock(String className, long classPK, long mergeLockMaxTime) {
        String owner;
        block5: {
            owner = PortalUUIDUtil.generate();
            try {
                Lock lock = LockManagerUtil.lock(SitesImpl.class.getName(), String.valueOf(classPK), owner);
                if (owner.equals(lock.getOwner())) break block5;
                Date createDate = lock.getCreateDate();
                if (System.currentTimeMillis() - createDate.getTime() >= mergeLockMaxTime) {
                    lock = LockManagerUtil.lock(SitesImpl.class.getName(), String.valueOf(classPK), lock.getOwner(), owner);
                    if (!owner.equals(lock.getOwner())) {
                        return null;
                    }
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Acquired lock for ", SitesImpl.class.getName(), " to update ", className, "#", classPK));
        }
        return owner;
    }

    private void _releaseLock(String className, long classPK, String owner) {
        LockManagerUtil.unlock(SitesImpl.class.getName(), String.valueOf(classPK), owner);
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Released lock for ", SitesImpl.class.getName(), " to update ", className, "#", classPK));
        }
    }
}

