/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sites.search;

import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class UserGroupRoleUserChecker
extends RowChecker {
    private static final Log _log = LogFactoryUtil.getLog(UserGroupRoleUserChecker.class);
    private final Group _group;
    private final Role _role;

    public UserGroupRoleUserChecker(RenderResponse renderResponse, Group group, Role role) {
        super((PortletResponse)renderResponse);
        this._group = group;
        this._role = role;
    }

    @Override
    public boolean isChecked(Object obj) {
        User user = (User)obj;
        try {
            return UserGroupRoleLocalServiceUtil.hasUserGroupRole(user.getUserId(), this._group.getGroupId(), this._role.getRoleId());
        }
        catch (Exception e) {
            _log.error(e, e);
            return false;
        }
    }

    @Override
    public boolean isDisabled(Object obj) {
        User user = (User)obj;
        try {
            if (this.isChecked(user) ? SiteMembershipPolicyUtil.isRoleRequired(user.getUserId(), this._group.getGroupId(), this._role.getRoleId()) : !SiteMembershipPolicyUtil.isRoleAllowed(user.getUserId(), this._group.getGroupId(), this._role.getRoleId())) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return super.isDisabled(obj);
    }
}

