/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sites.action;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static void copyPreferences(HttpServletRequest httpServletRequest, Layout targetLayout, Layout sourceLayout) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LayoutTypePortlet sourceLayoutTypePortlet = (LayoutTypePortlet)sourceLayout.getLayoutType();
        List<String> sourcePortletIds = sourceLayoutTypePortlet.getPortletIds();
        for (String sourcePortletId : sourcePortletIds) {
            PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds(httpServletRequest, targetLayout, sourcePortletId);
            PortletPreferencesLocalServiceUtil.getPreferences(portletPreferencesIds);
            PortletPreferencesIds sourcePortletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds(httpServletRequest, sourceLayout, sourcePortletId);
            PortletPreferences sourcePreferences = PortletPreferencesLocalServiceUtil.getPreferences(sourcePortletPreferencesIds);
            PortletPreferencesLocalServiceUtil.updatePreferences(portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId(), sourcePreferences);
            PortletPreferences targetPreferences = PortletPreferencesLocalServiceUtil.getPreferences(themeDisplay.getCompanyId(), 0L, 3, targetLayout.getPlid(), sourcePortletId);
            sourcePreferences = PortletPreferencesLocalServiceUtil.getPreferences(themeDisplay.getCompanyId(), 0L, 3, sourceLayout.getPlid(), sourcePortletId);
            PortletPreferencesLocalServiceUtil.updatePreferences(0L, 3, targetLayout.getPlid(), sourcePortletId, sourcePreferences);
            SitesUtil.updateLayoutScopes(themeDisplay.getUserId(), sourceLayout, targetLayout, sourcePreferences, targetPreferences, sourcePortletId, themeDisplay.getLanguageId());
            Portlet sourcePortlet = PortletLocalServiceUtil.getPortletById(sourceLayout.getCompanyId(), sourcePortletId);
            PortletLayoutListener sourcePortletLayoutListener = sourcePortlet.getPortletLayoutListenerInstance();
            if (sourcePortletLayoutListener == null) continue;
            sourcePortletLayoutListener.onAddToLayout(sourcePortletId, targetLayout.getPlid());
        }
    }

    public static void copyPreferences(PortletRequest portletRequest, Layout targetLayout, Layout sourceLayout) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest(portletRequest);
        ActionUtil.copyPreferences(httpServletRequest, targetLayout, sourceLayout);
    }

    public static Group getGroup(HttpServletRequest httpServletRequest) throws Exception {
        String cmd = ParamUtil.getString(httpServletRequest, "cmd");
        long groupId = ParamUtil.getLong(httpServletRequest, "groupId");
        Group group = null;
        if (groupId > 0L) {
            group = GroupLocalServiceUtil.getGroup(groupId);
        } else if (!cmd.equals("add")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = themeDisplay.getSiteGroup();
        }
        httpServletRequest.setAttribute("GROUP", (Object)group);
        return group;
    }

    public static Group getGroup(PortletRequest portletRequest) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest(portletRequest);
        return ActionUtil.getGroup(httpServletRequest);
    }

    public static void removePortletIds(HttpServletRequest httpServletRequest, Layout layout) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        List<String> portletIds = layoutTypePortlet.getPortletIds();
        for (String portletId : portletIds) {
            layoutTypePortlet.removePortletId(themeDisplay.getUserId(), portletId);
        }
        LayoutServiceUtil.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
    }

    public static void removePortletIds(PortletRequest portletRequest, Layout layout) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest(portletRequest);
        ActionUtil.removePortletIds(httpServletRequest, layout);
    }
}

