/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rolesadmin.search;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.rolesadmin.search.RoleDisplayTerms;
import com.liferay.portlet.rolesadmin.search.RoleSearchTerms;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class RoleSearch
extends SearchContainer<Role> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-roles-were-found";
    public static List<String> headerNames = new ArrayList<String>(){
        {
            this.add("title");
            this.add("type");
            if (PropsValues.ROLES_ORGANIZATION_SUBTYPES.length > 0 || PropsValues.ROLES_REGULAR_SUBTYPES.length > 0 || PropsValues.ROLES_SITE_SUBTYPES.length > 0) {
                this.add("subtype");
            }
            this.add("description");
        }
    };
    public static Map<String, String> orderableHeaders = new HashMap<String, String>(){
        {
            this.put("description", "description");
            this.put("title", "title");
            this.put("type", "type");
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(RoleSearch.class);

    public RoleSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, new RoleDisplayTerms(portletRequest), new RoleSearchTerms(portletRequest), "cur", DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        RoleDisplayTerms displayTerms = (RoleDisplayTerms)this.getDisplayTerms();
        if (ParamUtil.getInteger(portletRequest, "type") == 0) {
            displayTerms.setType(1);
            RoleSearchTerms searchTerms = (RoleSearchTerms)this.getSearchTerms();
            searchTerms.setType(1);
        }
        iteratorURL.setParameter("description", displayTerms.getDescription());
        iteratorURL.setParameter("name", displayTerms.getName());
        iteratorURL.setParameter("type", String.valueOf(displayTerms.getType()));
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences(portletRequest);
            String portletId = PortletProviderUtil.getPortletId(Role.class.getName(), PortletProvider.Action.BROWSE);
            String orderByCol = ParamUtil.getString(portletRequest, "orderByCol");
            String orderByType = ParamUtil.getString(portletRequest, "orderByType");
            if (Validator.isNotNull(orderByCol) && Validator.isNotNull(orderByType)) {
                preferences.setValue(portletId, "roles-order-by-col", orderByCol);
                preferences.setValue(portletId, "roles-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue(portletId, "roles-order-by-col", "title");
                orderByType = preferences.getValue(portletId, "roles-order-by-type", "asc");
            }
            OrderByComparator<Role> orderByComparator = UsersAdminUtil.getRoleOrderByComparator(orderByCol, orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error("Unable to initialize role search", e);
        }
    }
}

