/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rolesadmin.search;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class GroupRoleChecker
extends EmptyOnClickRowChecker {
    private static final Log _log = LogFactoryUtil.getLog(GroupRoleChecker.class);
    private final Role _role;

    public GroupRoleChecker(RenderResponse renderResponse, Role role) {
        super((PortletResponse)renderResponse);
        this._role = role;
    }

    @Override
    public boolean isChecked(Object obj) {
        Group group = (Group)obj;
        try {
            return GroupLocalServiceUtil.hasRoleGroup(this._role.getRoleId(), group.getGroupId());
        }
        catch (Exception e) {
            _log.error(e, e);
            return false;
        }
    }

    @Override
    public boolean isDisabled(Object obj) {
        Group group = (Group)obj;
        return this.isChecked(group);
    }
}

