/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.ratings.model.impl.RatingsStatsImpl;
import com.liferay.portlet.ratings.model.impl.RatingsStatsModelImpl;
import com.liferay.ratings.kernel.exception.NoSuchStatsException;
import com.liferay.ratings.kernel.model.RatingsStats;
import com.liferay.ratings.kernel.service.persistence.RatingsStatsPersistence;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RatingsStatsPersistenceImpl
extends BasePersistenceImpl<RatingsStats>
implements RatingsStatsPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = RatingsStatsImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByC_C;
    private FinderPath _finderPathWithoutPaginationFindByC_C;
    private FinderPath _finderPathFetchByC_C;
    private FinderPath _finderPathCountByC_C;
    private FinderPath _finderPathWithPaginationCountByC_C;
    private static final String _FINDER_COLUMN_C_C_CLASSNAMEID_2 = "ratingsStats.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLASSPK_2 = "ratingsStats.classPK = ?";
    private static final String _FINDER_COLUMN_C_C_CLASSPK_7 = "ratingsStats.classPK IN (";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    private static final String _SQL_SELECT_RATINGSSTATS = "SELECT ratingsStats FROM RatingsStats ratingsStats";
    private static final String _SQL_SELECT_RATINGSSTATS_WHERE = "SELECT ratingsStats FROM RatingsStats ratingsStats WHERE ";
    private static final String _SQL_COUNT_RATINGSSTATS = "SELECT COUNT(ratingsStats) FROM RatingsStats ratingsStats";
    private static final String _SQL_COUNT_RATINGSSTATS_WHERE = "SELECT COUNT(ratingsStats) FROM RatingsStats ratingsStats WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ratingsStats.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No RatingsStats exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No RatingsStats exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(RatingsStatsPersistenceImpl.class);

    @Override
    public List<RatingsStats> findByC_C(long classNameId, long[] classPKs) {
        return this.findByC_C(classNameId, classPKs, -1, -1, null);
    }

    @Override
    public List<RatingsStats> findByC_C(long classNameId, long[] classPKs, int start, int end) {
        return this.findByC_C(classNameId, classPKs, start, end, null);
    }

    @Override
    public List<RatingsStats> findByC_C(long classNameId, long[] classPKs, int start, int end, OrderByComparator<RatingsStats> orderByComparator) {
        return this.findByC_C(classNameId, classPKs, start, end, orderByComparator, true);
    }

    @Override
    public List<RatingsStats> findByC_C(long classNameId, long[] classPKs, int start, int end, OrderByComparator<RatingsStats> orderByComparator, boolean retrieveFromCache) {
        if (classPKs == null) {
            classPKs = new long[]{};
        } else if (classPKs.length > 1) {
            classPKs = ArrayUtil.sortedUnique(classPKs);
        }
        if (classPKs.length == 1) {
            RatingsStats ratingsStats = this.fetchByC_C(classNameId, classPKs[0]);
            if (ratingsStats == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(ratingsStats);
        }
        boolean pagination = true;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderArgs = new Object[]{classNameId, StringUtil.merge(classPKs)};
        } else {
            finderArgs = new Object[]{classNameId, StringUtil.merge(classPKs), start, end, orderByComparator};
        }
        List<RatingsStats> list = null;
        if (retrieveFromCache && (list = (List<RatingsStats>)FinderCacheUtil.getResult(this._finderPathWithPaginationFindByC_C, finderArgs, this)) != null && !list.isEmpty()) {
            for (RatingsStats ratingsStats : list) {
                if (classNameId == ratingsStats.getClassNameId() && ArrayUtil.contains(classPKs, ratingsStats.getClassPK())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            try {
                if (start == -1 && end == -1 && this.databaseInMaxParameters > 0 && classPKs.length > this.databaseInMaxParameters) {
                    long[][] classPKsPages;
                    list = new ArrayList<RatingsStats>();
                    for (long[] classPKsPage : classPKsPages = (long[][])ArrayUtil.split(classPKs, this.databaseInMaxParameters)) {
                        list.addAll(this._findByC_C(classNameId, classPKsPage, start, end, orderByComparator, pagination));
                    }
                    Collections.sort(list, orderByComparator);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = this._findByC_C(classNameId, classPKs, start, end, orderByComparator, pagination);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(this._finderPathWithPaginationFindByC_C, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathWithPaginationFindByC_C, finderArgs);
                throw this.processException(e);
            }
        }
        return list;
    }

    private List<RatingsStats> _findByC_C(long classNameId, long[] classPKs, int start, int end, OrderByComparator<RatingsStats> orderByComparator, boolean pagination) {
        List<RatingsStats> list = null;
        StringBundler query = new StringBundler();
        query.append(_SQL_SELECT_RATINGSSTATS_WHERE);
        query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
        if (classPKs.length > 0) {
            query.append("(");
            query.append(_FINDER_COLUMN_C_C_CLASSPK_7);
            query.append(StringUtil.merge(classPKs));
            query.append(")");
            query.append(")");
        }
        query.setStringAt(RatingsStatsPersistenceImpl.removeConjunction(query.stringAt(query.index() - 1)), query.index() - 1);
        if (orderByComparator != null) {
            this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
        } else if (pagination) {
            query.append(" ORDER BY ratingsStats.statsId ASC");
        }
        String sql = query.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(classNameId);
            if (!pagination) {
                list = QueryUtil.list(q, this.getDialect(), start, end, false);
                Collections.sort(list);
                list = Collections.unmodifiableList(list);
            } else {
                list = QueryUtil.list(q, this.getDialect(), start, end);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        return list;
    }

    @Override
    public RatingsStats findByC_C(long classNameId, long classPK) throws NoSuchStatsException {
        RatingsStats ratingsStats = this.fetchByC_C(classNameId, classPK);
        if (ratingsStats == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("classNameId=");
            msg.append(classNameId);
            msg.append(", classPK=");
            msg.append(classPK);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchStatsException(msg.toString());
        }
        return ratingsStats;
    }

    @Override
    public RatingsStats fetchByC_C(long classNameId, long classPK) {
        return this.fetchByC_C(classNameId, classPK, true);
    }

    @Override
    public RatingsStats fetchByC_C(long classNameId, long classPK, boolean retrieveFromCache) {
        RatingsStats ratingsStats;
        Object[] finderArgs = new Object[]{classNameId, classPK};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByC_C, finderArgs, this);
        }
        if (result instanceof RatingsStats && (classNameId != (ratingsStats = (RatingsStats)result).getClassNameId() || classPK != ratingsStats.getClassPK())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_RATINGSSTATS_WHERE);
            query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            query.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(classNameId);
                qPos.add(classPK);
                List list = q.list();
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByC_C, finderArgs, list);
                } else {
                    RatingsStats ratingsStats2 = (RatingsStats)list.get(0);
                    result = ratingsStats2;
                    this.cacheResult(ratingsStats2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByC_C, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (RatingsStats)result;
    }

    @Override
    public RatingsStats removeByC_C(long classNameId, long classPK) throws NoSuchStatsException {
        RatingsStats ratingsStats = this.findByC_C(classNameId, classPK);
        return this.remove(ratingsStats);
    }

    @Override
    public int countByC_C(long classNameId, long classPK) {
        FinderPath finderPath = this._finderPathCountByC_C;
        Object[] finderArgs = new Object[]{classNameId, classPK};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_RATINGSSTATS_WHERE);
            query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            query.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(classNameId);
                qPos.add(classPK);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public int countByC_C(long classNameId, long[] classPKs) {
        if (classPKs == null) {
            classPKs = new long[]{};
        } else if (classPKs.length > 1) {
            classPKs = ArrayUtil.sortedUnique(classPKs);
        }
        Object[] finderArgs = new Object[]{classNameId, StringUtil.merge(classPKs)};
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathWithPaginationCountByC_C, finderArgs, this);
        if (count == null) {
            try {
                if (this.databaseInMaxParameters > 0 && classPKs.length > this.databaseInMaxParameters) {
                    long[][] classPKsPages;
                    count = 0L;
                    for (long[] classPKsPage : classPKsPages = (long[][])ArrayUtil.split(classPKs, this.databaseInMaxParameters)) {
                        count = count + Long.valueOf(this._countByC_C(classNameId, classPKsPage));
                    }
                } else {
                    count = this._countByC_C(classNameId, classPKs);
                }
                FinderCacheUtil.putResult(this._finderPathWithPaginationCountByC_C, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathWithPaginationCountByC_C, finderArgs);
                throw this.processException(e);
            }
        }
        return count.intValue();
    }

    private int _countByC_C(long classNameId, long[] classPKs) {
        Long count = null;
        StringBundler query = new StringBundler();
        query.append(_SQL_COUNT_RATINGSSTATS_WHERE);
        query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
        if (classPKs.length > 0) {
            query.append("(");
            query.append(_FINDER_COLUMN_C_C_CLASSPK_7);
            query.append(StringUtil.merge(classPKs));
            query.append(")");
            query.append(")");
        }
        query.setStringAt(RatingsStatsPersistenceImpl.removeConjunction(query.stringAt(query.index() - 1)), query.index() - 1);
        String sql = query.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(classNameId);
            count = (Long)q.uniqueResult();
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        return count.intValue();
    }

    public RatingsStatsPersistenceImpl() {
        this.setModelClass(RatingsStats.class);
        this.setModelImplClass(RatingsStatsImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED);
    }

    @Override
    public void cacheResult(RatingsStats ratingsStats) {
        EntityCacheUtil.putResult(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsImpl.class, Long.valueOf(ratingsStats.getPrimaryKey()), ratingsStats);
        FinderCacheUtil.putResult(this._finderPathFetchByC_C, new Object[]{ratingsStats.getClassNameId(), ratingsStats.getClassPK()}, ratingsStats);
        ratingsStats.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<RatingsStats> ratingsStatses) {
        for (RatingsStats ratingsStats : ratingsStatses) {
            if (EntityCacheUtil.getResult(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsImpl.class, Long.valueOf(ratingsStats.getPrimaryKey())) == null) {
                this.cacheResult(ratingsStats);
                continue;
            }
            ratingsStats.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(RatingsStatsImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(RatingsStats ratingsStats) {
        EntityCacheUtil.removeResult(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsImpl.class, Long.valueOf(ratingsStats.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((RatingsStatsModelImpl)((Object)ratingsStats), true);
    }

    @Override
    public void clearCache(List<RatingsStats> ratingsStatses) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (RatingsStats ratingsStats : ratingsStatses) {
            EntityCacheUtil.removeResult(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsImpl.class, Long.valueOf(ratingsStats.getPrimaryKey()));
            this.clearUniqueFindersCache((RatingsStatsModelImpl)((Object)ratingsStats), true);
        }
    }

    protected void cacheUniqueFindersCache(RatingsStatsModelImpl ratingsStatsModelImpl) {
        Object[] args = new Object[]{ratingsStatsModelImpl.getClassNameId(), ratingsStatsModelImpl.getClassPK()};
        FinderCacheUtil.putResult(this._finderPathCountByC_C, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByC_C, args, ratingsStatsModelImpl, false);
    }

    protected void clearUniqueFindersCache(RatingsStatsModelImpl ratingsStatsModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{ratingsStatsModelImpl.getClassNameId(), ratingsStatsModelImpl.getClassPK()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_C, args);
        }
        if ((ratingsStatsModelImpl.getColumnBitmask() & this._finderPathFetchByC_C.getColumnBitmask()) != 0L) {
            args = new Object[]{ratingsStatsModelImpl.getOriginalClassNameId(), ratingsStatsModelImpl.getOriginalClassPK()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_C, args);
        }
    }

    @Override
    public RatingsStats create(long statsId) {
        RatingsStatsImpl ratingsStats = new RatingsStatsImpl();
        ratingsStats.setNew(true);
        ratingsStats.setPrimaryKey(statsId);
        ratingsStats.setCompanyId(this.companyProvider.getCompanyId());
        return ratingsStats;
    }

    @Override
    public RatingsStats remove(long statsId) throws NoSuchStatsException {
        return this.remove(Long.valueOf(statsId));
    }

    @Override
    public RatingsStats remove(Serializable primaryKey) throws NoSuchStatsException {
        Session session = null;
        try {
            session = this.openSession();
            RatingsStats ratingsStats = (RatingsStats)session.get(RatingsStatsImpl.class, primaryKey);
            if (ratingsStats == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchStatsException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            RatingsStats ratingsStats2 = this.remove(ratingsStats);
            return ratingsStats2;
        }
        catch (NoSuchStatsException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected RatingsStats removeImpl(RatingsStats ratingsStats) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(ratingsStats)) {
                ratingsStats = (RatingsStats)session.get(RatingsStatsImpl.class, ratingsStats.getPrimaryKeyObj());
            }
            if (ratingsStats != null) {
                session.delete(ratingsStats);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (ratingsStats != null) {
            this.clearCache(ratingsStats);
        }
        return ratingsStats;
    }

    @Override
    public RatingsStats updateImpl(RatingsStats ratingsStats) {
        boolean isNew = ratingsStats.isNew();
        if (!(ratingsStats instanceof RatingsStatsModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ratingsStats.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(ratingsStats);
                throw new IllegalArgumentException("Implement ModelWrapper in ratingsStats proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom RatingsStats implementation " + ratingsStats.getClass());
        }
        RatingsStatsModelImpl ratingsStatsModelImpl = (RatingsStatsModelImpl)((Object)ratingsStats);
        Session session = null;
        try {
            session = this.openSession();
            if (ratingsStats.isNew()) {
                session.save(ratingsStats);
                ratingsStats.setNew(false);
            } else {
                ratingsStats = (RatingsStats)session.merge(ratingsStats);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!RatingsStatsModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{ratingsStatsModelImpl.getClassNameId(), ratingsStatsModelImpl.getClassPK()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else if ((ratingsStatsModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_C.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{ratingsStatsModelImpl.getOriginalClassNameId(), ratingsStatsModelImpl.getOriginalClassPK()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C, args);
            args = new Object[]{ratingsStatsModelImpl.getClassNameId(), ratingsStatsModelImpl.getClassPK()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C, args);
        }
        EntityCacheUtil.putResult(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsImpl.class, Long.valueOf(ratingsStats.getPrimaryKey()), ratingsStats, false);
        this.clearUniqueFindersCache(ratingsStatsModelImpl, false);
        this.cacheUniqueFindersCache(ratingsStatsModelImpl);
        ratingsStats.resetOriginalValues();
        return ratingsStats;
    }

    @Override
    public RatingsStats findByPrimaryKey(Serializable primaryKey) throws NoSuchStatsException {
        RatingsStats ratingsStats = (RatingsStats)this.fetchByPrimaryKey(primaryKey);
        if (ratingsStats == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchStatsException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ratingsStats;
    }

    @Override
    public RatingsStats findByPrimaryKey(long statsId) throws NoSuchStatsException {
        return this.findByPrimaryKey(Long.valueOf(statsId));
    }

    @Override
    public RatingsStats fetchByPrimaryKey(long statsId) {
        return (RatingsStats)this.fetchByPrimaryKey(Long.valueOf(statsId));
    }

    @Override
    public List<RatingsStats> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<RatingsStats> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<RatingsStats> findAll(int start, int end, OrderByComparator<RatingsStats> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<RatingsStats> findAll(int start, int end, OrderByComparator<RatingsStats> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<RatingsStats> list = null;
        if (retrieveFromCache) {
            list = (List<RatingsStats>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_RATINGSSTATS);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_RATINGSSTATS;
                if (pagination) {
                    sql = sql.concat(" ORDER BY ratingsStats.statsId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (RatingsStats ratingsStats : this.findAll()) {
            this.remove(ratingsStats);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_RATINGSSTATS);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "statsId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_RATINGSSTATS;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return RatingsStatsModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsModelImpl.FINDER_CACHE_ENABLED, RatingsStatsImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsModelImpl.FINDER_CACHE_ENABLED, RatingsStatsImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByC_C = new FinderPath(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsModelImpl.FINDER_CACHE_ENABLED, RatingsStatsImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_C = new FinderPath(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsModelImpl.FINDER_CACHE_ENABLED, RatingsStatsImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
        this._finderPathFetchByC_C = new FinderPath(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsModelImpl.FINDER_CACHE_ENABLED, RatingsStatsImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_C", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
        this._finderPathCountByC_C = new FinderPath(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationCountByC_C = new FinderPath(RatingsStatsModelImpl.ENTITY_CACHE_ENABLED, RatingsStatsModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(RatingsStatsImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

