/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portlet.ratings.service.base.RatingsEntryLocalServiceBaseImpl;
import com.liferay.ratings.kernel.exception.EntryScoreException;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.model.RatingsStats;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RatingsEntryLocalServiceImpl
extends RatingsEntryLocalServiceBaseImpl {
    @Override
    public void deleteEntry(long userId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        RatingsEntry entry = this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
        this.ratingsEntryLocalService.deleteEntry(entry, userId, className, classPK);
    }

    @Override
    @SystemEvent(type=1)
    public void deleteEntry(RatingsEntry entry, long userId, String className, long classPK) throws PortalException {
        if (entry == null) {
            return;
        }
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.ratingsEntryPersistence.removeByU_C_C(userId, classNameId, classPK);
        RatingsStats stats = this.ratingsStatsLocalService.getStats(className, classPK);
        int totalEntries = stats.getTotalEntries() - 1;
        if (totalEntries == 0) {
            this.ratingsStatsPersistence.remove(stats);
        } else {
            double oldScore = entry.getScore();
            double totalScore = stats.getTotalScore() - oldScore;
            double averageScore = 0.0;
            if (totalEntries > 0) {
                averageScore = totalScore / (double)totalEntries;
            }
            stats.setTotalEntries(totalEntries);
            stats.setTotalScore(totalScore);
            stats.setAverageScore(averageScore);
            this.ratingsStatsPersistence.update(stats);
        }
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(className, classPK);
        if (assetEntry != null) {
            JSONObject extraDataJSONObject = JSONUtil.put("title", (Object)assetEntry.getTitle());
            SocialActivityManagerUtil.addActivity(userId, assetEntry, 10011, extraDataJSONObject.toString(), 0L);
        }
    }

    @Override
    public RatingsEntry fetchEntry(long userId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
    }

    @Override
    @Deprecated
    public List<RatingsEntry> getEntries(long userId, String className, List<Long> classPKs) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryFinder.findByU_C_C(userId, classNameId, classPKs);
    }

    @Override
    public Map<Long, RatingsEntry> getEntries(long userId, String className, long[] classPKs) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        HashMap<Long, RatingsEntry> ratingsEntries = new HashMap<Long, RatingsEntry>();
        for (RatingsEntry entry : this.ratingsEntryPersistence.findByU_C_C(userId, classNameId, classPKs)) {
            ratingsEntries.put(entry.getClassPK(), entry);
        }
        return ratingsEntries;
    }

    @Override
    public List<RatingsEntry> getEntries(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.findByC_C(classNameId, classPK);
    }

    @Override
    public List<RatingsEntry> getEntries(String className, long classPK, double score) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.findByC_C_S(classNameId, classPK, score);
    }

    @Override
    public int getEntriesCount(String className, long classPK, double score) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.countByC_C_S(classNameId, classPK, score);
    }

    @Override
    public RatingsEntry getEntry(long userId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ratingsEntryPersistence.findByU_C_C(userId, classNameId, classPK);
    }

    @Override
    public RatingsEntry updateEntry(long userId, String className, long classPK, double score, ServiceContext serviceContext) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.validate(score);
        RatingsEntry entry = this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
        if (entry != null) {
            double oldScore = entry.getScore();
            entry.setScore(score);
            this.ratingsEntryPersistence.update(entry);
            RatingsStats stats = this.ratingsStatsPersistence.fetchByC_C(classNameId, classPK);
            if (stats == null) {
                stats = this.ratingsStatsLocalService.addStats(classNameId, classPK);
            }
            stats.setTotalScore(stats.getTotalScore() - oldScore + score);
            stats.setAverageScore(stats.getTotalScore() / (double)stats.getTotalEntries());
            this.ratingsStatsPersistence.update(stats);
        } else {
            User user = this.userPersistence.findByPrimaryKey(userId);
            long entryId = this.counterLocalService.increment();
            entry = this.ratingsEntryPersistence.create(entryId);
            entry.setCompanyId(user.getCompanyId());
            entry.setUserId(user.getUserId());
            entry.setUserName(user.getFullName());
            entry.setClassNameId(classNameId);
            entry.setClassPK(classPK);
            entry.setScore(score);
            this.ratingsEntryPersistence.update(entry);
            RatingsStats stats = this.ratingsStatsPersistence.fetchByC_C(classNameId, classPK);
            if (stats == null) {
                stats = this.ratingsStatsLocalService.addStats(classNameId, classPK);
            }
            stats.setTotalEntries(stats.getTotalEntries() + 1);
            stats.setTotalScore(stats.getTotalScore() + score);
            stats.setAverageScore(stats.getTotalScore() / (double)stats.getTotalEntries());
            this.ratingsStatsPersistence.update(stats);
        }
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(className, classPK);
        if (assetEntry != null) {
            JSONObject extraDataJSONObject = JSONUtil.put("title", (Object)assetEntry.getTitle());
            SocialActivityManagerUtil.addActivity(userId, assetEntry, 10004, extraDataJSONObject.toString(), 0L);
        }
        return entry;
    }

    protected void validate(double score) throws PortalException {
        if (score > 1.0 || score < 0.0) {
            throw new EntryScoreException("Score " + score + " is not a value between 0 and 1");
        }
    }
}

