/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.notifications.test;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserNotificationDelivery;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.service.UserNotificationDeliveryLocalServiceUtil;
import com.liferay.portal.kernel.service.UserNotificationEventLocalServiceUtil;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.test.mail.MailServiceTestUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseUserNotificationTestCase {
    @DeleteAfterTestRun
    protected Group group;
    @DeleteAfterTestRun
    protected User user;
    protected List<UserNotificationDelivery> userNotificationDeliveries = new ArrayList<UserNotificationDelivery>();

    @Before
    public void setUp() throws Exception {
        this.user = UserTestUtil.addOmniAdminUser();
        this.group = GroupTestUtil.addGroup();
        this.addContainerModel();
        this.userNotificationDeliveries = this.getUserNotificationDeliveries(this.user.getUserId());
    }

    @After
    public void tearDown() throws Exception {
        this.deleteUserNotificationEvents(this.user.getUserId());
        this.deleteUserNotificationDeliveries();
    }

    @Test
    public void testAddUserNotification() throws Exception {
        this.subscribeToContainer();
        BaseModel<?> baseModel = this.addBaseModel();
        Assert.assertEquals(1L, MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId(), (Long)baseModel.getPrimaryKeyObj());
        Assert.assertEquals(userNotificationEventsJSONObjects.toString(), 1L, userNotificationEventsJSONObjects.size());
        for (JSONObject userNotificationEventsJSONObject : userNotificationEventsJSONObjects) {
            Assert.assertTrue(this.isValidUserNotificationEventObject((Long)baseModel.getPrimaryKeyObj(), userNotificationEventsJSONObject));
            Assert.assertEquals(0L, userNotificationEventsJSONObject.getInt("notificationType"));
        }
    }

    @Test
    public void testAddUserNotificationWhenEmailNotificationsDisabled() throws Exception {
        this.subscribeToContainer();
        this.updateUserNotificationDelivery(0, 10000, false);
        BaseModel<?> baseModel = this.addBaseModel();
        Assert.assertEquals(0L, MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId(), (Long)baseModel.getPrimaryKeyObj());
        Assert.assertEquals(userNotificationEventsJSONObjects.toString(), 1L, userNotificationEventsJSONObjects.size());
        for (JSONObject userNotificationEventsJSONObject : userNotificationEventsJSONObjects) {
            Assert.assertTrue(this.isValidUserNotificationEventObject((Long)baseModel.getPrimaryKeyObj(), userNotificationEventsJSONObject));
            Assert.assertEquals(0L, userNotificationEventsJSONObject.getInt("notificationType"));
        }
    }

    @Test
    public void testAddUserNotificationWhenNotificationsDisabled() throws Exception {
        this.subscribeToContainer();
        this.updateUserNotificationsDelivery(false);
        BaseModel<?> baseModel = this.addBaseModel();
        Assert.assertEquals(0L, MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId(), (Long)baseModel.getPrimaryKeyObj());
        Assert.assertEquals(userNotificationEventsJSONObjects.toString(), 0L, userNotificationEventsJSONObjects.size());
    }

    @Test
    public void testAddUserNotificationWhenWebsiteNotificationsDisabled() throws Exception {
        this.subscribeToContainer();
        this.updateUserNotificationDelivery(0, 10002, false);
        BaseModel<?> baseModel = this.addBaseModel();
        Assert.assertEquals(1L, MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId(), (Long)baseModel.getPrimaryKeyObj());
        Assert.assertEquals(userNotificationEventsJSONObjects.toString(), 0L, userNotificationEventsJSONObjects.size());
    }

    @Test
    public void testUpdateUserNotification() throws Exception {
        BaseModel<?> baseModel = this.addBaseModel();
        this.subscribeToContainer();
        BaseModel<?> updatedBasemodel = this.updateBaseModel(baseModel);
        Assert.assertEquals(1L, MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId(), (Long)updatedBasemodel.getPrimaryKeyObj());
        Assert.assertEquals(userNotificationEventsJSONObjects.toString(), 1L, userNotificationEventsJSONObjects.size());
        int notificationType = -1;
        for (JSONObject userNotificationEventsJSONObject : userNotificationEventsJSONObjects) {
            Assert.assertTrue(this.isValidUserNotificationEventObject((Long)updatedBasemodel.getPrimaryKeyObj(), userNotificationEventsJSONObject));
            notificationType = userNotificationEventsJSONObject.getInt("notificationType");
            Assert.assertEquals(notificationType, 1L);
        }
    }

    @Test
    public void testUpdateUserNotificationWhenEmailNotificationsDisabled() throws Exception {
        this.updateUserNotificationDelivery(0, 10000, false);
        this.updateUserNotificationDelivery(1, 10000, false);
        BaseModel<?> baseModel = this.addBaseModel();
        this.subscribeToContainer();
        BaseModel<?> updatedBasemodel = this.updateBaseModel(baseModel);
        Assert.assertEquals(0L, MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId(), (Long)updatedBasemodel.getPrimaryKeyObj());
        Assert.assertEquals(userNotificationEventsJSONObjects.toString(), 1L, userNotificationEventsJSONObjects.size());
        int notificationType = -1;
        for (JSONObject userNotificationEventsJSONObject : userNotificationEventsJSONObjects) {
            Assert.assertTrue(this.isValidUserNotificationEventObject((Long)updatedBasemodel.getPrimaryKeyObj(), userNotificationEventsJSONObject));
            notificationType = userNotificationEventsJSONObject.getInt("notificationType");
            Assert.assertEquals(notificationType, 1L);
        }
    }

    @Test
    public void testUpdateUserNotificationWhenNotificationsDisabled() throws Exception {
        this.updateUserNotificationsDelivery(false);
        BaseModel<?> baseModel = this.addBaseModel();
        this.subscribeToContainer();
        BaseModel<?> updatedBasemodel = this.updateBaseModel(baseModel);
        Assert.assertEquals(0L, MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId(), (Long)updatedBasemodel.getPrimaryKeyObj());
        Assert.assertEquals(userNotificationEventsJSONObjects.toString(), 0L, userNotificationEventsJSONObjects.size());
    }

    @Test
    public void testUpdateUserNotificationWhenWebsiteNotificationsDisabled() throws Exception {
        this.updateUserNotificationDelivery(0, 10002, false);
        this.updateUserNotificationDelivery(1, 10002, false);
        BaseModel<?> baseModel = this.addBaseModel();
        this.subscribeToContainer();
        BaseModel<?> updatedBasemodel = this.updateBaseModel(baseModel);
        Assert.assertEquals(1L, MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId(), (Long)updatedBasemodel.getPrimaryKeyObj());
        Assert.assertEquals(userNotificationEventsJSONObjects.toString(), 0L, userNotificationEventsJSONObjects.size());
    }

    protected abstract BaseModel<?> addBaseModel() throws Exception;

    protected void addContainerModel() throws Exception {
    }

    protected void deleteUserNotificationDeliveries() throws Exception {
        UserNotificationDeliveryLocalServiceUtil.deleteUserNotificationDeliveries(this.user.getUserId());
    }

    protected void deleteUserNotificationEvents(long userId) throws Exception {
        List<UserNotificationEvent> userNotificationEvents = UserNotificationEventLocalServiceUtil.getUserNotificationEvents(userId);
        for (UserNotificationEvent userNotificationEvent : userNotificationEvents) {
            UserNotificationEventLocalServiceUtil.deleteUserNotificationEvent(userNotificationEvent);
        }
    }

    protected abstract String getPortletId();

    protected List<UserNotificationDelivery> getUserNotificationDeliveries(long userId) throws Exception {
        ArrayList<UserNotificationDelivery> userNotificationDeliveries = new ArrayList<UserNotificationDelivery>();
        userNotificationDeliveries.add(UserNotificationDeliveryLocalServiceUtil.getUserNotificationDelivery(userId, this.getPortletId(), 0L, 0, 10000, true));
        userNotificationDeliveries.add(UserNotificationDeliveryLocalServiceUtil.getUserNotificationDelivery(userId, this.getPortletId(), 0L, 0, 10002, true));
        userNotificationDeliveries.add(UserNotificationDeliveryLocalServiceUtil.getUserNotificationDelivery(userId, this.getPortletId(), 0L, 1, 10000, true));
        userNotificationDeliveries.add(UserNotificationDeliveryLocalServiceUtil.getUserNotificationDelivery(userId, this.getPortletId(), 0L, 1, 10002, true));
        return userNotificationDeliveries;
    }

    protected List<JSONObject> getUserNotificationEventsJSONObjects(long userId, long primaryKey) throws Exception {
        List<UserNotificationEvent> userNotificationEvents = UserNotificationEventLocalServiceUtil.getUserNotificationEvents(userId);
        ArrayList<JSONObject> userNotificationEventJSONObjects = new ArrayList<JSONObject>(userNotificationEvents.size());
        for (UserNotificationEvent userNotificationEvent : userNotificationEvents) {
            JSONObject userNotificationEventJSONObject = JSONFactoryUtil.createJSONObject(userNotificationEvent.getPayload());
            userNotificationEventJSONObjects.add(userNotificationEventJSONObject);
        }
        return userNotificationEventJSONObjects;
    }

    protected boolean isValidUserNotificationEventObject(long primaryKey, JSONObject userNotificationEventJSONObject) throws Exception {
        long classPK = userNotificationEventJSONObject.getLong("classPK");
        return classPK == primaryKey;
    }

    protected abstract void subscribeToContainer() throws Exception;

    protected abstract BaseModel<?> updateBaseModel(BaseModel<?> var1) throws Exception;

    protected void updateUserNotificationDelivery(int notificationType, int deliveryType, boolean deliver) throws Exception {
        boolean exists = false;
        for (UserNotificationDelivery userNotificationDelivery : this.userNotificationDeliveries) {
            if (userNotificationDelivery.getNotificationType() != notificationType || userNotificationDelivery.getDeliveryType() != deliveryType) continue;
            UserNotificationDeliveryLocalServiceUtil.updateUserNotificationDelivery(userNotificationDelivery.getUserNotificationDeliveryId(), deliver);
            exists = true;
            break;
        }
        Assert.assertTrue("User notification does not exist", exists);
    }

    protected void updateUserNotificationsDelivery(boolean deliver) throws Exception {
        for (UserNotificationDelivery userNotificationDelivery : this.userNotificationDeliveries) {
            UserNotificationDeliveryLocalServiceUtil.updateUserNotificationDelivery(userNotificationDelivery.getUserNotificationDeliveryId(), deliver);
        }
    }
}

