/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayResourceRequest;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.AsyncPortletServletRequest;
import com.liferay.portlet.internal.ClientDataRequestImpl;
import com.liferay.portlet.internal.PortletAsyncContextImpl;
import com.liferay.portlet.internal.RenderParametersImpl;
import com.liferay.portlet.internal.ResourceParametersImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletAsyncContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceParameters;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceRequestImpl
extends ClientDataRequestImpl
implements LiferayResourceRequest {
    private String _cacheablity;
    private PortletAsyncContextImpl _portletAsyncContextImpl;
    private PortletConfig _portletConfig;
    private String _resourceID;
    private ResourceParameters _resourceParameters;
    private ResourceResponse _resourceResponse;

    @Override
    public void defineObjects(PortletConfig portletConfig, PortletResponse portletResponse) {
        super.defineObjects(portletConfig, portletResponse);
        this._resourceResponse = (ResourceResponse)portletResponse;
    }

    public String getCacheability() {
        return this._cacheablity;
    }

    public DispatcherType getDispatcherType() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay.isAsync()) {
            return DispatcherType.ASYNC;
        }
        return DispatcherType.REQUEST;
    }

    @Override
    public String getETag() {
        return null;
    }

    @Override
    public String getLifecycle() {
        return "RESOURCE_PHASE";
    }

    public PortletAsyncContext getPortletAsyncContext() {
        if (!this.isAsyncSupported() || !this.isAsyncStarted() && this._portletAsyncContextImpl == null) {
            throw new IllegalStateException();
        }
        return this._portletAsyncContextImpl;
    }

    @Deprecated
    public Map<String, String[]> getPrivateRenderParameterMap() {
        HashMap<String, String[]> privateRenderParameters = new HashMap<String, String[]>();
        RenderParametersImpl liferayRenderParameters = (RenderParametersImpl)this.getRenderParameters();
        Map<String, String[]> liferayRenderParametersMap = liferayRenderParameters.getParameterMap();
        for (Map.Entry<String, String[]> entry : liferayRenderParametersMap.entrySet()) {
            String renderParameterName = entry.getKey();
            if (liferayRenderParameters.isPublic(renderParameterName)) continue;
            privateRenderParameters.put(renderParameterName, entry.getValue());
        }
        if (privateRenderParameters.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(privateRenderParameters);
    }

    public String getResourceID() {
        return this._resourceID;
    }

    public ResourceParameters getResourceParameters() {
        if (this.getPortletSpecMajorVersion() < 3) {
            throw new UnsupportedOperationException("Requires 3.0 opt-in");
        }
        return this._resourceParameters;
    }

    @Override
    public void init(HttpServletRequest httpServletRequest, Portlet portlet, InvokerPortlet invokerPortlet, PortletContext portletContext, WindowState windowState, PortletMode portletMode, PortletPreferences preferences, long plid) {
        if (Validator.isNull(windowState.toString())) {
            windowState = WindowState.NORMAL;
        }
        if (Validator.isNull(portletMode.toString())) {
            portletMode = PortletMode.VIEW;
        }
        super.init(httpServletRequest, portlet, invokerPortlet, portletContext, windowState, portletMode, preferences, plid);
        this._cacheablity = ParamUtil.getString(httpServletRequest, "p_p_cacheability", "cacheLevelPage");
        this._portletConfig = invokerPortlet.getPortletConfig();
        this._resourceID = httpServletRequest.getParameter("p_p_resource_id");
        if (!PortalUtil.isValidResourceId(this._resourceID)) {
            this._resourceID = "";
        }
        if (this.getPortletSpecMajorVersion() >= 3) {
            String portletNamespace = PortalUtil.getPortletNamespace(this.getPortletName());
            this._resourceParameters = new ResourceParametersImpl(this.getPortletParameterMap(httpServletRequest, portletNamespace), portletNamespace);
        }
    }

    public boolean isAsyncStarted() {
        HttpServletRequest httpServletRequest = this._getHttpServletRequest(this);
        return httpServletRequest.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        HttpServletRequest httpServletRequest = this._getHttpServletRequest(this);
        if (!httpServletRequest.isAsyncSupported()) {
            return false;
        }
        Portlet portlet = this.getPortlet();
        return portlet.isAsyncSupported();
    }

    public PortletAsyncContext startPortletAsync() throws IllegalStateException {
        return this.startPortletAsync(this, this._resourceResponse);
    }

    public PortletAsyncContext startPortletAsync(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IllegalStateException {
        if (!this.isAsyncSupported() || this.isAsyncStarted()) {
            throw new IllegalStateException();
        }
        Object httpServletRequest = this._getHttpServletRequest(resourceRequest);
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.getAttribute("com.liferay.portal.kernel.servlet.PortletServletResponse");
        if (httpServletResponse == null) {
            LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)resourceResponse);
            httpServletResponse = liferayPortletResponse.getHttpServletResponse();
        }
        if (this._portletAsyncContextImpl == null) {
            this._portletAsyncContextImpl = new PortletAsyncContextImpl();
            httpServletRequest = new AsyncPortletServletRequest((HttpServletRequest)httpServletRequest);
        }
        AsyncContext asyncContext = httpServletRequest.startAsync((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        boolean hasOriginalRequestAndResponse = false;
        if (resourceRequest == this && resourceResponse == this._resourceResponse) {
            hasOriginalRequestAndResponse = true;
        }
        this._portletAsyncContextImpl.initialize(resourceRequest, resourceResponse, this._portletConfig, asyncContext, hasOriginalRequestAndResponse);
        if (!hasOriginalRequestAndResponse) {
            this.setAttribute("javax.portlet.request", resourceRequest);
            this.setAttribute("javax.portlet.response", resourceResponse);
        }
        return this._portletAsyncContextImpl;
    }

    private HttpServletRequest _getHttpServletRequest(ResourceRequest resourceRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.getAttribute("com.liferay.portal.kernel.servlet.PortletServletRequest");
        if (httpServletRequest != null) {
            return httpServletRequest;
        }
        if (resourceRequest == this) {
            return this.getHttpServletRequest();
        }
        LiferayPortletRequest liferayPortletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)resourceRequest);
        return liferayPortletRequest.getHttpServletRequest();
    }
}

