/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.servlet.TransferHeadersHelperUtil;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.internal.LiferayPortletURLPrivilegedAction;
import com.liferay.portlet.internal.PortletRequestImpl;
import com.liferay.portlet.internal.PortletURLImpl;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderURL;
import javax.portlet.ResourceURL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PortletResponseImpl
implements LiferayPortletResponse {
    protected String portletName;
    protected PortletRequestImpl portletRequestImpl;
    protected HttpServletResponse response;
    private static final Log _log = LogFactoryUtil.getLog(PortletResponseImpl.class);
    private long _companyId;
    private final Map<String, Constructor<? extends PortletURLImpl>> _constructors = new ConcurrentHashMap<String, Constructor<? extends PortletURLImpl>>();
    private Document _document;
    private final Map<String, Object[]> _headers = new LinkedHashMap<String, Object[]>();
    private final Map<String, List<Element>> _markupHeadElements = new LinkedHashMap<String, List<Element>>();
    private String _namespace;
    private long _plid;
    private Portlet _portlet;
    private PortletPreferences _portletSetup;
    private URLEncoder _urlEncoder;

    @Override
    public void addDateHeader(String name, long date) {
        if (Validator.isNull(name)) {
            throw new IllegalArgumentException();
        }
        Long[] values = (Long[])this._headers.get(name);
        if (values == null) {
            this.setDateHeader(name, date);
        } else {
            values = ArrayUtil.append(values, Long.valueOf(date));
            this._headers.put(name, values);
        }
    }

    @Override
    public void addHeader(String name, String value) {
        if (Validator.isNull(name)) {
            throw new IllegalArgumentException();
        }
        String[] values = (String[])this._headers.get(name);
        if (values == null) {
            this.setHeader(name, value);
        } else {
            values = ArrayUtil.append(values, value);
            this._headers.put(name, values);
        }
    }

    @Override
    public void addIntHeader(String name, int value) {
        if (Validator.isNull(name)) {
            throw new IllegalArgumentException();
        }
        Integer[] values = (Integer[])this._headers.get(name);
        if (values == null) {
            this.setIntHeader(name, value);
        } else {
            values = ArrayUtil.append(values, Integer.valueOf(value));
            this._headers.put(name, values);
        }
    }

    public void addProperty(Cookie cookie) {
        if (cookie == null) {
            throw new IllegalArgumentException();
        }
        Cookie[] cookies = (Cookie[])this._headers.get("cookies");
        if (cookies == null) {
            this._headers.put("cookies", new Cookie[]{cookie});
        } else {
            cookies = ArrayUtil.append(cookies, cookie);
            this._headers.put("cookies", cookies);
        }
    }

    public void addProperty(String key, Element element) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.equalsIgnoreCase(key, "javax.portlet.markup.head.element")) {
            List<Element> values;
            if (element != null && StringUtil.equalsIgnoreCase(element.getNodeName(), "script") && !element.hasChildNodes()) {
                element = (Element)element.cloneNode(true);
                element.appendChild(this._document.createTextNode(" "));
            }
            if ((values = this._markupHeadElements.get(key)) == null) {
                if (element != null) {
                    values = new ArrayList<Element>();
                    values.add(element);
                    this._markupHeadElements.put(key, values);
                }
            } else if (element == null) {
                this._markupHeadElements.remove(key);
            } else {
                values.add(element);
            }
        }
    }

    public void addProperty(String key, String value) {
        if (Validator.isNull(key)) {
            throw new IllegalArgumentException();
        }
        this.addHeader(key, value);
    }

    @Override
    public <T extends PortletURL & ActionURL> T createActionURL() {
        Portlet portlet = this.getPortlet();
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp.getSpecMajorVersion() == 3) {
            return (T)this.createActionURL(this.portletName, MimeResponse.Copy.PUBLIC);
        }
        return (T)this.createActionURL(this.portletName);
    }

    @Override
    public ActionURL createActionURL(MimeResponse.Copy copy) {
        return (ActionURL)this.createActionURL(this.portletName, copy);
    }

    @Override
    public LiferayPortletURL createActionURL(String portletName) {
        return this.createLiferayPortletURL(portletName, "ACTION_PHASE");
    }

    @Override
    public LiferayPortletURL createActionURL(String portletName, MimeResponse.Copy copy) {
        return this.createLiferayPortletURL(portletName, "ACTION_PHASE", copy);
    }

    public Element createElement(String tagName) throws DOMException {
        if (this._document == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = SecureXMLFactoryProviderUtil.newDocumentBuilderFactory();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                this._document = documentBuilder.newDocument();
            }
            catch (ParserConfigurationException pce) {
                throw new DOMException(11, pce.getMessage());
            }
        }
        return this._document.createElement(tagName);
    }

    @Override
    public LiferayPortletURL createLiferayPortletURL(long plid, String portletName, String lifecycle) {
        return this.createLiferayPortletURL(plid, portletName, lifecycle, true);
    }

    @Override
    public LiferayPortletURL createLiferayPortletURL(long plid, String portletName, String lifecycle, boolean includeLinkToLayoutUuid) {
        return this.createLiferayPortletURL(plid, portletName, lifecycle, null, includeLinkToLayoutUuid);
    }

    @Override
    public LiferayPortletURL createLiferayPortletURL(long plid, String portletName, String lifecycle, MimeResponse.Copy copy) {
        return this.createLiferayPortletURL(plid, portletName, lifecycle, copy, true);
    }

    @Override
    public LiferayPortletURL createLiferayPortletURL(long plid, String portletName, String lifecycle, MimeResponse.Copy copy, boolean includeLinkToLayoutUuid) {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.portletRequestImpl.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = this.getLayout(this.portletRequestImpl, themeDisplay);
        if (this._portletSetup == null) {
            this._portletSetup = this.getPortletSetup(themeDisplay, layout, portletName);
        }
        LiferayPortletURLPrivilegedAction liferayPortletURLPrivilegedAction = new LiferayPortletURLPrivilegedAction(plid, portletName, lifecycle, copy, includeLinkToLayoutUuid, layout, this.getPortlet(), this._portletSetup, this.portletRequestImpl, this, this._plid, this._constructors);
        return liferayPortletURLPrivilegedAction.run();
    }

    @Override
    public LiferayPortletURL createLiferayPortletURL(String lifecycle) {
        return this.createLiferayPortletURL(this.portletName, lifecycle);
    }

    @Override
    public LiferayPortletURL createLiferayPortletURL(String portletName, String lifecycle) {
        return this.createLiferayPortletURL(this._plid, portletName, lifecycle);
    }

    @Override
    public LiferayPortletURL createLiferayPortletURL(String portletName, String lifecycle, MimeResponse.Copy copy) {
        return this.createLiferayPortletURL(this._plid, portletName, lifecycle, copy);
    }

    @Override
    public <T extends PortletURL & RenderURL> T createRenderURL() {
        Portlet portlet = this.getPortlet();
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp.getSpecMajorVersion() == 3) {
            return (T)this.createRenderURL(this.portletName, MimeResponse.Copy.PUBLIC);
        }
        return (T)this.createRenderURL(this.portletName);
    }

    @Override
    public RenderURL createRenderURL(MimeResponse.Copy copy) {
        return (RenderURL)this.createRenderURL(this.portletName, copy);
    }

    @Override
    public LiferayPortletURL createRenderURL(String portletName) {
        return this.createLiferayPortletURL(portletName, "RENDER_PHASE");
    }

    @Override
    public LiferayPortletURL createRenderURL(String portletName, MimeResponse.Copy copy) {
        return this.createLiferayPortletURL(portletName, "RENDER_PHASE", copy);
    }

    @Override
    public ResourceURL createResourceURL() {
        return this.createResourceURL(this.portletName);
    }

    @Override
    public LiferayPortletURL createResourceURL(String portletName) {
        return this.createLiferayPortletURL(this._plid, portletName, "RESOURCE_PHASE", MimeResponse.Copy.ALL, true);
    }

    public String encodeURL(String path) {
        if (path == null || !path.startsWith("#") && !path.startsWith("/") && !path.contains("://")) {
            throw new IllegalArgumentException("URL path must start with a '/' or include '://'");
        }
        if (this._urlEncoder != null) {
            return this._urlEncoder.encodeURL(this.response, path);
        }
        return path;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.portletRequestImpl.getHttpServletRequest();
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    @Override
    public abstract String getLifecycle();

    public String getNamespace() {
        if (this._namespace == null) {
            this._namespace = PortalUtil.getPortletNamespace(this.portletName);
        }
        return this._namespace;
    }

    public long getPlid() {
        return this._plid;
    }

    @Override
    public Portlet getPortlet() {
        return this._portlet;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public PortletRequestImpl getPortletRequest() {
        return this.portletRequestImpl;
    }

    @Override
    public Map<String, String[]> getProperties() {
        LinkedHashMap<String, String[]> properties = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, Object[]> entry : this._headers.entrySet()) {
            String name = entry.getKey();
            Object[] values = entry.getValue();
            String[] valuesString = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                valuesString[i] = values[i].toString();
            }
            properties.put(name, valuesString);
        }
        return properties;
    }

    public String getProperty(String key) {
        Object[] values = this._headers.get(key);
        if (values instanceof String[]) {
            return (String)values[0];
        }
        return null;
    }

    public Collection<String> getPropertyNames() {
        if (this._headers.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (Map.Entry<String, Object[]> entry : this._headers.entrySet()) {
            Object[] values = entry.getValue();
            if (!(values instanceof String[])) continue;
            propertyNames.add(entry.getKey());
        }
        return propertyNames;
    }

    public Collection<String> getPropertyValues(String key) {
        Object[] values = this._headers.get(key);
        if (values instanceof String[]) {
            return Arrays.asList((String[])values);
        }
        return Collections.emptySet();
    }

    public URLEncoder getUrlEncoder() {
        return this._urlEncoder;
    }

    public void init(PortletRequestImpl portletRequestImpl, HttpServletResponse httpServletResponse) {
        this.portletRequestImpl = portletRequestImpl;
        this.response = httpServletResponse;
        this._portlet = portletRequestImpl.getPortlet();
        this.portletName = this._portlet.getPortletId();
        this._companyId = this._portlet.getCompanyId();
        this.setPlid(portletRequestImpl.getPlid());
    }

    @Override
    public void setDateHeader(String name, long date) {
        if (Validator.isNull(name)) {
            throw new IllegalArgumentException();
        }
        if (date <= 0L) {
            this._headers.remove(name);
        } else {
            this._headers.put(name, new Long[]{date});
        }
    }

    @Override
    public void setHeader(String name, String value) {
        if (Validator.isNull(name)) {
            throw new IllegalArgumentException();
        }
        if (Validator.isNull(value)) {
            this._headers.remove(name);
        } else {
            this._headers.put(name, new String[]{value});
        }
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (Validator.isNull(name)) {
            throw new IllegalArgumentException();
        }
        if (value <= 0) {
            this._headers.remove(name);
        } else {
            this._headers.put(name, new Integer[]{value});
        }
    }

    public void setPlid(long plid) {
        Layout layout;
        this._plid = plid;
        if (this._plid <= 0L && (layout = (Layout)this.portletRequestImpl.getAttribute("LAYOUT")) != null) {
            this._plid = layout.getPlid();
        }
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.setHeader(key, value);
    }

    @Override
    public void setURLEncoder(URLEncoder urlEncoder) {
        this._urlEncoder = urlEncoder;
    }

    @Override
    public void transferHeaders(HttpServletResponse httpServletResponse) {
        TransferHeadersHelperUtil.transferHeaders(this._headers, httpServletResponse);
    }

    @Override
    public void transferMarkupHeadElements() {
        List<Element> elements = this._markupHeadElements.get("javax.portlet.markup.head.element");
        if (elements == null || elements.isEmpty()) {
            return;
        }
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        ArrayList<String> markupHeadElements = (ArrayList<String>)httpServletRequest.getAttribute("javax.portlet.markup.head.element");
        if (markupHeadElements == null) {
            markupHeadElements = new ArrayList<String>();
            httpServletRequest.setAttribute("javax.portlet.markup.head.element", markupHeadElements);
        }
        for (Element element : elements) {
            try {
                UnsyncStringWriter writer = new UnsyncStringWriter();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(element), new StreamResult(writer));
                markupHeadElements.add(((Object)writer).toString());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(e, e);
            }
        }
    }

    protected Layout getLayout(PortletRequest portletRequest, ThemeDisplay themeDisplay) {
        Layout layout = (Layout)portletRequest.getAttribute("LAYOUT");
        if (layout == null && themeDisplay != null) {
            layout = themeDisplay.getLayout();
        }
        return layout;
    }

    protected PortletPreferences getPortletSetup(ThemeDisplay themeDisplay, Layout layout, String portletName) {
        if (themeDisplay == null) {
            return PortletPreferencesFactoryUtil.getStrictLayoutPortletSetup(layout, portletName);
        }
        return themeDisplay.getStrictLayoutPortletSetup(layout, portletName);
    }
}

