/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.InvokerFilterContainer;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.InvokerPortletFactory;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletContextFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletInstanceFactory;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portlet.internal.InvokerFilterContainerImpl;
import com.liferay.portlet.internal.PortletBagUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerFieldUpdaterCustomizer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.servlet.ServletContext;

public class PortletInstanceFactoryImpl
implements PortletInstanceFactory {
    private InvokerPortletFactory _defaultInvokerPortletFactory;
    private volatile InvokerPortletFactory _invokerPortletFactory;
    private final Map<String, Map<String, InvokerPortlet>> _pool = new ConcurrentHashMap<String, Map<String, InvokerPortlet>>();
    private ServiceTracker<InvokerPortletFactory, InvokerPortletFactory> _serviceTracker;

    public void afterPropertiesSet() throws Exception {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(InvokerPortletFactory.class, new ServiceTrackerFieldUpdaterCustomizer<InvokerPortletFactory, InvokerPortletFactory>(ReflectionUtil.getDeclaredField(PortletInstanceFactoryImpl.class, "_invokerPortletFactory"), (Object)this, this._defaultInvokerPortletFactory){

            @Override
            protected void afterServiceUpdate(InvokerPortletFactory oldInvokerPortletFactory, InvokerPortletFactory newInvokerPortletFactory) {
                PortletInstanceFactoryImpl.this._pool.clear();
            }
        });
        this._serviceTracker.open();
    }

    @Override
    public void clear(Portlet portlet) {
        this.clear(portlet, true);
    }

    @Override
    public void clear(Portlet portlet, boolean resetRemotePortletBag) {
        PortletBag portletBag;
        String rootPortletId = portlet.getRootPortletId();
        Map<String, InvokerPortlet> portletInstances = this._pool.remove(rootPortletId);
        if (portletInstances != null) {
            InvokerPortlet rootInvokerPortletInstance = portletInstances.remove(rootPortletId);
            if (rootInvokerPortletInstance != null) {
                rootInvokerPortletInstance.destroy();
            }
            portletInstances.clear();
        }
        PortletApp portletApp = portlet.getPortletApp();
        if (resetRemotePortletBag && portletApp.isWARFile() && (portletBag = PortletBagPool.remove(rootPortletId)) != null) {
            portletBag.destroy();
        }
    }

    @Override
    public InvokerPortlet create(Portlet portlet, ServletContext servletContext) throws PortletException {
        return this.create(portlet, servletContext, false);
    }

    @Override
    public InvokerPortlet create(Portlet portlet, ServletContext servletContext, boolean destroyPrevious) throws PortletException {
        boolean deployed;
        if (destroyPrevious) {
            this.destroyRelated(portlet);
        }
        boolean instanceable = false;
        boolean bl = deployed = !portlet.isUndeployedPortlet();
        if (portlet.isInstanceable() && deployed && PortletIdCodec.hasInstanceId(portlet.getPortletId())) {
            instanceable = true;
        }
        String rootPortletId = portlet.getRootPortletId();
        InvokerPortlet rootInvokerPortletInstance = null;
        Map<String, InvokerPortlet> portletInstances = null;
        if (deployed) {
            portletInstances = this._pool.get(rootPortletId);
            if (portletInstances == null) {
                portletInstances = new ConcurrentHashMap<String, InvokerPortlet>();
                this._pool.put(rootPortletId, portletInstances);
            } else {
                InvokerPortlet instanceInvokerPortletInstance;
                if (instanceable && (instanceInvokerPortletInstance = portletInstances.get(portlet.getPortletId())) != null) {
                    return instanceInvokerPortletInstance;
                }
                rootInvokerPortletInstance = portletInstances.get(rootPortletId);
            }
        }
        if (rootInvokerPortletInstance == null) {
            PortletConfig portletConfig = PortletConfigFactoryUtil.create(portlet, servletContext);
            rootInvokerPortletInstance = this.init(portlet, portletConfig, PortletBagUtil.getPortletInstance(servletContext, portlet, rootPortletId));
            if (deployed) {
                portletInstances.put(rootPortletId, rootInvokerPortletInstance);
            }
        }
        if (!instanceable) {
            return rootInvokerPortletInstance;
        }
        javax.portlet.Portlet portletInstance = rootInvokerPortletInstance.getPortletInstance();
        PortletConfig portletConfig = PortletConfigFactoryUtil.create(portlet, servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        boolean checkAuthToken = rootInvokerPortletInstance.isCheckAuthToken();
        boolean facesPortlet = rootInvokerPortletInstance.isFacesPortlet();
        boolean headerPortlet = rootInvokerPortletInstance.isHeaderPortlet();
        InvokerPortlet instanceInvokerPortletInstance = this._invokerPortletFactory.create(portlet, portletInstance, portletConfig, portletContext, (InvokerFilterContainer)((Object)rootInvokerPortletInstance), checkAuthToken, facesPortlet, headerPortlet, false, false);
        if (deployed) {
            portletInstances.put(portlet.getPortletId(), instanceInvokerPortletInstance);
        }
        return instanceInvokerPortletInstance;
    }

    @Override
    public void delete(Portlet portlet) {
        Map<String, InvokerPortlet> portletInstances;
        if (PortletIdCodec.hasInstanceId(portlet.getPortletId()) && (portletInstances = this._pool.get(portlet.getRootPortletId())) != null) {
            portletInstances.remove(portlet.getPortletId());
        }
    }

    public void destroy() {
        this._serviceTracker.close();
    }

    @Override
    public void destroy(Portlet portlet) {
        this.clear(portlet);
        this.destroyRelated(portlet);
        PortletLocalServiceUtil.destroyPortlet(portlet);
    }

    public void setDefaultInvokerPortletFactory(InvokerPortletFactory defaultInvokerPortletFactory) {
        this._defaultInvokerPortletFactory = defaultInvokerPortletFactory;
        this._invokerPortletFactory = defaultInvokerPortletFactory;
    }

    protected void destroyRelated(Portlet portlet) {
        PortletConfigFactoryUtil.destroy(portlet);
        PortletContextFactoryUtil.destroy(portlet);
    }

    protected InvokerPortlet init(Portlet portlet, PortletConfig portletConfig, javax.portlet.Portlet portletInstance) throws PortletException {
        PortletContext portletContext = portletConfig.getPortletContext();
        InvokerFilterContainer invokerFilterContainer = InvokerFilterContainerImpl.EMPTY_INVOKER_FILTER_CONTAINER;
        if (!portlet.isUndeployedPortlet()) {
            invokerFilterContainer = new InvokerFilterContainerImpl(portlet, portletContext);
        }
        InvokerPortlet invokerPortlet = this._invokerPortletFactory.create(portlet, portletInstance, portletContext, invokerFilterContainer);
        invokerPortlet.init(portletConfig);
        return invokerPortlet;
    }
}

